/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.expressionevaluator.Grammar;
import org.gvsig.expressionevaluator.Statement;
import org.gvsig.expressionevaluator.impl.DefaultStatement;

public class DefaultGrammar
implements Grammar {
    private final String name;
    private final List<Statement> statements;
    private final Set<String> reservedWords;

    public DefaultGrammar(String name) {
        this.name = name;
        this.statements = new ArrayList<Statement>();
        this.reservedWords = new HashSet<String>();
    }

    public String getName() {
        return this.name;
    }

    public List<Statement> getStatements() {
        return Collections.unmodifiableList(this.statements);
    }

    public Statement createStatement(String name) {
        DefaultStatement stmt = new DefaultStatement(name);
        return stmt;
    }

    public void addStatement(Statement statement) {
        this.statements.add(statement);
    }

    public Statement getApplicableStatement(Statement.StatementContext context) {
        context.trace(this.getName() + ".getApplicableStatement");
        for (Statement statement : this.statements) {
            if (!statement.isApplicable(context)) continue;
            context.trace(this.getName() + ".getApplicableStatement return " + statement);
            return statement;
        }
        return null;
    }

    public String toString() {
        return this.getName();
    }

    public void addReservedWord(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return;
        }
        this.reservedWords.add(id.toUpperCase());
    }

    public boolean isReservedWord(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return false;
        }
        return this.reservedWords.contains(id.toUpperCase());
    }

    public Iterator<Statement> iterator() {
        return this.statements.iterator();
    }
}

