/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.swing.impl;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import org.gvsig.texteditor.JTextEditor;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.swing.api.viewer.ViewerFactory;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.gvsig.tools.swing.impl.ContextMenuUtils;

public class DefaultZoomDialog
extends JDialog {
    private static final long serialVersionUID = 7913363575200612492L;
    private String value = null;
    private JTextArea text = null;
    private int action = 2;
    private JButton btnClose;
    private List<Action> customActions;
    private JTextEditor viewer;

    public DefaultZoomDialog(Component parent, String title, WindowManager.MODE mode) {
        super(DefaultZoomDialog.getParentWindow(parent), title, mode == WindowManager.MODE.WINDOW ? Dialog.ModalityType.MODELESS : Dialog.ModalityType.DOCUMENT_MODAL);
    }

    public DefaultZoomDialog(Component parent, String title, String value, WindowManager.MODE mode, List<Action> customActions) {
        this(parent, title, mode);
        this.value = value;
        this.customActions = customActions;
        this.initComponents();
    }

    private static Window getParentWindow(Component c) {
        while (c != null) {
            if (c instanceof Window) {
                return (Window)c;
            }
            c = c.getParent();
        }
        return null;
    }

    public void setEditable(boolean editable) {
        if (this.viewer == null) {
            this.text.setEditable(editable);
        } else {
            this.viewer.setEditable(editable);
        }
        I18nManager i18n = ToolsLocator.getI18nManager();
        if (editable) {
            this.btnClose.setText(i18n.getTranslation("_Accept"));
        } else {
            this.btnClose.setText(i18n.getTranslation("_Close"));
        }
    }

    private void initComponents() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        ViewerFactory factory = ToolsSwingLocator.getToolsSwingManager().getViewerFactory("TextEditor");
        if (factory == null) {
            this.text = new JTextArea();
            this.text.setText(this.value);
            this.text.setLineWrap(true);
            this.text.setEnabled(true);
            JScrollPane scroll = new JScrollPane(this.text);
            panel.add((Component)scroll, "Center");
        } else {
            this.viewer = (JTextEditor)factory.createViewer();
            this.viewer.setContents((Object)this.value);
            panel.add((Component)this.viewer.asJComponent(), "Center");
        }
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel p = new JPanel();
        I18nManager i18n = ToolsLocator.getI18nManager();
        this.btnClose = new JButton(i18n.getTranslation("_Accept"));
        this.btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (DefaultZoomDialog.this.isEditable()) {
                    DefaultZoomDialog.this.value = DefaultZoomDialog.this.getTextContents();
                    DefaultZoomDialog.this.setAction(1);
                } else {
                    DefaultZoomDialog.this.setAction(2);
                }
                DefaultZoomDialog.this.setVisible(false);
            }
        });
        p.setLayout(new BorderLayout());
        p.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        p.add((Component)this.btnClose, "After");
        panel.add((Component)p, "Last");
        ContextMenuUtils.setDefaultContextMenu(this.text == null ? this.viewer.getJTextComponent() : this.text, false, null, this.customActions);
        this.setPreferredSize(ToolsSwingUtils.ensureRowsCols((Dimension)this.getPreferredSize(), (int)15, (int)100, (int)25, (int)150));
        this.setContentPane(panel);
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        panel.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultZoomDialog.this.setVisible(false);
                DefaultZoomDialog.this.setAction(2);
            }
        }, stroke, 2);
        this.center();
        this.pack();
    }

    public void center() {
        Dimension size = this.getPreferredSize();
        Rectangle r = this.getGraphicsConfiguration().getBounds();
        int x = (int)(((double)r.width - size.getWidth()) / 2.0) + r.x;
        int y = (int)(((double)r.height - size.getHeight()) / 2.0) + r.y;
        this.setLocation(x, y);
    }

    public String getText() {
        return this.value;
    }

    protected void setAction(int action) {
        this.action = action;
    }

    public int getAction() {
        return this.action;
    }

    private boolean isEditable() {
        return this.viewer == null ? this.text.isEditable() : this.viewer.isEditable();
    }

    private String getTextContents() {
        if (this.viewer == null) {
            return this.text.getText();
        }
        return (String)this.viewer.getContents();
    }
}

