/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.swing.impl.pickercontroller;

import java.nio.charset.Charset;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.tools.swing.api.pickercontroller.AbstractPickerController;
import org.gvsig.tools.swing.api.pickercontroller.CharsetPickerController;

public class CharsetPickerControllerImpl
extends AbstractPickerController<Charset>
implements CharsetPickerController {
    private final JLabel lblCharset;
    private final JComboBox cboCharset;

    public static void selfRegister() {
    }

    public CharsetPickerControllerImpl(JLabel lblCharset, JComboBox cboCharset) {
        this.lblCharset = lblCharset == null ? new JLabel() : lblCharset;
        this.cboCharset = cboCharset;
        this.fillCharsets(this.cboCharset);
        this.cboCharset.setSelectedItem(Charset.defaultCharset().name());
    }

    private void fillCharsets(JComboBox cboCharset) {
        SortedMap<String, Charset> charsets = Charset.availableCharsets();
        this.cboCharset.addItem("-");
        for (Map.Entry<String, Charset> entry : charsets.entrySet()) {
            this.cboCharset.addItem(entry.getKey());
        }
    }

    public boolean isEmpty() {
        Object item = this.cboCharset.getSelectedItem();
        String s = StringUtils.trim((String)Objects.toString(item, null));
        return item == null || StringUtils.isBlank((CharSequence)s) || "-".equals(s);
    }

    public void set(Charset charset) {
        if (charset == null) {
            this.cboCharset.setSelectedIndex(-1);
            return;
        }
        this.cboCharset.setSelectedItem(charset.name());
    }

    public Charset get() {
        if (this.isEmpty()) {
            return null;
        }
        return (Charset)Charset.availableCharsets().get((String)this.cboCharset.getSelectedItem());
    }

    public void setEnabled(boolean enabled) {
        this.lblCharset.setEnabled(enabled);
        this.cboCharset.setEnabled(enabled);
    }

    public boolean isEnabled() {
        return this.cboCharset.isEnabled();
    }

    protected Object coerce(int type, Object value, Object defaultValue) {
        if (value == null) {
            return null;
        }
        if (value instanceof Charset) {
            return value;
        }
        if (value instanceof String) {
            SortedMap<String, Charset> availableCharsets = Charset.availableCharsets();
            for (Map.Entry<String, Charset> entry : availableCharsets.entrySet()) {
                String key = entry.getKey();
                Charset charset = entry.getValue();
                if (!StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)((String)value))) continue;
                return charset;
            }
        }
        String s = value == null ? "null" : StringUtils.abbreviate((String)value.toString(), (int)100);
        LOG.warn("Can't coerce value (" + s + ") to Charset.");
        return defaultValue;
    }

    public void coerceAndSet(Object value) {
        if (value instanceof CharSequence) {
            try {
                value = Charset.forName(value.toString());
            }
            catch (Exception ex) {
                value = null;
            }
        }
        this.set((Charset)this.coerce(0, value, null));
    }
}

