/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.swing.impl.pickercontroller;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.folders.FoldersManager;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.swing.api.pickercontroller.AbstractPickerController;
import org.gvsig.tools.swing.api.pickercontroller.FilePickerController;
import org.gvsig.tools.swing.api.threadsafedialogs.ThreadSafeDialogsManager;

public class FilePickerControllerImpl
extends AbstractPickerController<File>
implements FilePickerController {
    private final JButton btnFile;
    private final JTextComponent txtFile;
    private final File initialPath;
    private final String fileChooserID;
    private final String dialogTitle;
    private File value;
    private FileFilter filter;

    public static void selfRegister() {
    }

    public FilePickerControllerImpl(JTextComponent txtFile, JButton btnFile, String dialogTitle) {
        this(txtFile, btnFile, dialogTitle, null, null, true);
    }

    public FilePickerControllerImpl(JTextComponent txtFile, JButton btnFile) {
        this(txtFile, btnFile, null, null, null, true);
    }

    public FilePickerControllerImpl(final JTextComponent txtFile, JButton btnFile, String dialogTitle, String fileChooserID, File initialPath, boolean seticon) {
        I18nManager i18n = ToolsLocator.getI18nManager();
        this.value = null;
        this.txtFile = txtFile;
        this.btnFile = btnFile;
        this.fileChooserID = fileChooserID;
        this.initialPath = initialPath;
        this.dialogTitle = dialogTitle == null ? i18n.getTranslation("_Select_file") : dialogTitle;
        ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
        toolsSwingManager.setDefaultPopupMenu(txtFile);
        toolsSwingManager.addClearButton(txtFile, e -> this.doClear());
        this.txtFile.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    FilePickerControllerImpl.this.coerceAndSet(txtFile.getText());
                    FilePickerControllerImpl.this.fireChangeEvent();
                }
                super.keyPressed(e);
            }
        });
        ToolsSwingUtils.configurePickersButton((AbstractButton)this.btnFile, (String)"_File_picker", (String)(seticon ? "picker-file" : null), e -> this.doSelectFile(), null);
    }

    private void doClear() {
        this.set(null);
    }

    public boolean isEmpty() {
        this.get();
        return this.value == null;
    }

    public File get() {
        this.coerceAndSet(this.txtFile.getText());
        return this.value;
    }

    public void set(File value) {
        this.value = value;
        if (value == null) {
            this.txtFile.setText("");
        } else {
            this.txtFile.setText(value.toString());
        }
    }

    public void setEditable(boolean editable) {
        super.setEditable(editable);
        this.txtFile.setEditable(editable);
    }

    public void setEnabled(boolean enabled) {
        this.btnFile.setEnabled(enabled);
        this.txtFile.setEnabled(enabled);
    }

    public boolean isEnabled() {
        return this.btnFile.isEnabled();
    }

    private void doSelectFile() {
        Object[] f;
        if (!this.isEditable()) {
            return;
        }
        ThreadSafeDialogsManager dialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
        FoldersManager folderManager = ToolsLocator.getFoldersManager();
        File pathToUse = this.initialPath;
        if (this.value != null) {
            pathToUse = this.value;
        }
        if (ArrayUtils.isEmpty((Object[])(f = dialogs.showChooserDialog(this.dialogTitle, 0, 0, true, folderManager.getLastPath(this.fileChooserID, pathToUse), this.filter, true)))) {
            return;
        }
        File file = new File(((File)f[0]).getPath());
        if (StringUtils.isNotBlank((CharSequence)this.fileChooserID)) {
            folderManager.setLastPath(this.fileChooserID, file);
        }
        this.set(file);
        this.fireChangeEvent();
    }

    public void coerceAndSet(Object value) {
        this.set((File)this.coerce(13, value, null));
    }

    public void setFileFilter(FileFilter filter) {
        this.filter = filter;
    }
}

