/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.swing.impl.zipviewer;

import java.util.Date;
import java.util.List;
import java.util.zip.ZipEntry;
import javax.swing.table.AbstractTableModel;

public class ZipTableModel
extends AbstractTableModel {
    public static final int NAME = 0;
    public static final int SIZE = 1;
    public static final int COMP_SIZE = 2;
    public static final int TYPE = 3;
    public static final int LAST_MODI = 4;
    private final String[] colNames = new String[]{"File Name", "Size", "Compressed Size", "Type", "Last Modified"};
    private final List<ZipEntry> entries;

    public ZipTableModel(List<ZipEntry> entries) {
        this.entries = entries;
    }

    @Override
    public int getColumnCount() {
        return this.colNames.length;
    }

    @Override
    public int getRowCount() {
        return this.entries.size();
    }

    @Override
    public String getColumnName(int col) {
        return this.colNames[col];
    }

    @Override
    public Object getValueAt(int row, int col) {
        ZipEntry entry = this.entries.get(row);
        switch (col) {
            case 0: {
                return entry.getName();
            }
            case 1: {
                if (entry.isDirectory()) {
                    return "";
                }
                return String.valueOf(entry.getSize() / 1000L) + " KB";
            }
            case 2: {
                if (entry.isDirectory()) {
                    return "";
                }
                return String.valueOf(entry.getCompressedSize() / 1000L) + " KB";
            }
            case 3: {
                if (entry.isDirectory()) {
                    return "Directory";
                }
                return "File";
            }
            case 4: {
                return String.valueOf(new Date(entry.getTime()));
            }
        }
        return "";
    }
}

