/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.utils.swing;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JTextField;
import javax.swing.plaf.basic.BasicComboBoxEditor;

public class JComboBox
extends javax.swing.JComboBox {
    public JComboBox() {
        this.init();
    }

    public JComboBox(Object[] arg0) {
        super(arg0);
        this.init();
    }

    public JComboBox(Vector arg0) {
        super(arg0);
        this.init();
    }

    public JComboBox(ComboBoxModel arg0) {
        super(arg0);
        this.init();
    }

    private void init() {
        this.setEditor(new BasicComboBoxEditor());
        JTextField jtext = (JTextField)this.getEditor().getEditorComponent();
        jtext.addKeyListener(new MyKeyListener());
        jtext.setText("");
    }

    public class MyKeyListener
    implements KeyListener {
        private int lastCaretPosition = 0;
        private String lastText = "";
        private boolean bAutocompletar = true;

        private String isInModel(String text) {
            DefaultComboBoxModel model = (DefaultComboBoxModel)JComboBox.this.getModel();
            for (int i = 0; i < model.getSize(); ++i) {
                if (!model.getElementAt(i).toString().startsWith(text)) continue;
                return model.getElementAt(i).toString();
            }
            return null;
        }

        public void actionPerformed(ActionEvent arg0) {
            JTextField jtext = (JTextField)JComboBox.this.getEditor().getEditorComponent();
            String texto = jtext.getText();
            String text = this.isInModel(texto);
            if (text != null) {
                int caretPos = texto.length();
                jtext.setText(text);
                jtext.setCaretPosition(caretPos);
                jtext.setSelectionStart(caretPos);
                jtext.setSelectionEnd(text.length());
            }
        }

        @Override
        public void keyPressed(KeyEvent e) {
            JTextField jtext = (JTextField)JComboBox.this.getEditor().getEditorComponent();
            this.bAutocompletar = true;
            if (e.getKeyCode() == 8 || e.getKeyCode() == 127) {
                this.bAutocompletar = false;
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
            JTextField jtext = (JTextField)JComboBox.this.getEditor().getEditorComponent();
            String texto = jtext.getText().substring(0, jtext.getCaretPosition());
            if (!this.bAutocompletar) {
                return;
            }
            String text = this.isInModel(texto);
            if (!jtext.getText().equals(this.lastText) && text != null) {
                int caretPos = texto.length();
                jtext.setText(text);
                jtext.setCaretPosition(text.length());
                jtext.moveCaretPosition(caretPos);
                this.lastText = text;
                this.lastCaretPosition = caretPos;
                JComboBox.this.setSelectedItem(text);
            } else {
                this.lastCaretPosition = jtext.getCaretPosition();
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }
    }
}

