/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.json;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;
import javax.json.JsonWriter;
import javax.json.JsonWriterFactory;
import org.gvsig.json.JsonManagerImpl;

public class JsonObjectImpl
implements JsonObject {
    private final JsonObject jsonObject;

    public JsonObjectImpl(JsonObject jsonObject) {
        this.jsonObject = jsonObject;
    }

    public JsonArray getJsonArray(String name) {
        JsonValue value = (JsonValue)this.jsonObject.get((Object)name);
        return (JsonArray)JsonManagerImpl.wrap(value);
    }

    public JsonObject getJsonObject(String name) {
        JsonValue value = (JsonValue)this.jsonObject.get((Object)name);
        return (JsonObject)JsonManagerImpl.wrap(value);
    }

    public JsonNumber getJsonNumber(String name) {
        JsonValue value = (JsonValue)this.jsonObject.get((Object)name);
        if (value == null || value == JsonValue.NULL) {
            return null;
        }
        return (JsonNumber)value;
    }

    public JsonString getJsonString(String name) {
        JsonValue value = (JsonValue)this.jsonObject.get((Object)name);
        if (value == null || value == JsonValue.NULL) {
            return null;
        }
        return (JsonString)value;
    }

    public String getString(String name) {
        JsonValue value = (JsonValue)this.jsonObject.get((Object)name);
        if (value == null || value == JsonValue.NULL) {
            return null;
        }
        return ((JsonString)value).getString();
    }

    public String getString(String name, String defaultValue) {
        JsonValue value = (JsonValue)this.jsonObject.get((Object)name);
        if (value == null || value == JsonValue.NULL) {
            return defaultValue;
        }
        return ((JsonString)value).getString();
    }

    public int getInt(String name) {
        return this.jsonObject.getInt(name);
    }

    public int getInt(String name, int defaultValue) {
        return this.jsonObject.getInt(name, defaultValue);
    }

    public boolean getBoolean(String name) {
        return this.jsonObject.getBoolean(name);
    }

    public boolean getBoolean(String name, boolean defaultValue) {
        return this.jsonObject.getBoolean(name, defaultValue);
    }

    public boolean isNull(String name) {
        return this.jsonObject.isNull(name);
    }

    public JsonValue.ValueType getValueType() {
        return this.jsonObject.getValueType();
    }

    public int size() {
        return this.jsonObject.size();
    }

    public boolean isEmpty() {
        return this.jsonObject.isEmpty();
    }

    public boolean containsKey(Object key) {
        return this.jsonObject.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.jsonObject.containsValue(value);
    }

    public JsonValue get(Object key) {
        JsonValue value = (JsonValue)this.jsonObject.get(key);
        return JsonManagerImpl.wrap(value);
    }

    public JsonValue put(String key, JsonValue value) {
        return (JsonValue)this.jsonObject.put((Object)key, (Object)value);
    }

    public JsonValue remove(Object key) {
        return (JsonValue)this.jsonObject.remove(key);
    }

    public void putAll(Map<? extends String, ? extends JsonValue> m) {
        this.jsonObject.putAll(m);
    }

    public void clear() {
        this.jsonObject.clear();
    }

    public Set<String> keySet() {
        return this.jsonObject.keySet();
    }

    public Collection<JsonValue> values() {
        return this.jsonObject.values();
    }

    public Set<Map.Entry<String, JsonValue>> entrySet() {
        return this.jsonObject.entrySet();
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        JsonWriterFactory writerFactory = Json.createWriterFactory(Collections.singletonMap("javax.json.stream.JsonGenerator.prettyPrinting", true));
        try (JsonWriter jsonWriter = writerFactory.createWriter((Writer)sw);){
            jsonWriter.writeObject(this.jsonObject);
        }
        String s = sw.toString();
        return s;
    }
}

