/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.andami.preferences;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.preferences.AbstractPreferencePage;
import org.gvsig.andami.preferences.IPreference;
import org.gvsig.andami.preferences.StoreException;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.andami.ui.mdiManager.WindowInfo;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.extensionpoint.ExtensionPoint;
import org.gvsig.tools.extensionpoint.ExtensionPointManager;
import org.gvsig.tools.identitymanagement.SimpleIdentityManager;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericDlgPreferences
extends JPanel
implements IWindow {
    private static Logger logger = LoggerFactory.getLogger(GenericDlgPreferences.class);
    private static final long serialVersionUID = -6561660591523322611L;
    private WindowInfo viewInfo = null;
    private IPreference activePreference;
    private Map<String, IPreference> preferences = new Hashtable<String, IPreference>();
    DefaultTreeModel treeModel = null;
    private JTree jTreePlugins = null;
    private JPanel jPanelButtons = null;
    private JButton jButtonOK = null;
    private JButton jButtonCancel = null;
    private DefaultMutableTreeNode root = new DefaultMutableTreeNode();
    private JPanel jPanelCenter = null;
    private JLabel jLabelBigTitle = null;
    private JScrollPane jScrollPane = null;
    private JSplitPane jSplitPaneCenter = null;
    private JPanel jPanelContainer = null;
    private JButton jButtonRestore;
    private ActionListener action;
    private boolean dirtyTree = false;
    private ExtensionPointManager extensionPoints = ToolsLocator.getExtensionPointManager();

    public GenericDlgPreferences() {
        this.action = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PluginServices.getMDIManager().setWaitCursor();
                String actionCommand = e.getActionCommand();
                if ("RESTORE".equals(actionCommand)) {
                    if (GenericDlgPreferences.this.activePreference != null) {
                        GenericDlgPreferences.this.activePreference.initializeDefaults();
                    }
                } else {
                    Iterator it = GenericDlgPreferences.this.preferences.keySet().iterator();
                    if ("CANCEL".equals(actionCommand)) {
                        while (it.hasNext()) {
                            IPreference pref = (IPreference)GenericDlgPreferences.this.preferences.get(it.next());
                            if (!pref.isValueChanged()) continue;
                            pref.initializeValues();
                        }
                        GenericDlgPreferences.this.closeView();
                    } else if ("OK".equals(actionCommand)) {
                        boolean shouldClose = true;
                        while (it.hasNext()) {
                            IPreference preference = (IPreference)GenericDlgPreferences.this.preferences.get(it.next());
                            try {
                                if (!preference.isValueChanged()) continue;
                                preference.saveValues();
                                preference.initializeValues();
                            }
                            catch (StoreException ex) {
                                shouldClose = false;
                                PluginServices.getMDIManager().restoreCursor();
                                JOptionPane.showMessageDialog((Component)((Object)PluginServices.getMainFrame()), ex.getMessage());
                                GenericDlgPreferences.this.setActivePage(preference);
                            }
                        }
                        if (shouldClose) {
                            GenericDlgPreferences.this.closeView();
                        }
                    }
                }
                PluginServices.getMDIManager().restoreCursor();
            }
        };
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(750, 479));
        super.add((Component)this.getJPanelButtons(), "South");
        this.setPreferredSize(new Dimension(390, 369));
        super.add((Component)this.getJSplitPaneCenter(), "Center");
        this.getJSplitPaneCenter().setLeftComponent(this.getJScrollPane());
        this.getJSplitPaneCenter().setRightComponent(this.getJPanelNorth());
        this.treeModel = new DefaultTreeModel(this.root);
    }

    public void refreshExtensionPoints() {
        ExtensionPoint ep = this.extensionPoints.add("AplicationPreferences", "");
        Iterator iterator = ep.iterator();
        while (iterator.hasNext()) {
            String preferencesPageName = "Unkown";
            try {
                IPreference page;
                ExtensionPoint.Extension epe;
                Object obj = iterator.next();
                if (obj != null) {
                    preferencesPageName = obj.getClass().getName();
                }
                if ((epe = (ExtensionPoint.Extension)obj) != null) {
                    preferencesPageName = epe.getName();
                }
                if ((page = (IPreference)epe.create()) != null) {
                    preferencesPageName = page.getID();
                }
                this.addPreferencePage(page);
            }
            catch (ConcurrentModificationException e1) {
                logger.warn("Can't initialize preferences page '" + preferencesPageName + "'.", (Throwable)e1);
                return;
            }
            catch (Exception e) {
                logger.warn("Can't initialize preferences page '" + preferencesPageName + "'.", (Throwable)e);
            }
        }
        ArrayList<IPreference> prefList = new ArrayList<IPreference>(this.preferences.values());
        this.addPreferencePages(prefList);
    }

    public void storeValues() {
        for (IPreference preference : this.preferences.values()) {
            try {
                preference.saveValues();
            }
            catch (StoreException e) {
                PluginServices.getMDIManager().restoreCursor();
                JOptionPane.showMessageDialog((Component)((Object)PluginServices.getMainFrame()), e.getMessage());
            }
        }
    }

    @Override
    public Component add(Component c) {
        throw new Error("Do not use org.gvsig.app.gui.preferences.DlgPreferences.add(Component) register an extension point instead");
    }

    @Override
    public Component add(Component c, int i) {
        return this.add(c);
    }

    @Override
    public void add(Component c, Object o) {
        this.add(c);
    }

    @Override
    public void add(Component c, Object o, int i) {
        this.add(c);
    }

    @Override
    public WindowInfo getWindowInfo() {
        if (this.viewInfo == null) {
            this.viewInfo = new WindowInfo(41);
            this.viewInfo.setTitle(PluginServices.getText(this, "Preferences"));
            Dimension dim = ToolsSwingUtils.ensureRowsCols((JComponent)this, (int)27, (int)115);
            this.viewInfo.setWidth(dim.width);
            this.viewInfo.setHeight(dim.height);
        }
        return this.viewInfo;
    }

    private JTree getJTreePlugins() {
        if (this.jTreePlugins == null) {
            this.jTreePlugins = new JTree();
            this.jTreePlugins.setRootVisible(false);
            MyTreeCellRenderer treeCellRenderer = new MyTreeCellRenderer();
            treeCellRenderer.setOpenIcon(null);
            treeCellRenderer.setClosedIcon(null);
            treeCellRenderer.setLeafIcon(null);
            this.jTreePlugins.setCellRenderer(treeCellRenderer);
            this.jTreePlugins.setShowsRootHandles(true);
            this.jTreePlugins.addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent e) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)GenericDlgPreferences.this.jTreePlugins.getLastSelectedPathComponent();
                    if (node == null) {
                        return;
                    }
                    GenericDlgPreferences.this.setActivePage((IPreference)node.getUserObject());
                }
            });
            this.jTreePlugins.putClientProperty("JTree.linestyle", "Angled");
            this.jTreePlugins.getSelectionModel().setSelectionMode(1);
        }
        return this.jTreePlugins;
    }

    public void addPreferencePage(IPreference page) {
        if (this.preferences.containsKey(page.getID())) {
            return;
        }
        SimpleIdentityManager identityManager = ToolsLocator.getIdentityManager();
        if (!identityManager.getCurrentIdentity().isAuthorized("property-page-access", (Object)page, page.getID())) {
            return;
        }
        this.preferences.put(page.getID(), page);
        page.initializeValues();
        if (this.dirtyTree) {
            DefaultTreeModel model;
            this.dirtyTree = false;
            this.treeModel = model = new DefaultTreeModel(this.root);
            this.jTreePlugins.setModel(model);
        }
        this.doInsertNode(this.treeModel, page);
        this.getJTreePlugins().setModel(this.treeModel);
        this.getJTreePlugins().repaint();
    }

    private void addPreferencePages(List<IPreference> prefs) {
        while (prefs.size() > 0) {
            IPreference pref = prefs.get(0);
            if (pref.getParentID() != null && this.preferences.get(pref.getParentID()) == null) {
                prefs.remove(pref);
                this.addPreferencePages(prefs);
                this.addPreference(pref);
                continue;
            }
            this.addPreference(pref);
            prefs.remove(pref);
        }
    }

    private void addPreference(IPreference pref) {
        DefaultTreeModel model = new DefaultTreeModel(this.root);
        this.doInsertNode(model, pref);
    }

    private DefaultMutableTreeNode findNode(String searchID) {
        Enumeration<TreeNode> e = this.root.breadthFirstEnumeration();
        while (e.hasMoreElements()) {
            IPreference pref;
            DefaultMutableTreeNode nodeAux = (DefaultMutableTreeNode)e.nextElement();
            if (nodeAux == null || (pref = (IPreference)nodeAux.getUserObject()) == null || !pref.getID().equals(searchID)) continue;
            return nodeAux;
        }
        return null;
    }

    private void doInsertNode(DefaultTreeModel treeModel, IPreference page) {
        boolean bl = this.dirtyTree = page.getParentID() != null && this.findNode(page.getParentID()) == null;
        if (this.findNode(page.getID()) != null) {
            return;
        }
        if (page.getParentID() != null) {
            if (this.preferences.containsKey(page.getParentID())) {
                IPreference parent = this.preferences.get(page.getParentID());
                DefaultMutableTreeNode nodeParent = this.findNode(parent.getID());
                if (nodeParent == null) {
                    this.doInsertNode(treeModel, parent);
                } else {
                    DefaultMutableTreeNode nodeValue = new DefaultMutableTreeNode(page);
                    int children = nodeParent.getChildCount();
                    int pos = 0;
                    for (int i = 0; i < children; ++i) {
                        String pageTitle;
                        DefaultMutableTreeNode node = (DefaultMutableTreeNode)treeModel.getChild(nodeParent, i);
                        if (!(node.getUserObject() instanceof IPreference) || (pageTitle = ((IPreference)node.getUserObject()).getTitle()).compareTo(page.getTitle()) >= 0) continue;
                        ++pos;
                    }
                    treeModel.insertNodeInto(nodeValue, nodeParent, pos);
                }
            }
        } else {
            DefaultMutableTreeNode nodeValue = new DefaultMutableTreeNode(page);
            int children = this.root.getChildCount();
            int pos = 0;
            for (int i = 0; i < children; ++i) {
                String pageTitle;
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)treeModel.getChild(this.root, i);
                if (!(node.getUserObject() instanceof IPreference) || (pageTitle = ((IPreference)node.getUserObject()).getTitle()).compareTo(page.getTitle()) >= 0) continue;
                ++pos;
            }
            treeModel.insertNodeInto(nodeValue, this.root, pos);
        }
    }

    private JPanel getJPanelButtons() {
        if (this.jPanelButtons == null) {
            this.jPanelButtons = new JPanel(new BorderLayout());
            JPanel jPanelAux = new JPanel();
            JLabel l = new JLabel();
            l.setPreferredSize(new Dimension(40, 20));
            this.jPanelButtons.add((Component)new JSeparator(0), "North");
            jPanelAux.add((Component)this.getJButtonRestore(), "West");
            jPanelAux.add((Component)l, "Center");
            jPanelAux.add((Component)this.getJButtonOK(), "East");
            jPanelAux.add((Component)this.getJButtonCancel(), "East");
            this.jPanelButtons.add(jPanelAux);
        }
        return this.jPanelButtons;
    }

    private JButton getJButtonOK() {
        if (this.jButtonOK == null) {
            this.jButtonOK = new JButton();
            this.jButtonOK.setText(PluginServices.getText(this, "aceptar"));
            this.jButtonOK.setActionCommand("OK");
            this.jButtonOK.addActionListener(this.action);
        }
        return this.jButtonOK;
    }

    private JButton getJButtonRestore() {
        if (this.jButtonRestore == null) {
            this.jButtonRestore = new JButton();
            this.jButtonRestore.setText(PluginServices.getText(this, "restore_defaults"));
            this.jButtonRestore.setActionCommand("RESTORE");
            this.jButtonRestore.addActionListener(this.action);
        }
        return this.jButtonRestore;
    }

    private void closeView() {
        PluginServices.getMDIManager().closeWindow(this);
    }

    private JButton getJButtonCancel() {
        if (this.jButtonCancel == null) {
            this.jButtonCancel = new JButton();
            this.jButtonCancel.setText(PluginServices.getText(this, "cancelar"));
            this.jButtonCancel.setActionCommand("CANCEL");
            this.jButtonCancel.addActionListener(this.action);
        }
        return this.jButtonCancel;
    }

    private JPanel getJPanelNorth() {
        if (this.jPanelCenter == null) {
            this.jLabelBigTitle = new JLabel();
            this.jLabelBigTitle.setText("General");
            Font font = this.jLabelBigTitle.getFont();
            font = font.deriveFont(1, (float)font.getSize() + 1.0f);
            this.jLabelBigTitle.setFont(font);
            this.jLabelBigTitle.setHorizontalTextPosition(11);
            this.jLabelBigTitle.setHorizontalAlignment(0);
            this.jPanelCenter = new JPanel();
            JPanel jPanelPageTitle = new JPanel(new BorderLayout());
            JPanel jPanelAux = new JPanel(new BorderLayout());
            jPanelAux.add((Component)this.jLabelBigTitle, "North");
            jPanelPageTitle.add((Component)jPanelAux, "West");
            jPanelPageTitle.add((Component)new JSeparator(0), "South");
            this.jPanelCenter.setLayout(new BorderLayout());
            this.jPanelCenter.add((Component)jPanelPageTitle, "North");
            this.jPanelCenter.add((Component)this.getJPanelContainer(), "Center");
        }
        return this.jPanelCenter;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setPreferredSize(new Dimension(140, 322));
            this.jScrollPane.setViewportView(this.getJTreePlugins());
        }
        return this.jScrollPane;
    }

    private JSplitPane getJSplitPaneCenter() {
        if (this.jSplitPaneCenter == null) {
            this.jSplitPaneCenter = new JSplitPane();
            this.jSplitPaneCenter.setResizeWeight(0.2);
            this.jSplitPaneCenter.setDividerLocation(200);
        }
        return this.jSplitPaneCenter;
    }

    private JPanel getJPanelContainer() {
        if (this.jPanelContainer == null) {
            this.jPanelContainer = new JPanel();
        }
        return this.jPanelContainer;
    }

    public void setActivePage(IPreference page) {
        this.activePreference = page;
        this.jLabelBigTitle.setText(this.activePreference.getTitle());
        JPanel prefPanel = this.activePreference.getPanel();
        this.jLabelBigTitle.setIcon(this.activePreference.getIcon());
        this.jPanelContainer.removeAll();
        if (prefPanel instanceof AbstractPreferencePage && ((AbstractPreferencePage)((Object)prefPanel)).isResizeable()) {
            this.jPanelContainer.setLayout(new BorderLayout());
            this.jPanelContainer.add((Component)prefPanel, "Center");
        } else {
            this.jPanelContainer.setLayout(new FlowLayout());
            this.jPanelContainer.add(prefPanel);
        }
        prefPanel.setVisible(true);
        this.repaint();
    }

    @Override
    public Object getWindowProfile() {
        return WindowInfo.DIALOG_PROFILE;
    }

    private class MyTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 1833782141342096776L;

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            DefaultMutableTreeNode node;
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (value instanceof DefaultMutableTreeNode && (node = (DefaultMutableTreeNode)value).getUserObject() instanceof IPreference) {
                IPreference pref = (IPreference)node.getUserObject();
                this.setText(pref.getTitle());
            }
            return this;
        }
    }
}

