/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.gui.beans;

import com.jeta.forms.components.panel.FormPanel;
import com.jeta.forms.gui.beans.BeanProperties;
import com.jeta.forms.gui.beans.DynamicBeanInfo;
import com.jeta.forms.gui.common.FormException;
import com.jeta.forms.gui.common.FormUtils;
import com.jeta.forms.logger.FormsLogger;
import com.jeta.forms.store.bean.BeanDeserializer;
import com.jeta.forms.store.bean.BeanSerializer;
import com.jeta.forms.store.bean.BeanSerializerFactory;
import com.jeta.forms.store.memento.BeanMemento;
import com.jeta.forms.store.memento.PropertiesMemento;
import com.jeta.forms.store.memento.StateRequest;
import com.jeta.forms.store.properties.JETAProperty;
import com.jeta.forms.store.properties.TransformProperty;
import com.jeta.open.registry.JETARegistry;
import com.jeta.open.support.EmptyCollection;
import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.XMLDecoder;
import java.io.ByteArrayInputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;

public class JETABean
extends JPanel {
    private Component m_delegate;
    private DynamicBeanInfo m_beaninfo;
    private HashMap m_custom_properties = new HashMap();

    public JETABean() {
        this.setOpaque(false);
    }

    public JETABean(Component delegate, BeanProperties customProperties) throws FormException {
        this.setOpaque(false);
        try {
            this.m_delegate = delegate;
            if (customProperties != null) {
                this.m_beaninfo = customProperties.getBeanInfo();
                Iterator iter = customProperties.getPropertyValues().iterator();
                while (iter.hasNext()) {
                    JETAProperty prop = (JETAProperty)iter.next();
                    this.m_custom_properties.put(prop.getName(), prop);
                }
            }
            if (delegate != null) {
                this.initialize();
            }
        }
        catch (Exception e) {
            FormsLogger.severe(e);
        }
    }

    public JETABean(Component delegate) throws FormException {
        try {
            this.setOpaque(false);
            this.m_delegate = delegate;
            this.initialize();
        }
        catch (Exception e) {
            System.out.println(">>>>>> JETABean initialized failed for delegate: " + this.m_delegate);
            e.printStackTrace();
        }
    }

    public DynamicBeanInfo getBeanInfo() {
        if (this.m_beaninfo == null) {
            try {
                if (this.m_delegate != null) {
                    BeanInfo info = Introspector.getBeanInfo(this.m_delegate.getClass());
                    this.m_beaninfo = new DynamicBeanInfo(info, null);
                }
            }
            catch (Exception e) {
                FormsLogger.severe(e);
            }
        }
        return this.m_beaninfo;
    }

    public JETAProperty getCustomProperty(String propName) {
        return (JETAProperty)this.m_custom_properties.get(propName);
    }

    public Component getDelegate() {
        return this.m_delegate;
    }

    public Component getBeanChildComponent() {
        if (this.getComponentCount() > 0) {
            return this.getComponent(0);
        }
        if (this.getComponentCount() == 0 && this.getDelegate() != null) {
            return this.getDelegate();
        }
        return null;
    }

    public String getBeanName() {
        if (this.m_delegate == null) {
            return null;
        }
        return this.m_delegate.getName();
    }

    public Collection getPropertyDescriptors() {
        DynamicBeanInfo binfo = this.getBeanInfo();
        if (binfo != null) {
            return binfo.getPropertyDescriptors();
        }
        return EmptyCollection.getInstance();
    }

    public void getState(BeanMemento memento, StateRequest sr) throws FormException {
        try {
            memento.setJETABeanClass(this.getClass().getName());
            if (this.m_delegate != null && this.m_delegate.getClass() != null) {
                memento.setBeanClass(this.m_delegate.getClass().getName());
                BeanSerializerFactory fac = (BeanSerializerFactory)JETARegistry.lookup("bean.serializer.factory");
                if (fac != null) {
                    BeanSerializer bs = fac.createSerializer();
                    memento.setProperties(bs.writeBean(this));
                } else {
                    FormUtils.safeAssert(false);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initialize() throws FormException {
        try {
            this.removeAll();
            if (this.m_delegate != null) {
                this.setLayout(new BorderLayout());
                this.add(this.m_delegate, "Center");
                Collection props = this.m_custom_properties.values();
                Iterator iter = props.iterator();
                while (iter.hasNext()) {
                    JETAProperty jprop = (JETAProperty)iter.next();
                    jprop.updateBean(this);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setCustomProperty(String propName, JETAProperty prop) {
        this.m_custom_properties.put(propName, prop);
    }

    public void setName(String name) {
        FormUtils.safeAssert(false);
    }

    public void setState(BeanMemento memento) throws FormException {
        try {
            PropertiesMemento props_memento = memento.getProperties();
            if (props_memento != null) {
                this.setState(props_memento);
            } else {
                this.setStateOld(memento);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setState(PropertiesMemento props_memento) throws FormException {
        try {
            if (props_memento != null) {
                this.removeAll();
                this.setLayout(new BorderLayout());
                this.m_delegate = null;
                BeanSerializerFactory fac = (BeanSerializerFactory)JETARegistry.lookup("bean.serializer.factory");
                if (fac != null) {
                    BeanDeserializer bds = fac.createDeserializer(props_memento);
                    this.m_delegate = bds.createBean();
                    if (this.m_delegate != null) {
                        this.add(this.m_delegate, "Center");
                        Collection props = this.m_custom_properties.values();
                        Iterator iter = props.iterator();
                        while (iter.hasNext()) {
                            JETAProperty jprop = (JETAProperty)iter.next();
                            if (!(jprop instanceof TransformProperty)) continue;
                            ((TransformProperty)((Object)jprop)).setBean(this);
                        }
                        bds.initializeBean(this);
                    }
                } else {
                    FormUtils.safeAssert(false);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setStateOld(BeanMemento memento) {
        try {
            Collection custom_props;
            byte[] xml_data = memento.getBeanXML();
            byte[] xml = memento.getBeanXML();
            if (xml == null) {
                return;
            }
            XMLDecoder d = new XMLDecoder(new ByteArrayInputStream(xml));
            this.m_delegate = (Component)d.readObject();
            if (this.m_delegate == null) {
                return;
            }
            if (this.m_delegate instanceof JList) {
                ((JList)this.m_delegate).setModel(new DefaultListModel());
            }
            if ((custom_props = memento.getCustomProperties()) != null) {
                Iterator iter = custom_props.iterator();
                while (iter.hasNext()) {
                    JETAProperty prop = (JETAProperty)iter.next();
                    JETAProperty default_prop = this.getCustomProperty(prop.getName());
                    if (default_prop != null) {
                        if (default_prop instanceof TransformProperty) continue;
                        default_prop.setValue(prop);
                        continue;
                    }
                    if (prop instanceof TransformProperty) continue;
                    FormsLogger.debug("JETABean.setState getCustomProperty failed: " + prop.getName() + "  " + prop);
                }
            }
            this.initialize();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void postInitialize(FormPanel panel) {
        Collection props = this.m_custom_properties.values();
        Iterator iter = props.iterator();
        while (iter.hasNext()) {
            JETAProperty jprop = (JETAProperty)iter.next();
            jprop.postInitialize(panel, this);
        }
    }
}

