/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gui.beans.swing;

import java.awt.Component;
import java.awt.HeadlessException;
import java.io.File;
import java.util.Hashtable;
import javax.swing.filechooser.FileSystemView;

public class JFileChooser
extends javax.swing.JFileChooser {
    private static final long serialVersionUID = -2419775752576400974L;
    private static Hashtable<String, File> jfcLastPaths = new Hashtable();
    private String fileChooserID;

    public JFileChooser(String fileChooserID, File defaultDirectory) {
        this.setDragEnabled(true);
        if (fileChooserID == null) {
            throw new IllegalArgumentException("JFileChooser's ID cannot be null");
        }
        this.fileChooserID = fileChooserID;
        this.setCurrentDirectory(JFileChooser.getLastPath(fileChooserID, defaultDirectory));
    }

    public static File getLastPath(String fileChooserID, File defaultDirectory) {
        File path = jfcLastPaths.get(fileChooserID);
        if (path != null) {
            return path;
        }
        if (defaultDirectory != null) {
            return defaultDirectory;
        }
        return FileSystemView.getFileSystemView().getHomeDirectory();
    }

    public File getLastPath(File defaultDirectory) {
        return JFileChooser.getLastPath(this.fileChooserID, defaultDirectory);
    }

    public File getLastPath() {
        return JFileChooser.getLastPath(this.fileChooserID, this.getCurrentDirectory());
    }

    public static void setLastPath(String fileChooserID, File path) {
        jfcLastPaths.put(fileChooserID, path);
    }

    public void setLastPath(File path) {
        JFileChooser.setLastPath(this.fileChooserID, path);
    }

    public JFileChooser(String fileChooserID, String defaultDirectory) {
        this(fileChooserID, defaultDirectory != null ? new File(defaultDirectory) : null);
    }

    public JFileChooser(String fileChooserID, FileSystemView fsv) {
        this(fileChooserID, (File)null, fsv);
    }

    public JFileChooser(String fileChooserID, File defaultDirectory, FileSystemView fsv) {
        this(fileChooserID, defaultDirectory);
        this.setup(fsv);
    }

    public JFileChooser(String fileChooserID, String defaultDirectoryPath, FileSystemView fsv) {
        this(fileChooserID, new File(defaultDirectoryPath), fsv);
    }

    @Override
    public int showDialog(Component parent, String approveButtonText) throws HeadlessException {
        super.setCurrentDirectory(this.getLastPath());
        int response = super.showDialog(parent, approveButtonText);
        if (this.getSelectedFile() != null && this.getSelectedFile().isDirectory()) {
            JFileChooser.setLastPath(this.fileChooserID, this.getSelectedFile());
        } else {
            JFileChooser.setLastPath(this.fileChooserID, this.getCurrentDirectory());
        }
        return response;
    }
}

