/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.util;

import java.util.EventListener;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseListenerSupport {
    protected static final Logger LOGGER = LoggerFactory.getLogger(BaseListenerSupport.class);
    protected Set<EventListener> listeners = new HashSet<EventListener>();

    public void addListener(EventListener listener) {
        this.listeners.add(listener);
    }

    public EventListener[] getListeners() {
        return this.listeners.toArray(new EventListener[this.listeners.size()]);
    }

    public boolean hasListeners() {
        return !this.listeners.isEmpty();
    }

    public void removeListener(EventListener listener) {
        this.listeners.remove(listener);
    }

    public void removeAllListener() {
        this.listeners.clear();
    }

    public void notifyEvent(EventListener event) {
        for (EventListener listener : this.listeners) {
            if (!(listener instanceof NotificationListener)) continue;
            try {
                ((NotificationListener)listener).notify(event);
            }
            catch (Throwable th) {
                LOGGER.warn("Problems notifying " + (event == null ? "NULL" : event.getClass().getSimpleName()) + " to " + listener.getClass().getSimpleName());
            }
        }
    }

    public static interface NotificationListener
    extends EventListener {
        public void notify(EventListener var1);
    }
}

