/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.htmlBrowser;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.gvsig.htmlBrowser.HtmlBrowserPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleHtmlBrowserPanel
extends HtmlBrowserPanel
implements HyperlinkListener {
    private static final long serialVersionUID = 2222495134882233629L;
    private static final Logger LOG = LoggerFactory.getLogger(SimpleHtmlBrowserPanel.class);
    public JEditorPane htmlPane;
    public JScrollPane scroll;

    public SimpleHtmlBrowserPanel() {
        this.setLayout(new BorderLayout());
        this.htmlPane = new JEditorPane();
        this.htmlPane.setContentType("text/html");
        this.htmlPane.setEditable(false);
        this.scroll = new JScrollPane(this.htmlPane);
        this.add((Component)this.scroll, "Center");
    }

    @Override
    public void navigate(URL url) {
        try {
            this.htmlPane.setPage(url);
        }
        catch (IOException e) {
            this.htmlPane.setText("Error reading html content");
            LOG.error("Error reading html content from URL: " + url, (Throwable)e);
        }
    }

    @Override
    public void setText(String text) {
        this.htmlPane.setText(text);
        this.htmlPane.setCaretPosition(0);
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent event) {
        if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            try {
                this.htmlPane.setPage(event.getURL());
            }
            catch (IOException ioe) {
                this.htmlPane.setText("Error reading html content");
                LOG.error("Error reading html content from URL: " + event.getURL(), (Throwable)ioe);
            }
        }
    }

    public JEditorPane getJEditorPane() {
        return this.htmlPane;
    }
}

