/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.installer.swing.impl.execution.panel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import org.gvsig.installer.lib.api.PackageInfo;
import org.gvsig.installer.lib.api.execution.InstallPackageService;
import org.gvsig.installer.swing.api.SwingInstallerLocator;
import org.gvsig.installer.swing.api.execution.PackageFilter;
import org.gvsig.installer.swing.impl.DefaultSwingInstallerManager;
import org.gvsig.installer.swing.impl.execution.panel.PackagesTablePanel;
import org.gvsig.installer.swing.impl.execution.panel.filters.TypeFilter;
import org.gvsig.installer.swing.impl.execution.panel.model.PackagesTableModel;
import org.gvsig.installer.swing.impl.execution.wizard.SelectPackagesWizardPage;

public class SelectPackagesPanel
extends JPanel {
    private SelectPackagesWizardPage wizard;
    private static final long serialVersionUID = -7554097983061858479L;
    protected DefaultSwingInstallerManager swingInstallerManager = null;
    private PackagesTablePanel packagesTablePanel;
    private PackagesTableModel pluginsTableModel = null;

    public SelectPackagesPanel(SelectPackagesWizardPage selectPackagesWizard) {
        this.wizard = selectPackagesWizard;
        this.swingInstallerManager = (DefaultSwingInstallerManager)SwingInstallerLocator.getSwingInstallerManager();
        this.initComponents();
    }

    public JPanel getJPanel() {
        return this;
    }

    public void updateTableModel(PackagesTableModel pluginsTableModel) {
        this.packagesTablePanel.setTableModel(pluginsTableModel);
        this.add((Component)this.packagesTablePanel, "Center");
    }

    public void selectPackages() {
        this.packagesTablePanel.selectPackages();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout(0, 0));
        this.packagesTablePanel = new PackagesTablePanel(this);
        this.add((Component)this.packagesTablePanel, "Center");
    }

    public List<PackageInfo> getPackagesToInstall() {
        List<PackageInfo> packages = this.packagesTablePanel.getPackagesToInstall();
        ArrayList<PackageInfo> packagesToInstall = new ArrayList<PackageInfo>();
        packagesToInstall.addAll(packages);
        return packagesToInstall;
    }

    public boolean isPackageSelected() {
        return this.packagesTablePanel.isPackageSelected();
    }

    public void checkIfPluginSelected() {
        this.wizard.checkIfPluginSelected();
    }

    public void packageSelectionChanged(Object value, int row, int column) {
    }

    public void updatePanel() {
        InstallPackageService installerExecutionService = this.wizard.getWizardPanel().getInstallerExecutionService();
        if (this.pluginsTableModel == null) {
            this.pluginsTableModel = new PackagesTableModel(this.swingInstallerManager, installerExecutionService, true);
        }
        this.pluginsTableModel.updatePackages();
        this.updateTableModel(this.pluginsTableModel);
        if (this.wizard.isDefaultPackagesSelectionSet().booleanValue()) {
            this.pluginsTableModel.selectDefaultPackages();
        }
    }

    public PackagesTableModel getModel() {
        return this.pluginsTableModel;
    }

    public void clearPanel() {
        this.packagesTablePanel.clearAllPanels();
    }

    public void setInitialFilter() {
        this.packagesTablePanel.setInitialFilter();
    }

    public void setBaseFilter(PackageFilter filter) {
        if (filter == null) {
            this.packagesTablePanel.setBaseFilter(null);
            this.packagesTablePanel.setEnabledTypeFilter(true);
        } else {
            this.packagesTablePanel.setBaseFilter(filter);
            if (filter instanceof TypeFilter) {
                this.packagesTablePanel.setEnabledTypeFilter(false);
            }
        }
    }
}

