/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gui.algorithm;

import es.unex.sextante.core.AnalysisExtent;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.NamedExtent;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.ILayer;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.exceptions.WrongAnalysisExtentException;
import es.unex.sextante.gui.algorithm.ExtentFromSavedPointsDialog;
import es.unex.sextante.gui.core.SextanteGUI;
import es.unex.sextante.gui.exceptions.TooLargeGridExtentException;
import es.unex.sextante.gui.grass.GrassAlgorithm;
import es.unex.sextante.outputs.Output;
import es.unex.sextante.outputs.OutputRasterLayer;
import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.geom.Rectangle2D;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class AnalysisExtentPanel
extends JPanel {
    protected static final int BIG_SIZE = 10000000;
    private JTextField jTextFieldCols;
    private JTextField jTextFieldRows;
    protected JTextField jTextFieldCellSize;
    protected JTextField jTextFieldXMax;
    protected JTextField jTextFieldXMin;
    protected JTextField jTextFieldYMax;
    protected JTextField jTextFieldYMin;
    private JLabel jLabelRowsCols;
    private JLabel jLabelCellSize;
    private JLabel jLabelRangeY;
    private JLabel jLabelRangeX;
    protected JComboBox jComboBoxLayers;
    private JComboBox jComboBoxViews;
    protected JPanel jPanelAnalysisExtentValues;
    private JPanel jPanelAnalysisExtentOptions;
    private JRadioButton jRadioButtonAdjustToInputDataExtent;
    private JRadioButton jRadioButtonViewExtent;
    private JRadioButton jRadioButtonUserDefinedExtent;
    private JRadioButton jRadioButtonExtentFromLayer;
    private ButtonGroup jButtonGroup;
    protected final GeoAlgorithm m_Algorithm;
    protected final ILayer[] m_Layers = SextanteGUI.getInputFactory().getLayers();

    public AnalysisExtentPanel(GeoAlgorithm algorithm) {
        this.m_Algorithm = algorithm;
        this.initGUI();
    }

    private void initGUI() {
        TableLayout jPanelParametersRasterLayout = new TableLayout((double[][])new double[][]{{1.0, -1.0, 1.0}, {1.0, -3.0, -1.0, 1.0}});
        jPanelParametersRasterLayout.setHGap(5);
        jPanelParametersRasterLayout.setVGap(5);
        this.setLayout((LayoutManager)jPanelParametersRasterLayout);
        this.add((Component)this.getJPanelAnalysisExtentOptions(), "1, 1");
        this.add((Component)this.getJPanelAnalysisExtentValues(), "1, 2");
        if (this.m_Algorithm.canDefineOutputExtentFromInput()) {
            this.getJPanelAnalysisExtentValues().setVisible(false);
        } else {
            this.getJPanelAnalysisExtentValues().setVisible(true);
        }
    }

    public void assignExtent() throws TooLargeGridExtentException, WrongAnalysisExtentException {
        this.m_Algorithm.setAnalysisExtent((AnalysisExtent)null);
        if (this.getJRadioButtonAdjustToInputDataExtent().isSelected()) {
            if (!this.m_Algorithm.adjustOutputExtent()) {
                throw new WrongAnalysisExtentException(Sextante.getText((String)"Wrong_or_missing_region"));
            }
            return;
        }
        AnalysisExtent outputExtent = new AnalysisExtent();
        boolean recalculateForCell = this.m_Algorithm.getRecalculateForCell();
        try {
            outputExtent.setCellSize(Double.parseDouble(this.jTextFieldCellSize.getText()));
            outputExtent.setXRange(Double.parseDouble(this.jTextFieldXMin.getText()), Double.parseDouble(this.jTextFieldXMax.getText()), recalculateForCell);
            outputExtent.setYRange(Double.parseDouble(this.jTextFieldYMin.getText()), Double.parseDouble(this.jTextFieldYMax.getText()), recalculateForCell);
            this.m_Algorithm.setAnalysisExtent(outputExtent);
        }
        catch (NumberFormatException e) {
            if (this.m_Algorithm instanceof GrassAlgorithm) {
                outputExtent.setXRange(0.0, 1.0, true);
                outputExtent.setYRange(0.0, 1.0, true);
                this.m_Algorithm.setAnalysisExtent(outputExtent);
                if (this.m_Algorithm.getName().contains("v.in.region")) {
                    throw new WrongAnalysisExtentException(Sextante.getText((String)"Wrong_or_missing_region"));
                }
                for (int i = 0; i < this.m_Algorithm.getNumberOfOutputObjects(); ++i) {
                    Output out = this.m_Algorithm.getOutputObjects().getOutput(i);
                    if (!(out instanceof OutputRasterLayer) || this.m_Algorithm.getName().contains("r.in.")) continue;
                    throw new WrongAnalysisExtentException(Sextante.getText((String)"Wrong_or_missing_region"));
                }
            }
            throw new WrongAnalysisExtentException(Sextante.getText((String)"Wrong_or_missing_raster_extent_definition"));
        }
        int numCells = outputExtent.getNX() * outputExtent.getNY();
    }

    private ButtonGroup getJButtonGroup() {
        if (this.jButtonGroup == null) {
            this.jButtonGroup = new ButtonGroup();
        }
        return this.jButtonGroup;
    }

    protected JRadioButton getJRadioButtonUserDefinedExtent() {
        if (this.jRadioButtonUserDefinedExtent == null) {
            this.jRadioButtonUserDefinedExtent = new JRadioButton();
            this.jRadioButtonUserDefinedExtent.setText(Sextante.getText((String)"User_defined"));
            this.jRadioButtonUserDefinedExtent.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AnalysisExtentPanel.this.setTextFieldsEnabled(true);
                    AnalysisExtentPanel.this.extentHasChanged();
                }
            });
        }
        return this.jRadioButtonUserDefinedExtent;
    }

    protected JRadioButton getJRadioButtonAdjustToInputDataExtent() {
        if (this.jRadioButtonAdjustToInputDataExtent == null) {
            this.jRadioButtonAdjustToInputDataExtent = new JRadioButton();
            this.jRadioButtonAdjustToInputDataExtent.setText(Sextante.getText((String)"Fit_to_input_layers"));
            this.jRadioButtonAdjustToInputDataExtent.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AnalysisExtentPanel.this.getJPanelAnalysisExtentValues().setVisible(false);
                }
            });
        }
        return this.jRadioButtonAdjustToInputDataExtent;
    }

    private JRadioButton getJRadioButtonViewExtent() {
        if (this.jRadioButtonViewExtent == null) {
            this.jRadioButtonViewExtent = new JRadioButton();
            this.jRadioButtonViewExtent.setText(Sextante.getText((String)"Use_extent_from_view"));
            this.jRadioButtonViewExtent.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    try {
                        AnalysisExtentPanel.this.getJComboBoxViews().setSelectedIndex(AnalysisExtentPanel.this.getJComboBoxViews().getSelectedIndex());
                        AnalysisExtentPanel.this.setTextFieldsEnabled(false);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
        return this.jRadioButtonViewExtent;
    }

    JRadioButton getJRadioButtonExtentFromLayer() {
        if (this.jRadioButtonExtentFromLayer == null) {
            this.jRadioButtonExtentFromLayer = new JRadioButton();
            this.jRadioButtonExtentFromLayer.setText(Sextante.getText((String)"Use_extent_from_layer"));
            this.jRadioButtonExtentFromLayer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AnalysisExtentPanel.this.getJComboBoxLayers().setSelectedIndex(AnalysisExtentPanel.this.getJComboBoxLayers().getSelectedIndex());
                    AnalysisExtentPanel.this.setTextFieldsEnabled(false);
                }
            });
        }
        return this.jRadioButtonExtentFromLayer;
    }

    protected JPanel getJPanelAnalysisExtentOptions() {
        if (this.jPanelAnalysisExtentOptions == null) {
            this.jPanelAnalysisExtentOptions = new JPanel();
            TableLayout jPanelRasterExtentOptionsLayout = new TableLayout((double[][])new double[][]{{253.0, -1.0}, {-3.0, -3.0, -3.0, -3.0}});
            jPanelRasterExtentOptionsLayout.setHGap(5);
            jPanelRasterExtentOptionsLayout.setVGap(5);
            this.jPanelAnalysisExtentOptions.setLayout((LayoutManager)jPanelRasterExtentOptionsLayout);
            this.jPanelAnalysisExtentOptions.setPreferredSize(new Dimension(660, 200));
            this.jPanelAnalysisExtentOptions.setBorder(BorderFactory.createTitledBorder(Sextante.getText((String)"Extent_from")));
            this.jPanelAnalysisExtentOptions.add((Component)this.getJRadioButtonUserDefinedExtent(), "0, 1");
            this.jPanelAnalysisExtentOptions.add((Component)this.getJRadioButtonViewExtent(), "0, 2");
            this.jPanelAnalysisExtentOptions.add((Component)this.getJRadioButtonExtentFromLayer(), "0, 3");
            this.getJButtonGroup().add(this.getJRadioButtonUserDefinedExtent());
            this.getJButtonGroup().add(this.getJRadioButtonViewExtent());
            this.getJButtonGroup().add(this.getJRadioButtonExtentFromLayer());
            if (this.m_Algorithm.canDefineOutputExtentFromInput()) {
                this.jPanelAnalysisExtentOptions.add((Component)this.getJRadioButtonAdjustToInputDataExtent(), "0, 0");
                this.getJButtonGroup().add(this.getJRadioButtonAdjustToInputDataExtent());
                this.getJRadioButtonAdjustToInputDataExtent().setSelected(true);
            } else {
                this.getJRadioButtonUserDefinedExtent().setSelected(true);
            }
            this.jPanelAnalysisExtentOptions.add((Component)this.getJComboBoxViews(), "1, 2");
            this.jPanelAnalysisExtentOptions.add((Component)this.getJComboBoxLayers(), "1, 3");
        }
        return this.jPanelAnalysisExtentOptions;
    }

    protected JPanel getJPanelAnalysisExtentValues() {
        if (this.jPanelAnalysisExtentValues == null) {
            this.jPanelAnalysisExtentValues = new JPanel();
            TableLayout jPanelRasterExtentValuesLayout = new TableLayout((double[][])new double[][]{{255.0, -1.0, -1.0}, {-3.0, -3.0, -3.0, -3.0, -1.0}});
            jPanelRasterExtentValuesLayout.setHGap(5);
            jPanelRasterExtentValuesLayout.setVGap(5);
            this.jPanelAnalysisExtentValues.setLayout((LayoutManager)jPanelRasterExtentValuesLayout);
            this.jPanelAnalysisExtentValues.setBorder(BorderFactory.createTitledBorder(Sextante.getText((String)"Extent__values")));
            this.jPanelAnalysisExtentValues.setPreferredSize(new Dimension(660, 145));
            this.jPanelAnalysisExtentValues.add((Component)this.getJLabelRangeX(), "0, 0");
            this.jPanelAnalysisExtentValues.add((Component)this.getJLabelCellSize(), "0, 2");
            this.jPanelAnalysisExtentValues.add((Component)this.getJTextFieldCellSize(), "1, 2");
            this.jPanelAnalysisExtentValues.add((Component)this.getJTextFieldXMin(), "1, 0");
            this.jPanelAnalysisExtentValues.add((Component)this.getJTextFieldXMax(), "2, 0");
            this.jPanelAnalysisExtentValues.add((Component)this.getJTextFieldYMin(), "1, 1");
            this.jPanelAnalysisExtentValues.add((Component)this.getJTextFieldYMax(), "2, 1");
            this.jPanelAnalysisExtentValues.add((Component)this.getJLabelRangeY(), "0, 1");
            this.jPanelAnalysisExtentValues.add((Component)this.getJLabelRowsCols(), "0, 3");
            this.jPanelAnalysisExtentValues.add((Component)this.getJTextFieldRows(), "1, 3");
            this.jPanelAnalysisExtentValues.add((Component)this.getJTextFieldCols(), "2, 3");
            this.jPanelAnalysisExtentValues.add((Component)this.getJButtonExtentFromPoints(), "2,2");
        }
        return this.jPanelAnalysisExtentValues;
    }

    private JButton getJButtonExtentFromPoints() {
        JButton button = new JButton("...");
        button.setSize(new Dimension(30, 30));
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ExtentFromSavedPointsDialog dialog = new ExtentFromSavedPointsDialog();
                dialog.pack();
                dialog.setVisible(true);
                double[] ret = dialog.getPoints();
                if (ret != null) {
                    AnalysisExtentPanel.this.getJTextFieldXMin().setText(Double.toString(ret[0]));
                    AnalysisExtentPanel.this.getJTextFieldYMin().setText(Double.toString(ret[1]));
                    AnalysisExtentPanel.this.getJTextFieldXMax().setText(Double.toString(ret[2]));
                    AnalysisExtentPanel.this.getJTextFieldYMax().setText(Double.toString(ret[3]));
                }
            }
        });
        return button;
    }

    protected JComboBox getJComboBoxLayers() {
        if (this.jComboBoxLayers == null) {
            this.getJRadioButtonExtentFromLayer().setEnabled(this.m_Layers.length > 0);
            DefaultComboBoxModel<ILayer> jComboBoxLayersModel = new DefaultComboBoxModel<ILayer>(this.m_Layers);
            this.jComboBoxLayers = new JComboBox();
            this.jComboBoxLayers.setModel(jComboBoxLayersModel);
            this.jComboBoxLayers.setEnabled(this.m_Layers.length > 0);
            this.jComboBoxLayers.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    if (AnalysisExtentPanel.this.getJRadioButtonExtentFromLayer().isSelected()) {
                        try {
                            ILayer layer = (ILayer)AnalysisExtentPanel.this.jComboBoxLayers.getSelectedItem();
                            Rectangle2D fullExtent = layer.getFullExtent();
                            double dCoord = fullExtent.getMinX();
                            AnalysisExtentPanel.this.getJTextFieldXMin().setText(new Double(dCoord).toString());
                            dCoord = fullExtent.getMaxX();
                            AnalysisExtentPanel.this.getJTextFieldXMax().setText(new Double(dCoord).toString());
                            dCoord = fullExtent.getMinY();
                            AnalysisExtentPanel.this.getJTextFieldYMin().setText(new Double(dCoord).toString());
                            dCoord = fullExtent.getMaxY();
                            AnalysisExtentPanel.this.getJTextFieldYMax().setText(new Double(dCoord).toString());
                            if (layer instanceof IRasterLayer) {
                                AnalysisExtentPanel.this.getJTextFieldCellSize().setText(new Double(((IRasterLayer)layer).getLayerCellSize()).toString());
                            }
                            AnalysisExtentPanel.this.extentHasChanged();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            });
        }
        return this.jComboBoxLayers;
    }

    private JComboBox getJComboBoxViews() {
        if (this.jComboBoxViews == null) {
            NamedExtent[] predefinedExtents = SextanteGUI.getInputFactory().getPredefinedExtents();
            boolean enabled = predefinedExtents.length > 1 || predefinedExtents.length == 1 && predefinedExtents[0] != null;
            this.getJRadioButtonViewExtent().setEnabled(enabled);
            DefaultComboBoxModel<NamedExtent> jComboBoxViewsModel = new DefaultComboBoxModel<NamedExtent>(predefinedExtents);
            this.jComboBoxViews = new JComboBox();
            this.jComboBoxViews.setModel(jComboBoxViewsModel);
            this.jComboBoxViews.setEnabled(enabled);
            this.jComboBoxViews.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    if (AnalysisExtentPanel.this.getJRadioButtonViewExtent().isSelected()) {
                        try {
                            NamedExtent ne = (NamedExtent)AnalysisExtentPanel.this.jComboBoxViews.getSelectedItem();
                            if (ne != null) {
                                Rectangle2D extent2 = ne.getExtent();
                                AnalysisExtentPanel.this.getJTextFieldXMin().setText(new Double(extent2.getMinX()).toString());
                                AnalysisExtentPanel.this.getJTextFieldXMax().setText(new Double(extent2.getMaxX()).toString());
                                AnalysisExtentPanel.this.getJTextFieldYMin().setText(new Double(extent2.getMinY()).toString());
                                AnalysisExtentPanel.this.getJTextFieldYMax().setText(new Double(extent2.getMaxY()).toString());
                                AnalysisExtentPanel.this.setTextFieldsEnabled(false);
                                AnalysisExtentPanel.this.extentHasChanged();
                            }
                        }
                        catch (Exception e) {
                            Sextante.addErrorToLog((Throwable)e);
                        }
                    }
                }
            });
        }
        return this.jComboBoxViews;
    }

    protected JLabel getJLabelRangeX() {
        if (this.jLabelRangeX == null) {
            this.jLabelRangeX = new JLabel();
            this.jLabelRangeX.setText(Sextante.getText((String)"Range_X"));
        }
        return this.jLabelRangeX;
    }

    protected JTextField getNewJTextField() {
        JTextField jTextField = new JTextField();
        jTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                JTextField textField = (JTextField)e.getSource();
                String content = textField.getText();
                if (content.length() != 0) {
                    try {
                        double d = Double.parseDouble(content);
                        AnalysisExtentPanel.this.extentHasChanged();
                    }
                    catch (NumberFormatException nfe) {
                        AnalysisExtentPanel.this.getToolkit().beep();
                        textField.requestFocus();
                    }
                }
            }
        });
        jTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent event) {
                AnalysisExtentPanel.this.validateKeyTyping(event);
            }
        });
        return jTextField;
    }

    protected JTextField getJTextFieldXMin() {
        if (this.jTextFieldXMin == null) {
            this.jTextFieldXMin = this.getNewJTextField();
        }
        return this.jTextFieldXMin;
    }

    protected JTextField getJTextFieldXMax() {
        if (this.jTextFieldXMax == null) {
            this.jTextFieldXMax = this.getNewJTextField();
        }
        return this.jTextFieldXMax;
    }

    protected JTextField getJTextFieldYMin() {
        if (this.jTextFieldYMin == null) {
            this.jTextFieldYMin = this.getNewJTextField();
        }
        return this.jTextFieldYMin;
    }

    protected JTextField getJTextFieldYMax() {
        if (this.jTextFieldYMax == null) {
            this.jTextFieldYMax = this.getNewJTextField();
        }
        return this.jTextFieldYMax;
    }

    protected JLabel getJLabelRangeY() {
        if (this.jLabelRangeY == null) {
            this.jLabelRangeY = new JLabel();
            this.jLabelRangeY.setText(Sextante.getText((String)"Range_Y"));
        }
        return this.jLabelRangeY;
    }

    protected JLabel getJLabelCellSize() {
        if (this.jLabelCellSize == null) {
            this.jLabelCellSize = new JLabel();
            this.jLabelCellSize.setText(Sextante.getText((String)"Cell_size"));
        }
        return this.jLabelCellSize;
    }

    protected JTextField getJTextFieldCellSize() {
        if (this.jTextFieldCellSize == null) {
            this.jTextFieldCellSize = new JTextField();
            this.jTextFieldCellSize.setText("1");
            this.jTextFieldCellSize.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    JTextField textField = (JTextField)e.getSource();
                    String content = textField.getText();
                    if (content.length() != 0) {
                        try {
                            double d = Double.parseDouble(content);
                            if (d <= 0.0) {
                                throw new NumberFormatException();
                            }
                            AnalysisExtentPanel.this.extentHasChanged();
                        }
                        catch (NumberFormatException nfe) {
                            AnalysisExtentPanel.this.getToolkit().beep();
                            textField.requestFocus();
                        }
                    }
                }
            });
            this.jTextFieldCellSize.addKeyListener(new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent event) {
                    AnalysisExtentPanel.this.validateKeyTyping(event);
                }
            });
        }
        return this.jTextFieldCellSize;
    }

    protected JLabel getJLabelRowsCols() {
        if (this.jLabelRowsCols == null) {
            this.jLabelRowsCols = new JLabel();
            this.jLabelRowsCols.setText(Sextante.getText((String)"Number_of_rows-cols"));
        }
        return this.jLabelRowsCols;
    }

    protected JTextField getJTextFieldRows() {
        if (this.jTextFieldRows == null) {
            this.jTextFieldRows = new JTextField();
            this.jTextFieldRows.setEnabled(false);
        }
        return this.jTextFieldRows;
    }

    protected JTextField getJTextFieldCols() {
        if (this.jTextFieldCols == null) {
            this.jTextFieldCols = new JTextField();
            this.jTextFieldCols.setEnabled(false);
        }
        return this.jTextFieldCols;
    }

    private void validateKeyTyping(KeyEvent event) {
        String text = ((JTextField)event.getSource()).getText();
        switch (event.getKeyChar()) {
            case '\n': {
                this.extentHasChanged();
                break;
            }
            default: {
                text = text + event.getKeyChar();
            }
        }
    }

    protected void setTextFieldsEnabled(boolean bEnabled) {
        this.getJPanelAnalysisExtentValues().setVisible(true);
        this.getJTextFieldXMin().setEnabled(bEnabled);
        this.getJTextFieldXMax().setEnabled(bEnabled);
        this.getJTextFieldYMin().setEnabled(bEnabled);
        this.getJTextFieldYMax().setEnabled(bEnabled);
    }

    protected void extentHasChanged() {
        try {
            double dRangeX = Math.abs(Double.parseDouble(this.getJTextFieldXMax().getText()) - Double.parseDouble(this.getJTextFieldXMin().getText()));
            double dRangeY = Math.abs(Double.parseDouble(this.getJTextFieldYMax().getText()) - Double.parseDouble(this.getJTextFieldYMin().getText()));
            double dCellSize = Double.parseDouble(this.getJTextFieldCellSize().getText());
            int iRows = (int)Math.floor(dRangeY / dCellSize);
            int iCols = (int)Math.floor(dRangeX / dCellSize);
            this.getJTextFieldRows().setText(Integer.toString(iRows));
            this.getJTextFieldCols().setText(Integer.toString(iCols));
        }
        catch (NumberFormatException e) {
            return;
        }
    }

    public void setExtent(AnalysisExtent ge) {
        this.getJRadioButtonUserDefinedExtent().setSelected(true);
        this.setTextFieldsEnabled(true);
        this.getJTextFieldCellSize().setText(Double.toString(ge.getCellSize()));
        this.getJTextFieldXMin().setText(Double.toString(ge.getXMin()));
        this.getJTextFieldXMax().setText(Double.toString(ge.getXMax()));
        this.getJTextFieldYMin().setText(Double.toString(ge.getYMin()));
        this.getJTextFieldYMax().setText(Double.toString(ge.getYMax()));
        this.extentHasChanged();
    }

    public void setAutoExtent() {
        this.getJRadioButtonAdjustToInputDataExtent().setSelected(true);
        this.setTextFieldsEnabled(false);
        this.getJPanelAnalysisExtentValues().setVisible(false);
    }
}

