/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gui.batch;

import es.unex.sextante.core.Sextante;
import es.unex.sextante.gui.batch.MultipleBandsSelectionTableModel;
import es.unex.sextante.gui.batch.RasterBandPanelEditor;
import es.unex.sextante.gui.batch.RasterFilePanelEditor;
import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class MultipleBandSelectionDialog
extends JDialog {
    private JPanel jPanelAddRemoveRows;
    private JPanel jPanelOKCancel;
    private JScrollPane jScrollPane;
    private JButton jButtonRemoveRow;
    private JButton jButtonAddRow;
    private JButton jButtonOK;
    private JButton jButtonCancel;
    private JTable jTable;
    private MultipleBandsSelectionTableModel m_TableModel;
    private String m_sSel;

    public MultipleBandSelectionDialog(String sValue) {
        super((Frame)null, Sextante.getText((String)"Selection"), true);
        this.initGUI();
        this.fillTable(sValue);
    }

    private void fillTable(String sValue) {
        ArrayList list;
        int i;
        HashMap map = new HashMap();
        String sFile = null;
        String[] sTokens = sValue.split(",");
        for (i = 0; i < sTokens.length; ++i) {
            if (this.isPositiveInteger(sTokens[i])) {
                if (sFile == null) {
                    map = null;
                }
                if ((list = (ArrayList)map.get(sFile)) == null) {
                    map = null;
                    break;
                }
                list.add(new Integer(sTokens[i]));
                continue;
            }
            sFile = sTokens[i];
            if (map.containsKey(sFile)) continue;
            map.put(sFile, new ArrayList());
        }
        if (map != null) {
            int iSize = map.size() - 1;
            for (i = 0; i < iSize; ++i) {
                this.m_TableModel.addRow();
            }
            i = 0;
            Set set = map.keySet();
            for (String sKey : set) {
                StringBuffer sb = new StringBuffer();
                list = (ArrayList)map.get(sKey);
                this.m_TableModel.setValueAt(sKey, i, 0);
                for (int j = 0; j < list.size(); ++j) {
                    Integer band = (Integer)list.get(j);
                    sb.append(band.toString());
                    if (j >= list.size() - 1) continue;
                    sb.append(",");
                }
                this.m_TableModel.setValueAt(sb.toString(), i, 1);
                ++i;
            }
        }
    }

    private void initGUI() {
        TableLayout thisLayout = new TableLayout((double[][])new double[][]{{5.0, -1.0, 5.0, 200.0, 5.0}, {5.0, -1.0, -1.0, 5.0, 35.0, 5.0}});
        this.setLayout((LayoutManager)thisLayout);
        this.setPreferredSize(new Dimension(580, 350));
        this.setSize(new Dimension(580, 350));
        this.jScrollPane = new JScrollPane();
        this.add((Component)this.jScrollPane, "1,1,1,2");
        this.jScrollPane.setMinimumSize(new Dimension(432, 256));
        this.jTable = new JTable();
        this.jTable.setAutoResizeMode(0);
        this.jScrollPane.setViewportView(this.jTable);
        this.m_TableModel = new MultipleBandsSelectionTableModel();
        this.jTable.setModel(this.m_TableModel);
        this.jTable.getTableHeader().setReorderingAllowed(false);
        this.jTable.getColumnModel().getColumn(0).setCellEditor(new RasterFilePanelEditor(this.jTable));
        this.jTable.getColumnModel().getColumn(1).setCellEditor(new RasterBandPanelEditor(this.jTable));
        this.jTable.getColumnModel().getColumn(0).setPreferredWidth(200);
        this.jTable.getColumnModel().getColumn(1).setPreferredWidth(200);
        this.jPanelAddRemoveRows = new JPanel();
        this.add((Component)this.jPanelAddRemoveRows, "3,1");
        this.jButtonRemoveRow = new JButton();
        this.jPanelAddRemoveRows.add(this.jButtonRemoveRow);
        this.jButtonRemoveRow.setText(Sextante.getText((String)"Delete_row"));
        this.jButtonRemoveRow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MultipleBandSelectionDialog.this.btnRemoveRowActionPerformed();
            }
        });
        this.jButtonAddRow = new JButton();
        this.jPanelAddRemoveRows.add(this.jButtonAddRow);
        this.jButtonAddRow.setText(Sextante.getText((String)"Add_row"));
        this.jButtonAddRow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MultipleBandSelectionDialog.this.btnAddRowActionPerformed();
            }
        });
        this.jPanelOKCancel = new JPanel();
        this.add((Component)this.jPanelOKCancel, "3,4");
        this.jButtonOK = new JButton();
        this.jPanelOKCancel.add(this.jButtonOK);
        this.jButtonOK.setText(Sextante.getText((String)"OK"));
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MultipleBandSelectionDialog.this.btnOkActionPerformed();
            }
        });
        this.jButtonCancel = new JButton();
        this.jPanelOKCancel.add(this.jButtonCancel);
        this.jButtonCancel.setText(Sextante.getText((String)"Cancel"));
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MultipleBandSelectionDialog.this.btnCancelActionPerformed();
            }
        });
    }

    protected void btnOkActionPerformed() {
        this.setSelection();
        this.cancel();
    }

    protected void btnCancelActionPerformed() {
        this.m_sSel = null;
        this.cancel();
    }

    private void btnAddRowActionPerformed() {
        this.m_TableModel.addRow();
    }

    private void btnRemoveRowActionPerformed() {
        int iRow = this.jTable.getSelectedRow();
        if (iRow != -1) {
            this.m_TableModel.removeRow(iRow);
        }
    }

    public String getSelectionAsString() {
        return this.m_sSel;
    }

    private void setSelection() {
        StringBuffer sSel = new StringBuffer();
        for (int i = 0; i < this.jTable.getRowCount(); ++i) {
            String[] sBands;
            for (String element : sBands = ((String)this.jTable.getValueAt(i, 1)).split(",")) {
                sSel.append(this.jTable.getValueAt(i, 0));
                sSel.append(",");
                sSel.append(element);
                sSel.append(",");
            }
        }
        sSel.deleteCharAt(sSel.length() - 1);
        this.m_sSel = sSel.toString();
    }

    public void cancel() {
        this.dispose();
        this.setVisible(false);
    }

    private boolean isPositiveInteger(String s) {
        try {
            int i = Integer.parseInt(s);
            return i > 0;
        }
        catch (Exception e) {
            return false;
        }
    }
}

