/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gui.batch.nonFileBased;

import es.unex.sextante.core.AnalysisExtent;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.exceptions.WrongAnalysisExtentException;
import es.unex.sextante.exceptions.WrongInputException;
import es.unex.sextante.gui.batch.AnalysisExtentPanel;
import es.unex.sextante.gui.batch.TridimensionalAnalysisExtentPanel;
import es.unex.sextante.gui.batch.nonFileBased.BatchProcessMonitorableTask;
import es.unex.sextante.gui.batch.nonFileBased.ParametersPanel;
import es.unex.sextante.gui.core.SextanteGUI;
import es.unex.sextante.gui.exceptions.TooLargeGridExtentException;
import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;

public class BatchProcessDialog
extends JDialog {
    private final GeoAlgorithm m_Algorithm;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JButton jButtonHelp;
    private ParametersPanel jParametersPanel;
    private AnalysisExtentPanel jRasterExtentPanel;
    private JTabbedPane jTabbedPanel;
    private JLabel jLabelName;
    private final JDialog m_Parent;

    public BatchProcessDialog(GeoAlgorithm alg, JDialog parent) {
        super(parent, Sextante.getText((String)"Batch_processing"), true);
        this.m_Algorithm = alg;
        this.m_Parent = parent;
        this.initGUI();
        this.setLocationRelativeTo(null);
    }

    public BatchProcessDialog(GeoAlgorithm alg) {
        super(SextanteGUI.getMainFrame(), Sextante.getText((String)"Batch_processing"), true);
        this.setLocationRelativeTo(null);
        this.m_Algorithm = alg;
        this.m_Parent = null;
        this.initGUI();
    }

    private void initGUI() {
        try {
            TableLayout thisLayout = new TableLayout((double[][])new double[][]{{5.0, 70.0, -1.0, 100.0, 100.0, -1.0, 5.0, 100.0, 100.0, 5.0}, {5.0, 20.0, 5.0, -1.0, 5.0, 25.0, 5.0}});
            this.getContentPane().setLayout((LayoutManager)thisLayout);
            this.setPreferredSize(new Dimension(800, 600));
            this.setSize(new Dimension(800, 600));
            this.jButtonHelp = new JButton();
            this.getContentPane().add((Component)this.jButtonHelp, "1, 5");
            this.jButtonHelp.setText(Sextante.getText((String)"Help"));
            this.jButtonHelp.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    BatchProcessDialog.this.showHelp();
                }
            });
            this.jTabbedPanel = new JTabbedPane();
            this.getContentPane().add((Component)this.jTabbedPanel, "1, 3, 8, 3");
            this.jParametersPanel = new ParametersPanel(this.m_Algorithm);
            this.jTabbedPanel.addTab(Sextante.getText((String)"Parameters"), null, this.jParametersPanel, null);
            this.jParametersPanel.setPreferredSize(new Dimension(446, 225));
            if (this.m_Algorithm.getUserCanDefineAnalysisExtent()) {
                this.jRasterExtentPanel = this.m_Algorithm.is3D() ? new TridimensionalAnalysisExtentPanel(this.m_Algorithm) : new AnalysisExtentPanel(this.m_Algorithm);
                this.jTabbedPanel.addTab(Sextante.getText((String)"Raster_output"), null, this.jRasterExtentPanel, null);
            }
            this.jButtonOK = new JButton();
            this.getContentPane().add((Component)this.jButtonOK, "7, 5");
            this.jButtonOK.setText(Sextante.getText((String)"OK"));
            this.jButtonOK.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    BatchProcessDialog.this.executeBatchProcess();
                }
            });
            this.jButtonCancel = new JButton();
            this.getContentPane().add((Component)this.jButtonCancel, "8, 5");
            this.jButtonCancel.setText(Sextante.getText((String)"Cancel"));
            this.jButtonCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    BatchProcessDialog.this.cancel();
                }
            });
            this.jLabelName = new JLabel(this.m_Algorithm.getName().toUpperCase());
            this.jLabelName.setFont(new Font("Tahoma", 1, 12));
            this.getContentPane().add((Component)this.jLabelName, "1, 1, 7, 1");
        }
        catch (Exception e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    private void showHelp() {
        SextanteGUI.getGUIFactory().showHelpDialog("batch");
    }

    private void executeBatchProcess() {
        ArrayList param = new ArrayList();
        ArrayList output = new ArrayList();
        try {
            block6: {
                try {
                    this.assignParameters(param, output);
                }
                catch (TooLargeGridExtentException e) {
                    int iRet = JOptionPane.showConfirmDialog(null, e.getMessage(), Sextante.getText((String)"Warning"), 0);
                    if (iRet == 0) break block6;
                    this.jTabbedPanel.setSelectedIndex(1);
                    return;
                }
            }
            AnalysisExtent extent2 = null;
            if (this.jRasterExtentPanel != null) {
                extent2 = this.jRasterExtentPanel.getExtent();
            }
            BatchProcessMonitorableTask task = new BatchProcessMonitorableTask(this.m_Algorithm, param, output, extent2, this.m_Parent);
            Thread th = new Thread(task);
            th.start();
            this.cancel();
        }
        catch (WrongInputException e) {
            JOptionPane.showMessageDialog(null, e.getMessage(), Sextante.getText((String)"Warning"), 2);
            this.jTabbedPanel.setSelectedIndex(0);
        }
        catch (WrongAnalysisExtentException e) {
            JOptionPane.showMessageDialog(null, e.getMessage(), Sextante.getText((String)"Warning"), 2);
            this.jTabbedPanel.setSelectedIndex(1);
        }
    }

    private void assignParameters(ArrayList param, ArrayList output) throws WrongInputException, WrongAnalysisExtentException, TooLargeGridExtentException {
        if (!this.jParametersPanel.assignParameters(param, output)) {
            throw new WrongInputException(Sextante.getText((String)"Wrong_or_missing_parameters_definition"));
        }
        if (this.m_Algorithm.getUserCanDefineAnalysisExtent()) {
            this.jRasterExtentPanel.adjustExtent();
        }
    }

    private void cancel() {
        this.dispose();
        this.setVisible(false);
    }
}

