/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gui.dataExplorer;

import es.unex.sextante.core.AnalysisExtent;
import es.unex.sextante.core.ObjectAndDescription;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IDataObject;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.dataObjects.ITable;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.gui.core.SextanteGUI;
import es.unex.sextante.gui.dataExplorer.Action;
import es.unex.sextante.gui.dataExplorer.BandTreeNode;
import es.unex.sextante.gui.dataExplorer.DataExplorerTreeCellRenderer;
import es.unex.sextante.gui.dataExplorer.ShowTable;
import es.unex.sextante.gui.toolbox.TransparentScrollPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class DataExplorerPanel
extends JPanel {
    private static final String[] DATA_TYPE = new String[]{"BYTE", "", "SHORT", "INT", "FLOAT", "DOUBLE"};
    private static final String[] TYPE_NAME = new String[]{"POINT", "LINE", "POLYGON"};
    private JTree jTree;
    private JScrollPane jScrollPane;
    private JMenuItem menuItem;
    private JPopupMenu popupMenu;
    private TreePath m_Path;
    private Action m_Action;

    public DataExplorerPanel() {
        this.init();
    }

    private void init() {
        this.setPreferredSize(new Dimension(350, 380));
        this.setSize(new Dimension(350, 380));
        BorderLayout thisLayout = new BorderLayout();
        this.setLayout(thisLayout);
        this.jTree = new JTree();
        this.jTree.setOpaque(false);
        this.jTree.setCellRenderer(new DataExplorerTreeCellRenderer());
        MouseAdapter ml = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                DataExplorerPanel.this.m_Path = DataExplorerPanel.this.jTree.getPathForLocation(e.getX(), e.getY());
                if (DataExplorerPanel.this.m_Path != null) {
                    try {
                        DefaultMutableTreeNode node = (DefaultMutableTreeNode)DataExplorerPanel.this.m_Path.getLastPathComponent();
                        ObjectAndDescription oad = (ObjectAndDescription)node.getUserObject();
                        DataExplorerPanel.this.m_Action = (Action)oad.getObject();
                        if (e.getButton() == 3) {
                            DataExplorerPanel.this.showPopupMenu(e);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        };
        this.jTree.addMouseListener(ml);
        TreeExpansionListener tel = new TreeExpansionListener(){

            @Override
            public void treeCollapsed(TreeExpansionEvent e) {
            }

            @Override
            public void treeExpanded(TreeExpansionEvent e) {
                BandTreeNode bandNode;
                DataExplorerPanel.this.m_Path = e.getPath();
                Object obj = DataExplorerPanel.this.m_Path.getLastPathComponent();
                if (obj instanceof BandTreeNode && (bandNode = (BandTreeNode)obj).getChildCount() == 1) {
                    IRasterLayer rasterLayer = bandNode.getLayer();
                    int iBand = bandNode.getBand();
                    bandNode.removeAllChildren();
                    rasterLayer.open();
                    bandNode.add(new DefaultMutableTreeNode("AVG:" + Double.toString(rasterLayer.getMeanValue(iBand))));
                    bandNode.add(new DefaultMutableTreeNode("MIN:" + Double.toString(rasterLayer.getMinValue(iBand))));
                    bandNode.add(new DefaultMutableTreeNode("MAX:" + Double.toString(rasterLayer.getMaxValue(iBand))));
                    bandNode.add(new DefaultMutableTreeNode("VAR:" + Double.toString(rasterLayer.getVariance(iBand))));
                    rasterLayer.close();
                    ((DefaultTreeModel)DataExplorerPanel.this.jTree.getModel()).reload(bandNode);
                    DataExplorerPanel.this.jTree.repaint();
                }
            }
        };
        this.jTree.addTreeExpansionListener(tel);
        this.fillTree();
        this.jScrollPane = new TransparentScrollPane(this.jTree);
        this.jScrollPane.setSize(new Dimension(350, 380));
        this.add((Component)this.jScrollPane, "Center");
    }

    private void fillTree() {
        DefaultMutableTreeNode mainNode = new DefaultMutableTreeNode(Sextante.getText((String)"Data"));
        DefaultMutableTreeNode rasterLayersNode = new DefaultMutableTreeNode(Sextante.getText((String)"Raster_layers"));
        mainNode.add(rasterLayersNode);
        IRasterLayer[] rasterLayers = SextanteGUI.getInputFactory().getRasterLayers();
        for (int i = 0; i < rasterLayers.length; ++i) {
            IRasterLayer rasterLayer = rasterLayers[i];
            rasterLayer.open();
            DefaultMutableTreeNode rasterLayerNode = new DefaultMutableTreeNode(rasterLayer.getName());
            rasterLayerNode.add(new DefaultMutableTreeNode("NODATA:" + Double.toString(rasterLayer.getNoDataValue())));
            AnalysisExtent ge = rasterLayer.getLayerGridExtent();
            rasterLayerNode.add(new DefaultMutableTreeNode("X:" + Double.toString(ge.getXMin()) + "-" + Double.toString(ge.getXMax())));
            rasterLayerNode.add(new DefaultMutableTreeNode("Y:" + Double.toString(ge.getYMin()) + "-" + Double.toString(ge.getYMax())));
            rasterLayerNode.add(new DefaultMutableTreeNode("NX:" + Integer.toString(ge.getNX()) + " | NY:" + Integer.toString(ge.getNY())));
            rasterLayerNode.add(new DefaultMutableTreeNode("DATA_TYPE: " + DATA_TYPE[rasterLayer.getDataType()]));
            DefaultMutableTreeNode bandsNode = new DefaultMutableTreeNode("BANDS:" + Integer.toString(rasterLayer.getBandsCount()));
            rasterLayerNode.add(bandsNode);
            for (int j = 0; j < rasterLayer.getBandsCount(); ++j) {
                BandTreeNode bandNode = new BandTreeNode("Band " + Integer.toString(j + 1), rasterLayer, j);
                bandNode.add(new DefaultMutableTreeNode(Sextante.getText((String)"Calculando") + "..."));
                bandsNode.add(bandNode);
            }
            rasterLayersNode.add(rasterLayerNode);
            rasterLayer.close();
        }
        DefaultMutableTreeNode vectorLayersNode = new DefaultMutableTreeNode(Sextante.getText((String)"Vector_layers"));
        mainNode.add(vectorLayersNode);
        IVectorLayer[] vectorLayers = SextanteGUI.getInputFactory().getVectorLayers(-1);
        for (int i = 0; i < vectorLayers.length; ++i) {
            IVectorLayer vectorLayer = vectorLayers[i];
            DefaultMutableTreeNode vectorLayerNode = new DefaultMutableTreeNode(new ObjectAndDescription(vectorLayer.getName(), (Object)new ShowTable((IDataObject)vectorLayer)));
            vectorLayerNode.add(new DefaultMutableTreeNode(Sextante.getText((String)"Number_of_features") + ":" + vectorLayer.getShapesCount()));
            vectorLayerNode.add(new DefaultMutableTreeNode(Sextante.getText((String)"Type") + ":" + TYPE_NAME[vectorLayer.getShapeType()]));
            DefaultMutableTreeNode fieldsNode = new DefaultMutableTreeNode(Sextante.getText((String)"fields") + ":" + vectorLayer.getFieldCount());
            for (int j = 0; j < vectorLayer.getFieldCount(); ++j) {
                fieldsNode.add(new DefaultMutableTreeNode(vectorLayer.getFieldName(j) + ":" + vectorLayer.getFieldType(j).getSimpleName()));
            }
            vectorLayerNode.add(fieldsNode);
            vectorLayersNode.add(vectorLayerNode);
        }
        DefaultMutableTreeNode tablesNode = new DefaultMutableTreeNode(Sextante.getText((String)"Tables"));
        mainNode.add(tablesNode);
        ITable[] tables = SextanteGUI.getInputFactory().getTables();
        for (int i = 0; i < tables.length; ++i) {
            ITable table = tables[i];
            DefaultMutableTreeNode tableNode = new DefaultMutableTreeNode(new ObjectAndDescription(table.getName(), (Object)new ShowTable((IDataObject)table)));
            tableNode.add(new DefaultMutableTreeNode(Sextante.getText((String)"Number_of_records") + ":" + table.getRecordCount()));
            DefaultMutableTreeNode fieldsNode = new DefaultMutableTreeNode(Sextante.getText((String)"fields") + ":" + table.getFieldCount());
            for (int j = 0; j < table.getFieldCount(); ++j) {
                fieldsNode.add(new DefaultMutableTreeNode(table.getFieldName(j) + ":" + table.getFieldType(j).getSimpleName()));
            }
            tableNode.add(fieldsNode);
            tablesNode.add(tableNode);
        }
        this.jTree.setModel(new DefaultTreeModel(mainNode));
    }

    protected void showPopupMenu(MouseEvent e) {
        this.jTree.setSelectionPath(this.m_Path);
        this.popupMenu = new JPopupMenu("Menu");
        this.menuItem = new JMenuItem(this.m_Action.getDescription());
        this.menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (DataExplorerPanel.this.m_Action.execute()) {
                    DataExplorerPanel.this.fillTree();
                }
            }
        });
        this.popupMenu.add(this.menuItem);
        this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
    }

    public void update() {
        this.fillTree();
    }
}

