/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gui.grass;

import es.unex.sextante.gui.core.SextanteGUI;
import es.unex.sextante.gui.toolbox.TransparentScrollPane;
import info.clearthought.layout.TableLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.DefaultStyledDocument;

public class GrassProgressMonitor
extends JDialog {
    private StringBuffer sTextBuffer;
    private JLabel jTitle;
    private JButton jButtonCancel;
    private JProgressBar jProgressBar;
    private JScrollPane jScrollPaneGRASS;
    private JTextPane jTextGRASS;
    private boolean m_bCanceled;

    public GrassProgressMonitor(String sText, boolean bDeterminate, JDialog parent) {
        super(parent, "", false);
        this.setDefaultCloseOperation(0);
        this.setLocationRelativeTo(null);
        this.m_bCanceled = false;
        this.initGUI(sText, bDeterminate);
    }

    public GrassProgressMonitor(String sText, boolean bDeterminate) {
        super(SextanteGUI.getMainFrame(), "", false);
        this.setDefaultCloseOperation(0);
        this.setLocationRelativeTo(null);
        this.m_bCanceled = false;
        this.initGUI(sText, bDeterminate);
    }

    private void initGUI(String sText, boolean bDeterminate) {
        TableLayout thisLayout = new TableLayout((double[][])new double[][]{{6.0, -1.0, -1.0, 6.0}, {1.0, -1.0, -1.0, 1.0, 15.0, 1.0, 25.0, 1.0}});
        thisLayout.setHGap(5);
        thisLayout.setVGap(5);
        this.setPreferredSize(new Dimension(650, 450));
        this.setSize(new Dimension(350, 450));
        this.getContentPane().setLayout((LayoutManager)thisLayout);
        this.jTitle = new JLabel(sText);
        this.getContentPane().add((Component)this.jTitle, "1, 1, 2, 1");
        this.jButtonCancel = new JButton();
        this.getContentPane().add((Component)this.jButtonCancel, "2, 6");
        this.jButtonCancel.setText("Cancelar");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GrassProgressMonitor.this.cancel();
            }
        });
        this.jProgressBar = new JProgressBar();
        this.jProgressBar.setIndeterminate(!bDeterminate);
        if (bDeterminate) {
            this.jProgressBar.setMinimum(0);
            this.jProgressBar.setMaximum(100);
            this.jProgressBar.setValue(0);
        }
        this.getContentPane().add((Component)this.jProgressBar, "1, 4, 2, 4");
        this.jTextGRASS = new NonWordWrapPane();
        this.jTextGRASS.setStyledDocument(new DefaultStyledDocument());
        this.jTextGRASS.setFont(new Font("Monospaced", 0, 12));
        this.jTextGRASS.setContentType("text/plain");
        this.jTextGRASS.setEditable(false);
        this.jScrollPaneGRASS = new TransparentScrollPane();
        this.jScrollPaneGRASS.setBackground(Color.white);
        this.jScrollPaneGRASS.setSize(new Dimension(650, 450));
        this.jScrollPaneGRASS.setViewportView(this.jTextGRASS);
        this.getContentPane().add((Component)this.jScrollPaneGRASS, "1, 2, 2, 2");
        this.sTextBuffer = new StringBuffer("");
    }

    private void cancel() {
        this.m_bCanceled = true;
    }

    public boolean isCanceled() {
        return this.m_bCanceled;
    }

    public void addText(final String sText) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    GrassProgressMonitor.this.sTextBuffer.append(sText);
                    GrassProgressMonitor.this.jTextGRASS.setText("");
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setDescription(final String sDescription) {
        try {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    GrassProgressMonitor.this.jTitle.setText(sDescription);
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                SwingUtilities.invokeAndWait(runnable);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setProgress(final int iValue) {
        try {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    GrassProgressMonitor.this.jProgressBar.setValue(iValue);
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                SwingUtilities.invokeAndWait(runnable);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setDeterminate(final boolean bDeterminate) {
        try {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    GrassProgressMonitor.this.jProgressBar.setIndeterminate(!bDeterminate);
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                SwingUtilities.invokeAndWait(runnable);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private class NonWordWrapPane
    extends JTextPane {
        @Override
        public boolean getScrollableTracksViewportWidth() {
            return false;
        }
    }
}

