/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gui.grass;

import es.unex.sextante.core.Sextante;
import es.unex.sextante.gui.core.SextanteGUI;
import es.unex.sextante.gui.grass.GrassAlgorithm;
import es.unex.sextante.gui.grass.GrassAlgorithmProvider;
import es.unex.sextante.gui.grass.GrassExecutionException;
import es.unex.sextante.gui.grass.GrassVInfoUtils;
import es.unex.sextante.gui.grass.StreamGobbler;
import es.unex.sextante.outputs.FileOutputChannel;
import es.unex.sextante.outputs.Output;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import javax.swing.JOptionPane;

public class GrassUtils {
    private static boolean lastWasInfoEnd = false;
    private static boolean lastWasEmpty = false;
    private static boolean insideRegPrimitives = false;
    private static GrassAlgorithm m_Alg;
    private static Process m_Proc;
    private static boolean m_bProcCanceled;
    private static boolean m_bProcInterruptible;
    private static final int MAX_CHARS = 8192;
    public static final String colorTableExt = "colortable";
    public static final String colorTableIdentifier = "SEXTANTE GRASS Interface Color Table";
    public static final String colorTableVersion = "1.0";
    public static final String TEMP_PREFIX = "SGI";
    private static String m_sGrassTempMapsetFolder;

    public static Process getProcess() {
        return m_Proc;
    }

    public static boolean isProcessCanceled() {
        return m_bProcCanceled;
    }

    public static void setInterruptible(boolean choice) {
        m_bProcInterruptible = choice;
    }

    public static void cancelProcess() {
        if (m_Proc != null && m_bProcInterruptible) {
            m_Proc.destroy();
            m_Proc = null;
            m_bProcCanceled = true;
        }
    }

    public static File createStartupScript(String cmdline) {
        BufferedWriter output = null;
        File script = null;
        File gisrc = null;
        String sFolder = SextanteGUI.getSettingParameterValue("GrassBinariesFolder");
        String sWinShell = SextanteGUI.getSettingParameterValue("GrassWinShell");
        UUID id = UUID.randomUUID();
        String tmpPrefix = new String(TEMP_PREFIX);
        String tmpSuffix = new String("_" + id);
        String tmpBase = new String(System.getProperty("java.io.tmpdir"));
        String tmpExtension = Sextante.isWindows() ? new String("bat") : new String("sh");
        String tmpName = tmpBase.endsWith(File.separator) ? new String(tmpBase + File.separator + tmpPrefix + tmpSuffix.replace('-', '_') + "." + tmpExtension) : new String(tmpBase + File.separator + tmpPrefix + tmpSuffix.replace('-', '_') + "." + tmpExtension);
        script = new File(tmpName);
        script.deleteOnExit();
        id = UUID.randomUUID();
        tmpPrefix = new String(TEMP_PREFIX);
        tmpSuffix = new String("_" + id);
        tmpBase = new String(System.getProperty("java.io.tmpdir"));
        tmpName = tmpBase.endsWith(File.separator) ? new String(tmpBase + File.separator + tmpPrefix + tmpSuffix.replace('-', '_') + ".gisrc") : new String(tmpBase + File.separator + tmpPrefix + tmpSuffix.replace('-', '_') + ".gisrc");
        gisrc = new File(tmpName);
        gisrc.deleteOnExit();
        String mapset = new String(GrassUtils.getGrassMapsetFolder().substring(GrassUtils.getGrassMapsetFolder().lastIndexOf(File.separator) + 1, GrassUtils.getGrassMapsetFolder().length()));
        String path = new String(GrassUtils.getGrassMapsetFolder().substring(0, GrassUtils.getGrassMapsetFolder().lastIndexOf(File.separator)));
        String location = new String(path.substring(path.lastIndexOf(File.separator) + 1, path.length()));
        String gisdbase = new String(path.substring(0, path.lastIndexOf(File.separator)));
        try {
            output = new BufferedWriter(new FileWriter(gisrc));
            output.write("GISDBASE: " + gisdbase + "\n");
            output.write("LOCATION_NAME: " + location + "\n");
            output.write("MAPSET: " + mapset + "\n");
            output.write("GRASS_GUI: text\n");
            output.close();
        }
        catch (Exception e) {
            return null;
        }
        if (Sextante.isUnix() || Sextante.isMacOSX()) {
            String grassfolder = new String(sFolder);
            try {
                output = new BufferedWriter(new FileWriter(script));
                output.write("#!/bin/sh\n");
                output.write("export GISRC=\"" + gisrc.getAbsolutePath() + "\"\n");
                output.write("export GISBASE=\"" + grassfolder + "\"\n");
                output.write("export GRASS_PROJSHARE=\"" + grassfolder + File.separator + "share" + File.separator + "proj" + "\"\n");
                output.write("export GRASS_MESSAGE_FORMAT=gui\n");
                output.write("export GRASS_SH=/bin/sh\n");
                output.write("export GRASS_PERL=/usr/bin/perl\n");
                output.write("export GRASS_VERSION=\"" + GrassUtils.getGrassVersion() + "\"\n");
                output.write("export GIS_LOCK=$$\n");
                output.write("\n");
                output.write("if [ \"$LC_ALL\" ] ; then\n");
                output.write("\tLCL=`echo \"$LC_ALL\" | sed 's/\\(..\\)\\(.*\\)/\\1/'`\n");
                output.write("elif [ \"$LC_MESSAGES\" ] ; then\n");
                output.write("\tLCL=`echo \"$LC_MESSAGES\" | sed 's/\\(..\\)\\(.*\\)/\\1/'`\n");
                output.write("else\n");
                output.write("\tLCL=`echo \"$LANG\" | sed 's/\\(..\\)\\(.*\\)/\\1/'`\n");
                output.write("fi\n");
                output.write("\n");
                output.write("if [ -n \"$GRASS_ADDON_PATH\" ] ; then\n");
                output.write("\tPATH=\"" + grassfolder + "/bin:" + grassfolder + "/scripts:$GRASS_ADDON_PATH:$PATH\"\n");
                output.write("else\n");
                output.write("\tPATH=\"" + grassfolder + "/bin:" + grassfolder + "/scripts:$PATH\"\n");
                output.write("fi\n");
                output.write("export PATH\n");
                output.write("\n");
                if (Sextante.isMacOSX()) {
                    output.write("if [ ! \"$DYLD_LIBRARY_PATH\" ] ; then\n");
                    output.write("\tDYLD_LIBRARY_PATH=\"$GISBASE/lib\"\n");
                    output.write("else\n");
                    output.write("\tDYLD_LIBRARY_PATH=\"$GISBASE/lib:$DYLD_LIBRARY_PATH\"\n");
                    output.write("fi\n");
                    output.write("export DYLD_LIBRARY_PATH\n");
                } else {
                    output.write("if [ ! \"$LD_LIBRARY_PATH\" ] ; then\n");
                    output.write("\tLD_LIBRARY_PATH=\"$GISBASE/lib\"\n");
                    output.write("else\n");
                    output.write("\tLD_LIBRARY_PATH=\"$GISBASE/lib:$LD_LIBRARY_PATH\"\n");
                    output.write("fi\n");
                    output.write("export LD_LIBRARY_PATH\n");
                }
                output.write("\n");
                output.write("if [ ! \"$GRASS_PYTHON\" ] ; then\n");
                output.write("\tGRASS_PYTHON=python\n");
                output.write("fi\n");
                output.write("export GRASS_PYTHON\n");
                output.write("if [ ! \"$PYTHONPATH\" ] ; then\n");
                output.write("\tPYTHONPATH=\"$GISBASE/etc/python\"\n");
                output.write("else\n");
                output.write("\tPYTHONPATH=\"$GISBASE/etc/python:$PYTHONPATH\"\n");
                output.write("fi\n");
                output.write("export PYTHONPATH\n");
                output.write("\n");
                output.write("if [ ! \"$GRASS_GNUPLOT\" ] ; then\n");
                output.write("\tGRASS_GNUPLOT=\"gnuplot -persist\"\n");
                output.write("\texport GRASS_GNUPLOT\n");
                output.write("fi\n");
                output.write("\n");
                output.write("if [ \"$GRASS_FONT_CAP\" ] && [ ! -f \"$GRASS_FONT_CAP\" ] ; then\n");
                output.write("\tg.mkfontcap\n");
                output.write("fi\n");
                output.write("\n");
                output.write("g.gisenv set=\"MAPSET=" + mapset + "\"\n");
                output.write("g.gisenv set=\"LOCATION=" + location + "\"\n");
                output.write("g.gisenv set=\"LOCATION_NAME=" + location + "\"\n");
                output.write("g.gisenv set=\"GISDBASE=" + gisdbase + "\"\n");
                output.write("g.gisenv set=\"GRASS_GUI=text\"\n");
                output.write("\n");
                output.write("\"" + grassfolder + File.separator + "etc" + File.separator + "run\" " + "\"$GRASS_BATCH_JOB\" 1>&2\n");
                output.write("\n");
                output.close();
                GrassUtils.setExecutable(script.getAbsolutePath());
            }
            catch (Exception e) {
                return null;
            }
        }
        String shToolsPath = "";
        if (sWinShell.length() < 2 || sWinShell == null) {
            return null;
        }
        shToolsPath = sWinShell;
        shToolsPath = shToolsPath.substring(0, shToolsPath.lastIndexOf(File.separator));
        try {
            output = new BufferedWriter(new FileWriter(script));
            output.write("@echo off\n");
            output.write("set HOME=" + System.getProperty("user.home") + "\n");
            output.write("set GISRC=" + gisrc.getAbsolutePath() + "\n");
            output.write("set GRASS_SH=" + sWinShell + "\n");
            output.write("set PATH=" + shToolsPath + File.separator + ";" + "%PATH%\n");
            output.write("set WINGISBASE=" + sFolder + "\n");
            output.write("set GISBASE=" + sFolder + "\n");
            output.write("set GRASS_PROJSHARE=" + sFolder + File.separator + "share" + File.separator + "proj" + "\n");
            output.write("set GRASS_MESSAGE_FORMAT=gui\n");
            output.write("if \"%GRASS_ADDON_PATH%\"==\"\" set PATH=%WINGISBASE%\\bin;%WINGISBASE%\\scripts;%WINGISBASE%\\lib;%PATH%\n");
            output.write("if not \"%GRASS_ADDON_PATH%\"==\"\" set PATH=%WINGISBASE%\\bin;%WINGISBASE%\\scripts;%WINGISBASE%\\lib;%GRASS_ADDON_PATH%;%PATH%\n");
            output.write("\n");
            output.write("set GRASS_VERSION=" + GrassUtils.getGrassVersion() + "\n");
            output.write("if not \"%LANG%\"==\"\" goto langset\n");
            output.write("FOR /F \"usebackq delims==\" %%i IN (`\"%WINGISBASE%\\etc\\winlocale\"`) DO @set LANG=%%i\n");
            output.write(":langset\n");
            output.write("\n");
            output.write("set PATHEXT=%PATHEXT%;.PY\n");
            output.write("set PYTHONPATH=%PYTHONPATH%;%WINGISBASE%\\etc\\python;%WINGISBASE%\\etc\\wxpython\\n");
            output.write("\n");
            output.write("g.gisenv.exe set=\"MAPSET=" + mapset + "\"\n");
            output.write("g.gisenv.exe set=\"LOCATION=" + location + "\"\n");
            output.write("g.gisenv.exe set=\"LOCATION_NAME=" + location + "\"\n");
            output.write("g.gisenv.exe set=\"GISDBASE=" + gisdbase + "\"\n");
            output.write("g.gisenv.exe set=\"GRASS_GUI=text\"\n");
            output.write(cmdline);
            output.write("\n");
            output.write("exit\n");
            output.close();
        }
        catch (Exception e) {
            return null;
        }
        if (script != null) {
            return script;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static ProcessBuilder getGrassExecutable(String cmdline) {
        String sFolder = SextanteGUI.getSettingParameterValue("GrassBinariesFolder");
        ArrayList<String> list = new ArrayList<String>();
        ProcessBuilder pb = new ProcessBuilder(list);
        Map<String, String> env = pb.environment();
        env.put("GRASS_BATCH_JOB", GrassUtils.getBatchJobFile());
        if (Sextante.isUnix() || Sextante.isMacOSX()) {
            env.put("GRASS_MESSAGE_FORMAT", "gui");
            env.put("GISBASE", sFolder);
            File script = GrassUtils.createStartupScript(cmdline);
            if (script == null) return null;
            list.add(script.getAbsolutePath());
            return pb;
        } else {
            list.add("cmd.exe");
            list.add("/C");
            File script = GrassUtils.createStartupScript(cmdline);
            if (script == null) return null;
            list.add(script.getAbsolutePath());
        }
        return pb;
    }

    public static String getBatchJobFile() {
        String sFile = Sextante.isUnix() || Sextante.isMacOSX() ? "sextante_batch_job.sh" : "sextante_batch_job.bat";
        sFile = SextanteGUI.getUserFolder() + File.separator + sFile;
        return sFile;
    }

    public static String getTempMapName(String sPrefix) {
        String sName;
        boolean exists;
        do {
            exists = false;
            UUID id = UUID.randomUUID();
            String tmpName = new String(sPrefix + id);
            sName = new String(tmpName.replace('-', '_'));
            File vectordir = new File(GrassUtils.getGrassMapsetFolder() + File.separator + "vector" + File.separator + sName);
            File rasterfile = new File(GrassUtils.getGrassMapsetFolder() + File.separator + "cellhd" + File.separator + sName);
            File regionfile = new File(GrassUtils.getGrassMapsetFolder() + File.separator + "windows" + File.separator + sName);
            File voxelfile = new File(GrassUtils.getGrassMapsetFolder() + File.separator + "grid3d" + File.separator + sName);
            File catfile = new File(GrassUtils.getGrassMapsetFolder() + File.separator + "cats" + File.separator + sName);
            File groupfile = new File(GrassUtils.getGrassMapsetFolder() + File.separator + "group" + File.separator + sName);
            if (!vectordir.exists() && !rasterfile.exists() && !regionfile.exists() && !voxelfile.exists() && !catfile.exists() && !groupfile.exists()) continue;
            exists = true;
        } while (exists);
        return sName;
    }

    public static String getTempMapName() {
        return GrassUtils.getTempMapName("SGI_");
    }

    public static boolean isLatLon() {
        String mapSetFolder = new String(GrassUtils.getGrassMapsetFolder().substring(0, GrassUtils.getGrassMapsetFolder().lastIndexOf(File.separator)) + File.separator + "PERMANENT/PROJ_UNITS");
        try {
            String line;
            FileInputStream fstream = new FileInputStream(mapSetFolder);
            DataInputStream in = new DataInputStream(fstream);
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            while ((line = br.readLine()) != null) {
                if (!line.contains("degree")) continue;
                in.close();
                return true;
            }
            in.close();
        }
        catch (Exception e) {
            Sextante.addWarningToLog((String)"GRASS Interface: could not determine coordinate system. Assuming X/Y(/Z) cartesian.\n");
        }
        return false;
    }

    public static boolean isMultiGeom(String sMapName) throws GrassExecutionException {
        boolean is_multi_geom = false;
        int num_points = GrassVInfoUtils.getNumPoints(sMapName);
        int num_lines = GrassVInfoUtils.getNumLines(sMapName);
        int num_polygons = GrassVInfoUtils.getNumPolygons(sMapName);
        int num_faces = GrassVInfoUtils.getNumFaces(sMapName);
        int num_kernels = GrassVInfoUtils.getNumKernels(sMapName);
        if (num_points > 0 && (num_kernels > 0 || num_lines > 0 || num_polygons > 0 || num_faces > 0)) {
            is_multi_geom = true;
        }
        if (num_kernels > 0 && (num_points > 0 || num_lines > 0 || num_polygons > 0 || num_faces > 0)) {
            is_multi_geom = true;
        }
        if (num_lines > 0 && (num_points > 0 || num_kernels > 0 || num_polygons > 0 || num_faces > 0)) {
            is_multi_geom = true;
        }
        if (num_polygons > 0 && (num_points > 0 || num_kernels > 0 || num_lines > 0 || num_faces > 0)) {
            is_multi_geom = true;
        }
        if (num_faces > 0 && (num_points > 0 || num_kernels > 0 || num_lines > 0 || num_polygons > 0)) {
            is_multi_geom = true;
        }
        if (num_points + num_lines + num_polygons + num_faces + num_kernels == 0) {
            JOptionPane.showMessageDialog(null, Sextante.getText((String)"grass_error_geometries_none_found"), Sextante.getText((String)"grass_error_title"), 2);
            throw new GrassExecutionException();
        }
        return is_multi_geom;
    }

    public static void filterGRASSOutput(String line) throws GrassExecutionException {
        boolean skip = false;
        if (m_Alg == null) {
            return;
        }
        if (!line.contains("GRASS_INFO_PERCENT")) {
            if (line.length() < 2) {
                if (lastWasEmpty || lastWasInfoEnd) {
                    skip = true;
                }
                lastWasEmpty = true;
            } else {
                lastWasEmpty = false;
            }
            if (insideRegPrimitives) {
                skip = true;
            }
            if (line.contains(TEMP_PREFIX) || line.contains("_")) {
                for (int i = 0; i < m_Alg.getMapNames().size(); ++i) {
                    line = line.replace(m_Alg.getMapNames().get(i), "<" + m_Alg.getFileNames().get(i) + ">");
                }
                line = line.replaceAll("([_][a-z0-9]{8}[_][a-z0-9]{4}[_][a-z0-9]{4}[_][a-z0-9]{4}[_][a-z0-9]{12})", "[TMP]");
            }
            if (line.startsWith("set") || line.startsWith("if") || line.startsWith("FOR")) {
                skip = true;
            }
            if (line.contains("Welcome to GRASS")) {
                skip = true;
            }
            if (line.contains("Closing monitors ...")) {
                skip = true;
            }
            if (line.contains("Cleaning up temporary files ...")) {
                skip = true;
            }
            if (line.contains("(defined in GRASS_BATCH_JOB variable) was executed.")) {
                skip = true;
            }
            if (line.contains("d.mon: not found")) {
                skip = true;
            }
            if (line.contains("Goodbye from GRASS GIS")) {
                skip = true;
            }
            if (line.contains("Starting GRASS ...")) {
                skip = true;
            }
            if (line.contains("Executing '") && line.contains("' ...")) {
                skip = true;
            }
            if (line.contains("Executing '") && line.contains("' ...")) {
                skip = true;
            }
            if (line.contains("r.out.gdal complete.")) {
                skip = true;
            }
            if (line.contains("Building topology for vector map <")) {
                line = "Building topology for vector map...";
                skip = true;
            }
            if (line.contains("Registering primitives...")) {
                insideRegPrimitives = true;
            }
            if (line.contains(" primitives registered")) {
                insideRegPrimitives = false;
                skip = false;
            }
            if (line.contains("GRASS_INFO_MESSAGE")) {
                if (!line.contains(":")) {
                    skip = true;
                } else {
                    line = line.length() >= line.indexOf(":") + 3 ? line.substring(line.indexOf(":") + 2) : " ";
                }
            }
            if (line.contains("GRASS_INFO_ERROR") || line.startsWith("ERROR:")) {
                if (!line.contains(":")) {
                    skip = true;
                } else {
                    line = line.length() >= line.indexOf(":") + 3 ? "ERROR: " + line.substring(line.indexOf(":") + 2) : " ";
                }
                JOptionPane.showMessageDialog(null, line, Sextante.getText((String)"grass_error_title"), 0);
                GrassAlgorithmProvider.addMessage(line);
                m_bProcCanceled = true;
                Sextante.addErrorToLog((String)("SEXTANTE GRASS interface: " + line));
                throw new GrassExecutionException();
            }
            if (line.contains("GRASS_INFO_WARNING")) {
                if (!line.contains(":")) {
                    skip = true;
                } else {
                    line = line.length() >= line.indexOf(":") + 3 ? "WARNING: " + line.substring(line.indexOf(":") + 2) : " ";
                }
            }
            lastWasInfoEnd = line.contains("GRASS_INFO_END");
            if (line.contains("<PROJ_INFO> file not found")) {
                skip = true;
            }
            if (line.contains("<PROJ_UNITS> file not found")) {
                skip = true;
            }
            if (line.contains("ERROR 6: SetColorTable() only supported")) {
                skip = true;
            }
            if (line.contains("Unable to set projection")) {
                skip = true;
            }
        }
        if (!skip) {
            if (line.contains("GRASS_INFO_PERCENT")) {
                m_Alg.updateProgress(Integer.valueOf(line.substring(line.indexOf(":") + 2)), 100);
            }
            if (line.contains("GRASS_INFO_PERCENT")) {
                if (line.contains(": 100")) {
                    line = "(100%)";
                } else {
                    skip = true;
                }
            }
            if (line.contains("GRASS_INFO_END")) {
                skip = true;
            }
            if (!skip) {
                GrassAlgorithmProvider.addMessage(line);
            }
        } else {
            lastWasEmpty = true;
        }
    }

    private static boolean isLineTerminator(char c) {
        return c == '\n' || c == '\r' || c == '\u0085' || c == '\u2028' || c == '\u2029';
    }

    public static void runGRASS(StringBuffer sCommand, String sMessage, GrassAlgorithm alg) throws GrassExecutionException {
        String sWinShell;
        Writer output = null;
        m_Alg = alg;
        m_bProcCanceled = false;
        if (Sextante.isWindows() && ((sWinShell = SextanteGUI.getSettingParameterValue("GrassWinShell")) == null || sWinShell.length() < 2)) {
            JOptionPane.showMessageDialog(null, Sextante.getText((String)"grass_error_shell_missing") + "\n" + Sextante.getText((String)"grass_shell_url"), Sextante.getText((String)"grass_error_title"), 0);
            throw new GrassExecutionException();
        }
        File mapset = new File(GrassUtils.getGrassMapsetFolder());
        if (!mapset.exists()) {
            JOptionPane.showMessageDialog(null, Sextante.getText((String)"grass_error_mapset_missing"), Sextante.getText((String)"grass_error_title"), 0);
            throw new GrassExecutionException();
        }
        File lockfile = new File(GrassUtils.getGrassMapsetFolder() + File.separator + ".gislock");
        if (lockfile.exists()) {
            JOptionPane.showMessageDialog(null, Sextante.getText((String)"grass_error_mapset_locked"), Sextante.getText((String)"grass_error_title"), 0);
            throw new GrassExecutionException();
        }
        if (!Sextante.isWindows()) {
            try {
                output = new BufferedWriter(new FileWriter(GrassUtils.getBatchJobFile()));
                output.write(sCommand.toString());
            }
            catch (Exception e) {
                throw new GrassExecutionException();
            }
            finally {
                if (output != null) {
                    try {
                        output.close();
                    }
                    catch (IOException e) {
                        throw new GrassExecutionException();
                    }
                }
                GrassUtils.setExecutable(GrassUtils.getBatchJobFile());
            }
        }
        Sextante.addInfoToLog((String)(sMessage + " " + sCommand));
        try {
            ProcessBuilder pb = GrassUtils.getGrassExecutable(sCommand.toString());
            if (Sextante.isWindows()) {
                Process process;
                m_Proc = process = pb.start();
                StreamGobbler errorGobbler = new StreamGobbler(process.getErrorStream());
                StreamGobbler outputGobbler = new StreamGobbler(process.getInputStream());
                errorGobbler.start();
                outputGobbler.start();
                process.waitFor();
            } else {
                int num_read_stdin;
                int num_read_stderr;
                Process process;
                m_Proc = process = pb.start();
                InputStream eis = process.getErrorStream();
                InputStreamReader eisr = new InputStreamReader(eis);
                InputStream is = process.getInputStream();
                InputStreamReader isr = new InputStreamReader(is);
                char[] stderr = new char[8192];
                char[] stdin = new char[8192];
                int pos_stderr = 0;
                int pos_stdin = 0;
                Object fis = null;
                Object in = null;
                char[] line = new char[8192];
                boolean pos = false;
                int num_read = -1;
                while ((num_read_stderr = eisr.read(stderr, pos_stderr, 1)) != -1) {
                    if (pos_stderr == 8191) {
                        stderr[pos_stderr] = 10;
                    }
                    if (!GrassUtils.isLineTerminator(stderr[pos_stderr])) {
                        ++pos_stderr;
                        continue;
                    }
                    GrassUtils.filterGRASSOutput(String.copyValueOf(stderr).trim());
                    stderr = new char[8192];
                    pos_stderr = 0;
                }
                while ((num_read_stdin = isr.read(stdin, pos_stdin, 1)) != -1) {
                    if (pos_stdin == 8191) {
                        stdin[pos_stdin] = 10;
                    }
                    if (!GrassUtils.isLineTerminator(stdin[pos_stdin])) {
                        ++pos_stdin;
                        continue;
                    }
                    GrassUtils.filterGRASSOutput(String.copyValueOf(stdin).trim());
                    stdin = new char[8192];
                    pos_stdin = 0;
                }
            }
        }
        catch (Exception e) {
            throw new GrassExecutionException();
        }
    }

    public static void setExecutable(String pathname) throws GrassExecutionException {
        String version = System.getProperty("java.version").substring(0, 3);
        Float f = Float.valueOf(version);
        if (f.floatValue() < 1.6f) {
            if (Sextante.isUnix() || Sextante.isMacOSX()) {
                try {
                    Runtime.getRuntime().exec("chmod +x " + pathname);
                }
                catch (IOException e) {
                    throw new GrassExecutionException();
                }
            }
        } else if (Sextante.isUnix() || Sextante.isMacOSX()) {
            new File(pathname).setExecutable(true);
        }
    }

    public static void createTempMapset() throws IOException {
        boolean bIsLatLon = new Boolean(SextanteGUI.getSettingParameterValue("GrassLatLonMode"));
        String tmpFolder = new String(GrassUtils.getGrassMapsetFolder().substring(0, GrassUtils.getGrassMapsetFolder().lastIndexOf(File.separator)));
        boolean b = new File(tmpFolder).mkdir();
        new File(tmpFolder + File.separator + "PERMANENT").mkdir();
        new File(tmpFolder + File.separator + "user").mkdir();
        new File(tmpFolder + File.separator + "PERMANENT" + File.separator + ".tmp").mkdir();
        GrassUtils.writeGRASSWindow(tmpFolder + File.separator + "PERMANENT" + File.separator + "DEFAULT_WIND");
        new File(tmpFolder + File.separator + "PERMANENT" + File.separator + "MYNAME").createNewFile();
        FileWriter fstream = new FileWriter(tmpFolder + File.separator + "PERMANENT" + File.separator + "MYNAME");
        BufferedWriter out = new BufferedWriter(fstream);
        if (!bIsLatLon) {
            out.write("SEXTANTE GRASS interface: temporary x/y data processing location.\n");
        } else {
            out.write("SEXTANTE GRASS interface: temporary lat/lon data processing location.\n");
        }
        out.close();
        if (bIsLatLon) {
            new File(tmpFolder + File.separator + "PERMANENT" + File.separator + "PROJ_INFO").createNewFile();
            fstream = new FileWriter(tmpFolder + File.separator + "PERMANENT" + File.separator + "PROJ_INFO");
            out = new BufferedWriter(fstream);
            out.write("name: Latitude-Longitude\n");
            out.write("proj: ll\n");
            out.write("ellps: wgs84\n");
            out.close();
            new File(tmpFolder + File.separator + "PERMANENT" + File.separator + "PROJ_UNITS").createNewFile();
            fstream = new FileWriter(tmpFolder + File.separator + "PERMANENT" + File.separator + "PROJ_UNITS");
            out = new BufferedWriter(fstream);
            out.write("unit: degree\n");
            out.write("units: degrees\n");
            out.write("meters: 1.0\n");
            out.close();
        }
        GrassUtils.writeGRASSWindow(tmpFolder + File.separator + "PERMANENT" + File.separator + "WIND");
        new File(tmpFolder + File.separator + "user" + File.separator + "dbf").mkdir();
        new File(tmpFolder + File.separator + "user" + File.separator + ".tmp").mkdir();
        new File(tmpFolder + File.separator + "user" + File.separator + "VAR").createNewFile();
        fstream = new FileWriter(tmpFolder + File.separator + "user" + File.separator + "VAR");
        out = new BufferedWriter(fstream);
        out.write("DB_DRIVER: dbf\n");
        out.write("DB_DATABASE: $GISDBASE/$LOCATION_NAME/$MAPSET/dbf/\n");
        out.close();
        GrassUtils.writeGRASSWindow(tmpFolder + File.separator + "user" + File.separator + "WIND");
    }

    private static void writeGRASSWindow(String filename) throws IOException {
        new File(filename).createNewFile();
        FileWriter fstream = new FileWriter(filename);
        BufferedWriter out = new BufferedWriter(fstream);
        boolean bIsLatLon = new Boolean(SextanteGUI.getSettingParameterValue("GrassLatLonMode"));
        if (!bIsLatLon) {
            out.write("proj:       0\n");
            out.write("zone:       0\n");
            out.write("north:      1\n");
            out.write("south:      0\n");
            out.write("east:       1\n");
            out.write("west:       0\n");
            out.write("cols:       1\n");
            out.write("rows:       1\n");
            out.write("e-w resol:  1\n");
            out.write("n-s resol:  1\n");
            out.write("top:        1\n");
            out.write("bottom:     0\n");
            out.write("cols3:      1\n");
            out.write("rows3:      1\n");
            out.write("depths:     1\n");
            out.write("e-w resol3: 1\n");
            out.write("n-s resol3: 1\n");
            out.write("t-b resol:  1\n");
        } else {
            out.write("proj:       3\n");
            out.write("zone:       0\n");
            out.write("north:      1N\n");
            out.write("south:      0\n");
            out.write("east:       1E\n");
            out.write("west:       0\n");
            out.write("cols:       1\n");
            out.write("rows:       1\n");
            out.write("e-w resol:  1\n");
            out.write("n-s resol:  1\n");
            out.write("top:        1\n");
            out.write("bottom:     0\n");
            out.write("cols3:      1\n");
            out.write("rows3:      1\n");
            out.write("depths:     1\n");
            out.write("e-w resol3: 1\n");
            out.write("n-s resol3: 1\n");
            out.write("t-b resol:  1\n");
        }
        out.close();
    }

    private static boolean deleteDirectory(File path) {
        if (path.exists()) {
            File[] files = path.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    GrassUtils.deleteDirectory(files[i]);
                    continue;
                }
                files[i].delete();
            }
        }
        return path.delete();
    }

    public static void deleteTempMapset() {
        String tmpFolder;
        if (GrassUtils.getGrassMapsetFolder() != null && GrassUtils.getGrassMapsetFolder().length() > 2 && new File(tmpFolder = new String(GrassUtils.getGrassMapsetFolder().substring(0, GrassUtils.getGrassMapsetFolder().lastIndexOf(File.separator)))).exists()) {
            GrassUtils.deleteDirectory(new File(tmpFolder));
        }
    }

    public static void writeColorTable(Output out) {
        FileOutputChannel channel = (FileOutputChannel)out.getOutputChannel();
        File colorTable = new File(GrassUtils.getGrassMapsetFolder() + File.separator + "colr" + File.separator + out.getName());
        if (colorTable.exists()) {
            BufferedWriter output = null;
            try {
                BufferedReader in = new BufferedReader(new FileReader(colorTable));
                String line = new String();
                int errors = 0;
                String filename = channel.getFilename();
                filename = filename.substring(0, filename.lastIndexOf("."));
                filename = filename + "." + colorTableExt;
                File delFile = new File(filename);
                delFile.deleteOnExit();
                output = new BufferedWriter(new FileWriter(delFile));
                output.write("SEXTANTE GRASS Interface Color Table;1.0\n");
                while ((line = in.readLine()) != null) {
                    if (line.startsWith("%")) continue;
                    String[] token = new String[2];
                    String from = null;
                    String to = null;
                    errors = 0;
                    for (int i = 0; i < 2; ++i) {
                        token[i] = i == 0 ? line.substring(0, line.indexOf(" ")) : line.substring(line.lastIndexOf(" ") + 1, line.length());
                        if (token[i] == null || token[i].length() <= 1) continue;
                        String R = null;
                        String G = null;
                        String B = null;
                        int component_no = 0;
                        if (i == 0) {
                            from = token[i].substring(0, token[i].indexOf(":"));
                        } else {
                            to = token[i].substring(0, token[i].indexOf(":"));
                        }
                        int start_pos = token[i].indexOf(":");
                        while (start_pos != -1) {
                            token[i] = token[i].substring(start_pos + 1, token[i].length());
                            if (token[i].indexOf(":") != -1) {
                                if (component_no == 0) {
                                    R = token[i].substring(0, token[i].indexOf(":"));
                                }
                                if (component_no == 1) {
                                    G = token[i].substring(0, token[i].indexOf(":"));
                                }
                                if (component_no == 2) {
                                    B = token[i].substring(0, token[i].indexOf(":"));
                                }
                            } else {
                                if (component_no == 0) {
                                    R = token[i].substring(0, token[i].length());
                                }
                                if (component_no == 1) {
                                    G = token[i].substring(0, token[i].length());
                                }
                                if (component_no == 2) {
                                    B = token[i].substring(0, token[i].length());
                                }
                            }
                            start_pos = token[i].indexOf(":");
                            ++component_no;
                        }
                        if (G == null && R != null) {
                            G = new String(R);
                        }
                        if (B == null && R != null) {
                            B = new String(R);
                        }
                        if (R == null) {
                            ++errors;
                        } else if (Integer.valueOf(R) < 0 || Integer.valueOf(R) > 255) {
                            ++errors;
                        }
                        if (G == null) {
                            ++errors;
                        } else if (Integer.valueOf(G) < 0 || Integer.valueOf(G) > 255) {
                            ++errors;
                        }
                        if (B == null) {
                            ++errors;
                        } else if (Integer.valueOf(B) < 0 || Integer.valueOf(B) > 255) {
                            ++errors;
                        }
                        if (i == 0 && from == null) {
                            ++errors;
                        }
                        if (i == 1 && to == null) {
                            ++errors;
                        }
                        if (errors != 0) continue;
                        if (i == 0) {
                            output.write("FROM: " + from + "\n");
                        } else {
                            output.write("TO: " + to + "\n");
                        }
                        output.write("R: " + R + "\n");
                        output.write("G: " + G + "\n");
                        output.write("B: " + B + "\n");
                    }
                }
                if (output != null) {
                    output.close();
                }
            }
            catch (Exception e) {
                Sextante.addErrorToLog((String)Sextante.getText((String)"grass_error_color_table"));
            }
        }
    }

    public static String getGrassMapsetFolder() {
        return m_sGrassTempMapsetFolder;
    }

    public static void createTempMapsetName() {
        UUID id = UUID.randomUUID();
        String tmpPrefix = new String(TEMP_PREFIX);
        String tmpSuffix = new String("_" + id);
        String tmpBase = new String(System.getProperty("java.io.tmpdir"));
        String tmpFolder = tmpBase.endsWith(File.separator) ? new String(tmpBase + tmpPrefix + tmpSuffix.replace('-', '_') + File.separator + "user") : new String(tmpBase + File.separator + tmpPrefix + tmpSuffix.replace('-', '_') + File.separator + "user");
        m_sGrassTempMapsetFolder = tmpFolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getGrassVersion() {
        String sFolder = SextanteGUI.getSettingParameterValue("GrassBinariesFolder");
        InputStreamReader isr = null;
        BufferedReader br = null;
        try {
            String sLine;
            File file = new File(sFolder + File.separator + "etc" + File.separator + "VERSIONNUMBER");
            isr = new InputStreamReader(new FileInputStream(file));
            br = new BufferedReader(isr);
            String string = sLine = br.readLine().trim();
            return string;
        }
        catch (Exception e) {
            String string = null;
            return string;
        }
        finally {
            try {
                br.close();
                isr.close();
            }
            catch (Exception e) {
                return null;
            }
        }
    }

    static {
        m_Proc = null;
        m_bProcCanceled = false;
        m_bProcInterruptible = true;
    }
}

