/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gui.help;

import es.unex.sextante.additionalInfo.AdditionalInfoVectorLayer;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.OutputObjectsSet;
import es.unex.sextante.core.ParametersSet;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.docEngines.html.HTMLDoc;
import es.unex.sextante.exceptions.NullParameterAdditionalInfoException;
import es.unex.sextante.gui.core.SextanteGUI;
import es.unex.sextante.gui.help.HelpElement;
import es.unex.sextante.gui.help.ImageAndDescription;
import es.unex.sextante.outputs.Output;
import es.unex.sextante.outputs.Output3DRasterLayer;
import es.unex.sextante.outputs.OutputChart;
import es.unex.sextante.outputs.OutputNumericalValue;
import es.unex.sextante.outputs.OutputRasterLayer;
import es.unex.sextante.outputs.OutputTable;
import es.unex.sextante.outputs.OutputText;
import es.unex.sextante.outputs.OutputVectorLayer;
import es.unex.sextante.parameters.Parameter;
import es.unex.sextante.parameters.ParameterVectorLayer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import org.kxml2.io.KXmlParser;
import org.kxml2.io.KXmlSerializer;

public class HelpIO {
    private static String encoding = "ISO-8859-1";
    private static String HELP = "help";

    public static void save(ArrayList elements, String sFilename) {
        try {
            File file = new File(sFilename);
            if (!file.exists()) {
                String dir = file.getParent();
                new File(dir).mkdir();
                file.createNewFile();
            }
            FileWriter writer = new FileWriter(file);
            KXmlSerializer serializer = new KXmlSerializer();
            serializer.setOutput((Writer)writer);
            serializer.startDocument(encoding, new Boolean(true));
            serializer.text("\n\t");
            serializer.startTag(null, HELP);
            for (int i = 0; i < elements.size(); ++i) {
                HelpElement element = (HelpElement)elements.get(i);
                element.serialize(serializer);
            }
            serializer.text("\n\t");
            serializer.endTag(null, HELP);
            serializer.text("\n");
            serializer.startDocument(encoding, new Boolean(true));
            ((Writer)writer).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static ArrayList open(String sFilename) {
        ArrayList<ImageAndDescription> images = null;
        ArrayList<HelpElement> elements = new ArrayList<HelpElement>();
        HelpElement element = null;
        KXmlParser parser = new KXmlParser();
        try {
            File file = new File(sFilename);
            parser.setInput((InputStream)new FileInputStream(file), encoding);
            int tag = parser.nextTag();
            boolean bOut = false;
            if (parser.getEventType() != 1) {
                while (tag != 1 && !bOut) {
                    switch (tag) {
                        case 2: {
                            if (parser.getName().compareTo(HELP) == 0) break;
                            if (parser.getName().compareTo("element") == 0) {
                                images = new ArrayList<ImageAndDescription>();
                                String sText = parser.getAttributeValue("", "text");
                                String sName = parser.getAttributeValue("", "name");
                                String sDescription = parser.getAttributeValue("", "description");
                                int iType = Integer.parseInt(parser.getAttributeValue("", "type"));
                                element = new HelpElement();
                                element.setText(sText);
                                element.setName(sName);
                                element.setType(iType);
                                element.setDescription(sDescription);
                                break;
                            }
                            if (parser.getName().compareTo("image") != 0) break;
                            ImageAndDescription iad = new ImageAndDescription();
                            String sImageFilename = parser.getAttributeValue("", "file");
                            String sDesc = parser.getAttributeValue("", "description");
                            iad.setDescription(sDesc);
                            iad.setFilename(sImageFilename);
                            images.add(iad);
                            break;
                        }
                        case 3: {
                            if (parser.getName().compareTo(HELP) == 0) {
                                bOut = true;
                                break;
                            }
                            if (parser.getName().compareTo("element") != 0) break;
                            element.setImages(images);
                            elements.add(element);
                            break;
                        }
                    }
                    if (bOut) continue;
                    tag = parser.next();
                }
            }
        }
        catch (Exception e) {
            return null;
        }
        return elements;
    }

    public static String getHelpAsHTMLCode(GeoAlgorithm alg, String sFilename) {
        ImageAndDescription iad;
        ArrayList list = HelpIO.open(sFilename);
        String sPath = "file:///" + sFilename.substring(0, sFilename.lastIndexOf(File.separator)) + File.separator;
        HashMap elements = list != null ? HelpIO.createMap(list) : new HashMap();
        HTMLDoc doc = new HTMLDoc();
        doc.open(alg.getName());
        doc.addHeader(Sextante.getText((String)alg.getName()), 1);
        doc.addHeader(Sextante.getText((String)"Description"), 2);
        HelpElement element = (HelpElement)elements.get("DESCRIPTION");
        if (element != null) {
            doc.addParagraph(element.getTextAsFormattedHTML());
            for (int j = 0; j < element.getImages().size(); ++j) {
                ImageAndDescription iad2 = (ImageAndDescription)element.getImages().get(j);
                doc.addImageAndDescription(sPath + iad2.getFilename(), iad2.getDescription());
            }
        }
        doc.addHeader(Sextante.getText((String)"Parameters"), 2);
        ParametersSet params = alg.getParameters();
        doc.startUnorderedList();
        for (int i = 0; i < params.getNumberOfParameters(); ++i) {
            Parameter param = params.getParameter(i);
            String sParam = param.getParameterDescription();
            sParam = "<b>" + sParam + "[" + HelpIO.getParameterTypeName(param) + "]: </b>";
            element = (HelpElement)elements.get(param.getParameterName());
            if (element != null) {
                sParam = sParam + element.getTextAsFormattedHTML();
            }
            doc.addListElement(sParam);
            if (element == null) continue;
            for (int j = 0; j < element.getImages().size(); ++j) {
                iad = (ImageAndDescription)element.getImages().get(j);
                doc.addImageAndDescription(sPath + iad.getFilename(), iad.getDescription());
            }
        }
        doc.closeUnorderedList();
        doc.addHeader(Sextante.getText((String)"Outputs"), 2);
        element = (HelpElement)elements.get("OUTPUT_DESCRIPTION");
        if (element != null) {
            doc.addParagraph(element.getTextAsFormattedHTML());
            for (int j = 0; j < element.getImages().size(); ++j) {
                ImageAndDescription iad3 = (ImageAndDescription)element.getImages().get(j);
                doc.addImageAndDescription(sPath + iad3.getFilename(), iad3.getDescription());
            }
        }
        doc.startUnorderedList();
        OutputObjectsSet oo = alg.getOutputObjects();
        String sOutputType = "";
        for (int i = 0; i < oo.getOutputObjectsCount(); ++i) {
            Output out = oo.getOutput(i);
            String sOutput = out.getDescription();
            if (out instanceof OutputRasterLayer) {
                sOutputType = Sextante.getText((String)"Raster_Layer");
            } else if (out instanceof Output3DRasterLayer) {
                sOutputType = Sextante.getText((String)"3D_Raster_layer");
            } else if (out instanceof OutputVectorLayer) {
                sOutputType = Sextante.getText((String)"Vector_Layer");
                OutputVectorLayer ovl = (OutputVectorLayer)out;
                switch (ovl.getShapeType()) {
                    default: {
                        sOutputType = sOutputType + " - " + Sextante.getText((String)"Any_type");
                        break;
                    }
                    case 1: {
                        sOutputType = sOutputType + " - " + Sextante.getText((String)"Line");
                        break;
                    }
                    case 2: {
                        sOutputType = sOutputType + " - " + Sextante.getText((String)"Polygon");
                        break;
                    }
                    case 0: {
                        sOutputType = sOutputType + " - " + Sextante.getText((String)"Point");
                        break;
                    }
                }
            } else if (out instanceof OutputTable) {
                sOutputType = Sextante.getText((String)"Table");
            } else if (out instanceof OutputChart) {
                sOutputType = Sextante.getText((String)"graph-chart");
            } else if (out instanceof OutputText) {
                sOutputType = Sextante.getText((String)"Text");
            } else if (out instanceof OutputNumericalValue) {
                sOutputType = Sextante.getText((String)"Numerical_value");
            }
            sOutput = "<b>" + sOutput + "[" + sOutputType + "]: </b>";
            element = (HelpElement)elements.get(out.getName());
            if (element != null) {
                sOutput = sOutput + element.getTextAsFormattedHTML();
            }
            doc.addListElement(sOutput);
            if (element == null) continue;
            for (int j = 0; j < element.getImages().size(); ++j) {
                ImageAndDescription iad4 = (ImageAndDescription)element.getImages().get(j);
                doc.addImageAndDescription(sPath + iad4.getFilename(), iad4.getDescription());
            }
        }
        doc.closeUnorderedList();
        doc.addHeader(Sextante.getText((String)"Additional_information"), 2);
        element = (HelpElement)elements.get("ADDITIONAL_INFO");
        if (element != null) {
            doc.addParagraph(element.getTextAsFormattedHTML());
            for (int j = 0; j < element.getImages().size(); ++j) {
                ImageAndDescription iad5 = (ImageAndDescription)element.getImages().get(j);
                doc.addImageAndDescription(sPath + iad5.getFilename(), iad5.getDescription());
            }
        }
        doc.addHeader(Sextante.getText((String)"Command_line"), 2);
        String sText = alg.getCommandLineHelp();
        sText = sText.replaceAll("\n", "<br>");
        sText = sText.replace("   ", " &nbsp ");
        doc.addCourierText(sText);
        doc.addParagraph("");
        element = (HelpElement)elements.get("EXTENSION_AUTHOR");
        if (element != null) {
            doc.addParagraph("<i>" + Sextante.getText((String)"Algorithm_created_by") + " " + element.getText() + "</i>");
            for (int j = 0; j < element.getImages().size(); ++j) {
                iad = (ImageAndDescription)element.getImages().get(j);
                doc.addImageAndDescription(sPath + iad.getFilename(), iad.getDescription());
            }
        }
        if ((element = (HelpElement)elements.get("HELP_AUTHOR")) != null) {
            doc.addParagraph("<i>" + Sextante.getText((String)"Help_file_created_by") + " " + element.getText() + "</i>");
            for (int j = 0; j < element.getImages().size(); ++j) {
                iad = (ImageAndDescription)element.getImages().get(j);
                doc.addImageAndDescription(sPath + iad.getFilename(), iad.getDescription());
            }
        }
        doc.close();
        return doc.getHTMLCode();
    }

    private static String getParameterTypeName(Parameter param) {
        String s = Sextante.getText((String)param.getParameterTypeName().replace(' ', '_'));
        if (param instanceof ParameterVectorLayer) {
            try {
                AdditionalInfoVectorLayer ai = (AdditionalInfoVectorLayer)param.getParameterAdditionalInfo();
                switch (ai.getShapeType()) {
                    default: {
                        s = s + " - " + Sextante.getText((String)"Any_type");
                        break;
                    }
                    case 1: {
                        s = s + " - " + Sextante.getText((String)"Line");
                        break;
                    }
                    case 2: {
                        s = s + " - " + Sextante.getText((String)"Polygon");
                        break;
                    }
                    case 0: {
                        s = s + " - " + Sextante.getText((String)"Point");
                        break;
                    }
                }
            }
            catch (NullParameterAdditionalInfoException nullParameterAdditionalInfoException) {
                // empty catch block
            }
        }
        return s;
    }

    public static HashMap createMap(ArrayList list) {
        HashMap<String, HelpElement> map = new HashMap<String, HelpElement>();
        for (int i = 0; i < list.size(); ++i) {
            HelpElement element = (HelpElement)list.get(i);
            map.put(element.getName(), element);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean containsStringInHelpFile(GeoAlgorithm alg, String string) {
        BufferedReader br = null;
        InputStreamReader is = null;
        FileInputStream fis = null;
        String sName = alg.getName().toLowerCase();
        if (sName.indexOf(string) != -1) {
            return true;
        }
        try {
            String line;
            String sFilename = SextanteGUI.getAlgorithmHelpFilename(alg, false);
            fis = new FileInputStream(sFilename);
            is = new InputStreamReader(fis);
            br = new BufferedReader(is);
            while (null != (line = br.readLine())) {
                if ((line = line.toLowerCase()).indexOf(string) == -1) continue;
                br.close();
                is.close();
                fis.close();
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                br.close();
                is.close();
                fis.close();
            }
            catch (Exception exception) {}
        }
        return false;
    }

    public static String getHelpPath(GeoAlgorithm alg, boolean bForceLocale) {
        String sPackage = alg.getClass().getName();
        sPackage = sPackage.substring(0, sPackage.lastIndexOf("."));
        String sPath = SextanteGUI.getHelpPath() + File.separator + Locale.getDefault().getLanguage() + File.separator + sPackage;
        File dir = new File(sPath);
        if (!dir.exists() && !bForceLocale) {
            sPath = SextanteGUI.getHelpPath() + File.separator + Locale.ENGLISH.getLanguage() + File.separator + sPackage;
        }
        return sPath;
    }

    public static String getHelpFile(String sTopic) {
        String sPath = SextanteGUI.getHelpPath() + File.separator + Locale.getDefault().getLanguage();
        File dir = new File(sPath);
        if (!dir.exists()) {
            sPath = SextanteGUI.getHelpPath() + File.separator + Locale.ENGLISH.getLanguage();
        }
        return sPath + File.separator + "general" + File.separator + sTopic + ".html";
    }
}

