/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gui.modeler.parameters;

import es.unex.sextante.core.ParametersSet;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.gui.core.SextanteGUI;
import es.unex.sextante.gui.modeler.ColorComboBox;
import es.unex.sextante.gui.modeler.ModelerPanel;
import es.unex.sextante.parameters.Parameter;
import info.clearthought.layout.TableLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;

public abstract class ParameterPanel
extends JDialog {
    protected JPanel jPanelName;
    protected ColorComboBox jComboColor;
    protected JButton jButtonOk;
    protected JButton jButtonCancel;
    protected JLabel jLabelDescription;
    protected JPanel jPanelMiddle;
    protected JPanel jPanelButtons;
    protected JTextField jTextFieldDescription;
    protected Parameter m_Parameter;
    protected ModelerPanel m_ModelerPanel;
    protected Color m_Color = null;

    public abstract String getParameterDescription();

    protected abstract boolean prepareParameter();

    public abstract boolean parameterCanBeAdded();

    public ParameterPanel(JDialog dialog, ModelerPanel modelerPanel) {
        super(dialog, "", true);
        this.setLocationRelativeTo(null);
        this.m_ModelerPanel = modelerPanel;
        this.initGUI();
    }

    public ParameterPanel(ModelerPanel modelerPanel) {
        super(SextanteGUI.getMainFrame(), "", true);
        this.setLocationRelativeTo(null);
        this.m_ModelerPanel = modelerPanel;
        if (this.m_Color == null) {
            this.m_Color = new Color(255, 255, 255, 255);
        }
        this.initGUI();
    }

    protected void initGUI() {
        this.setResizable(false);
        TableLayout thisLayout = new TableLayout((double[][])new double[][]{{3.0, -1.0, 3.0}, {3.0, -3.0, -1.0, -3.0, 3.0, 30.0, 3.0}});
        thisLayout.setHGap(5);
        thisLayout.setVGap(5);
        this.setLayout((LayoutManager)thisLayout);
        this.jPanelName = new JPanel();
        TableLayout jPanelNameLayout = new TableLayout((double[][])new double[][]{{-3.0, 5.0, -1.0}, {20.0, 3.0, -3.0, 3.0}});
        jPanelNameLayout.setHGap(5);
        jPanelNameLayout.setVGap(5);
        this.jPanelName.setLayout((LayoutManager)jPanelNameLayout);
        this.add((Component)this.jPanelName, "1, 1");
        this.jLabelDescription = new JLabel();
        this.jPanelName.add((Component)this.jLabelDescription, "0, 0");
        this.jLabelDescription.setText(Sextante.getText((String)"Description"));
        this.jTextFieldDescription = new JTextField();
        this.jTextFieldDescription.setText(this.getDefaultName());
        this.jPanelName.add((Component)this.jTextFieldDescription, "2, 0");
        this.jPanelName.add((Component)new JSeparator(0), "0, 2, 2, 2");
        this.jPanelButtons = new JPanel();
        TableLayout jPanelButtonsLayout = new TableLayout((double[][])new double[][]{{5.0, 90.0, -1.0, 90.0, 5.0, 90.0}, {30.0}});
        this.jPanelButtons.setLayout((LayoutManager)jPanelButtonsLayout);
        this.add((Component)new JSeparator(0), "1, 3");
        this.add((Component)this.jPanelButtons, "1, 5");
        this.jComboColor = new ColorComboBox();
        if (this.m_Parameter != null) {
            this.m_Color = new Color(this.m_Parameter.getColorR(), this.m_Parameter.getColorG(), this.m_Parameter.getColorB(), this.m_Parameter.getColorAlpha());
        }
        this.jComboColor.getComboBox().setBackground(this.m_Color);
        this.jPanelButtons.add((Component)this.jComboColor.getComboBox(), "1, 0");
        this.jComboColor.getComboBox().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ParameterPanel.this.m_Color = (Color)ParameterPanel.this.jComboColor.getComboBox().getSelectedItem();
                ParameterPanel.this.jComboColor.getComboBox().setBackground(ParameterPanel.this.m_Color);
            }
        });
        this.jButtonCancel = new JButton();
        this.jButtonCancel.setText(Sextante.getText((String)"Cancel"));
        this.jPanelButtons.add((Component)this.jButtonCancel, "3, 0");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ParameterPanel.this.m_Parameter = null;
                ParameterPanel.this.cancel();
            }
        });
        this.jButtonOk = new JButton();
        this.jButtonOk.setText(Sextante.getText((String)"OK"));
        this.jPanelButtons.add((Component)this.jButtonOk, "5, 0");
        this.jButtonOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (ParameterPanel.this.prepareParameter()) {
                    ParameterPanel.this.cancel();
                }
            }
        });
        this.jPanelMiddle = new JPanel();
        FlowLayout layout = (FlowLayout)this.jPanelMiddle.getLayout();
        layout.setVgap(1);
        this.add((Component)this.jPanelMiddle, "1, 2");
    }

    protected void cancel() {
        this.dispose();
        this.setVisible(false);
    }

    public Parameter getParameter() {
        return this.m_Parameter;
    }

    public Color getColor() {
        return this.m_Color;
    }

    public void setColor(Color c) {
        this.m_Color = c;
    }

    public ColorComboBox getColorComboBox() {
        return this.jComboColor;
    }

    @Override
    public String toString() {
        return this.getParameterDescription();
    }

    private String getDefaultName() {
        String sName;
        boolean bNameFound;
        int i = 1;
        ParametersSet ps = this.m_ModelerPanel.getAlgorithm().getParameters();
        int iCount = ps.getNumberOfParameters();
        do {
            bNameFound = true;
            sName = this.getParameterDescription() + " " + Integer.toString(i);
            for (int j = 0; j < iCount; ++j) {
                Parameter param = ps.getParameter(j);
                if (!param.getParameterDescription().equals(sName)) continue;
                bNameFound = false;
                break;
            }
            ++i;
        } while (!bNameFound);
        return sName;
    }

    public void updateOptions() {
        this.jTextFieldDescription.setText(this.getDefaultName());
    }

    public void setParameter(Parameter param) {
        this.jTextFieldDescription.setText(param.getParameterDescription());
    }
}

