/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.raster.gui.wizard;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import org.cresques.cts.IProjection;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.addlayer.AddLayerDialog;
import org.gvsig.app.gui.WizardPanel;
import org.gvsig.app.gui.panels.CRSSelectPanel;
import org.gvsig.app.project.documents.gui.ListManagerSkin;
import org.gvsig.app.project.documents.view.gui.AbstractViewPanel;
import org.gvsig.app.project.documents.view.gui.FPanelLocConfig;
import org.gvsig.fmap.crs.CRSFactory;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.exception.CreateEnvelopeException;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.gui.beans.swing.JFileChooser;
import org.gvsig.raster.tools.app.basic.raster.gui.wizard.IFileOpen;
import org.gvsig.raster.tools.app.basic.raster.gui.wizard.MyFile;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.extensionpoint.ExtensionPoint;
import org.gvsig.tools.extensionpoint.ExtensionPointManager;
import org.gvsig.utils.listManager.ListManagerListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileOpenWizard
extends WizardPanel
implements ListManagerListener {
    private static final GeometryManager geomManager = GeometryLocator.getGeometryManager();
    private static final Logger logger = LoggerFactory.getLogger(FileOpenWizard.class);
    private static final String OPEN_LAYER_FILE_CHOOSER_ID = "OPEN_LAYER_FILE_CHOOSER_ID";
    private static final long serialVersionUID = 335310147513197564L;
    private static String lastPath = null;
    private JPanel jPanel2 = null;
    private JFileChooser fileChooser = null;
    private CRSSelectPanel jPanelProj = null;
    private ListManagerSkin listManagerSkin = null;
    private boolean projection = false;
    private static FileFilter lastFileFilter = null;
    private TitledBorder titledBorder = null;
    private ArrayList<IFileOpen> listFileOpen = new ArrayList();

    public FileOpenWizard() {
        this("FileExtendingOpenDialog");
    }

    public FileOpenWizard(String nameExtension) {
        this(nameExtension, true);
    }

    public FileOpenWizard(String nameExtension, boolean proj) {
        ExtensionPointManager epManager = ToolsLocator.getExtensionPointManager();
        if (!epManager.has(nameExtension)) {
            return;
        }
        Iterator iterator = epManager.get(nameExtension).iterator();
        Object obj = null;
        while (iterator.hasNext()) {
            try {
                obj = ((ExtensionPoint.Extension)iterator.next()).create();
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            if (!(obj instanceof IFileOpen)) continue;
            this.listFileOpen.add((IFileOpen)obj);
        }
        this.init(null, proj);
    }

    public FileOpenWizard(IFileOpen[] driverClasses, boolean proj) {
        this.init(driverClasses, proj);
    }

    public FileOpenWizard(IFileOpen[] driverClasses) {
        this.init(driverClasses, true);
    }

    public FileOpenWizard(IFileOpen[] driverClasses, boolean proj, String title) {
        this.setTitle(title);
        this.init(driverClasses, proj);
    }

    private void init(IFileOpen[] driverClasses, boolean projection) {
        this.projection = projection;
        if (driverClasses != null) {
            for (int i = 0; i < driverClasses.length; ++i) {
                this.listFileOpen.add(driverClasses[i]);
            }
        }
        if (lastPath == null) {
            Preferences prefs = Preferences.userRoot().node("gvsig.foldering");
            lastPath = prefs.get("DataFolder", null);
        }
        this.initialize();
    }

    public void initWizard() {
        this.setTabName(PluginServices.getText((Object)((Object)this), (String)"Fichero_Raster"));
        this.init(null, true);
    }

    private void initialize() {
        this.setSize(514, 280);
        this.setLayout(null);
        this.add(this.getJPanel2(), null);
    }

    public File[] getFiles() {
        MyFile[] files = this.getListManagerSkin().getListManager().getListModel().getObjects().toArray(new MyFile[0]);
        File[] ret = new File[files.length];
        int pos = files.length - 1;
        for (int i = 0; i < files.length; ++i) {
            ret[pos] = files[i].getFile();
            --pos;
        }
        return ret;
    }

    public MyFile[] getMyFiles() {
        return this.getListManagerSkin().getListManager().getListModel().getObjects().toArray(new MyFile[0]);
    }

    private JPanel getJPanel2() {
        if (this.jPanel2 == null) {
            this.jPanel2 = new JPanel();
            this.jPanel2.setLayout(null);
            this.jPanel2.setBorder(this.getTitledBorder());
            this.jPanel2.setPreferredSize(new Dimension(380, 200));
            this.jPanel2.setBounds(2, 2, 506, 472);
            if (this.projection) {
                this.jPanel2.add((Component)this.getJPanelProj(), null);
            }
            this.jPanel2.add((Component)this.getListManagerSkin(), null);
        }
        return this.jPanel2;
    }

    private TitledBorder getTitledBorder() {
        if (this.titledBorder == null) {
            this.titledBorder = BorderFactory.createTitledBorder(null, PluginServices.getText((Object)((Object)this), (String)"Seleccionar_fichero"), 0, 0, null, null);
            this.titledBorder.setTitle(PluginServices.getText((Object)((Object)this), (String)PluginServices.getText((Object)((Object)this), (String)"Capas")));
        }
        return this.titledBorder;
    }

    public String[] getDriverNames() {
        MyFile[] files = this.getListManagerSkin().getListManager().getListModel().getObjects().toArray(new MyFile[0]);
        String[] ret = new String[files.length];
        int pos = files.length - 1;
        for (int i = 0; i < files.length; ++i) {
            ret[pos] = files[i].getFilter().getDescription();
            --pos;
        }
        return ret;
    }

    private CRSSelectPanel getJPanelProj() {
        if (this.jPanelProj == null) {
            IProjection proj = CRSFactory.getCRS((String)"EPSG:23030");
            if (PluginServices.getMainFrame() != null) {
                proj = AddLayerDialog.getLastProjection();
            }
            this.jPanelProj = CRSSelectPanel.getPanel((IProjection)proj);
            this.jPanelProj.setTransPanelActive(true);
            this.jPanelProj.setBounds(11, 400, 448, 35);
            this.jPanelProj.setPreferredSize(new Dimension(448, 35));
            this.jPanelProj.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (FileOpenWizard.this.jPanelProj.isOkPressed()) {
                        AddLayerDialog.setLastProjection((IProjection)FileOpenWizard.this.jPanelProj.getCurProj());
                    }
                }
            });
        }
        return this.jPanelProj;
    }

    private ListManagerSkin getListManagerSkin() {
        if (this.listManagerSkin == null) {
            this.listManagerSkin = new ListManagerSkin(false);
            this.listManagerSkin.setBounds(11, 21, 491, 363);
            this.listManagerSkin.getListManager().setListener((ListManagerListener)this);
        }
        return this.listManagerSkin;
    }

    public Object[] addObjects() {
        this.callStateChanged(true);
        this.fileChooser = new JFileChooser(OPEN_LAYER_FILE_CHOOSER_ID, lastPath);
        this.fileChooser.setMultiSelectionEnabled(true);
        this.fileChooser.setAcceptAllFileFilterUsed(false);
        boolean finded = false;
        FileFilter auxFilter = null;
        for (int i = 0; i < this.listFileOpen.size(); ++i) {
            IFileOpen fileOpen = this.listFileOpen.get(i);
            fileOpen.pre();
            List<FileFilter> aux = fileOpen.getFileFilter();
            for (int j = 0; j < aux.size(); ++j) {
                FileFilter fileFilter = aux.get(j);
                this.fileChooser.addChoosableFileFilter(fileFilter);
                if (lastFileFilter == null || !lastFileFilter.getDescription().equals(fileFilter.getDescription())) continue;
                auxFilter = fileFilter;
                finded = true;
            }
        }
        if (finded && lastFileFilter != null) {
            this.fileChooser.setFileFilter(auxFilter);
        }
        int result = this.fileChooser.showOpenDialog((Component)((Object)this));
        File[] newFiles = null;
        ArrayList<MyFile> toAdd = new ArrayList<MyFile>();
        if (result == 0) {
            lastPath = this.fileChooser.getCurrentDirectory().getAbsolutePath();
            lastFileFilter = this.fileChooser.getFileFilter();
            newFiles = this.fileChooser.getSelectedFiles();
            IFileOpen lastFileOpen = null;
            block2: for (int i = 0; i < this.listFileOpen.size(); ++i) {
                IFileOpen fileOpen = this.listFileOpen.get(i);
                List<FileFilter> aux = fileOpen.getFileFilter();
                for (int j = 0; j < aux.size(); ++j) {
                    if (this.fileChooser.getFileFilter() != aux.get(j)) continue;
                    for (int iFile = 0; iFile < newFiles.length; ++iFile) {
                        newFiles[iFile] = fileOpen.post(newFiles[iFile]);
                    }
                    lastFileOpen = fileOpen;
                    continue block2;
                }
            }
            for (int ind = 0; ind < newFiles.length && newFiles[ind] != null; ++ind) {
                toAdd.add(new MyFile(newFiles[ind], this.fileChooser.getFileFilter(), lastFileOpen));
            }
            return toAdd.toArray();
        }
        return new Object[0];
    }

    public void execute() {
        int i;
        if (this.getFiles() == null) {
            return;
        }
        MapControl mapControl = null;
        IWindow[] w = PluginServices.getMDIManager().getAllWindows();
        for (i = 0; i < w.length; ++i) {
            if (!(w[i] instanceof FPanelLocConfig)) continue;
            mapControl = ((FPanelLocConfig)w[i]).getMapCtrl();
            DefaultListModel lstModel = (DefaultListModel)((FPanelLocConfig)w[i]).getJList().getModel();
            lstModel.clear();
            for (int k = 0; k < this.getFiles().length; ++k) {
                lstModel.addElement(this.getFiles()[k].getName());
            }
            for (int j = mapControl.getMapContext().getLayers().getLayersCount() - 1; j >= 0; --j) {
                FLayer lyr = mapControl.getMapContext().getLayers().getLayer(j);
                lstModel.addElement(lyr.getName());
            }
        }
        if (mapControl == null) {
            for (i = 0; i < w.length; ++i) {
                IWindow activeWindow = PluginServices.getMDIManager().getActiveWindow();
                if (!(w[i] instanceof AbstractViewPanel) || !w[i].equals(activeWindow)) continue;
                mapControl = ((AbstractViewPanel)w[i]).getMapControl();
            }
        }
        if (mapControl == null) {
            for (i = 0; i < w.length; ++i) {
                if (!(w[i] instanceof AbstractViewPanel)) continue;
                mapControl = ((AbstractViewPanel)w[i]).getMapControl();
            }
        }
        Envelope[] rects = new Envelope[this.getFiles().length];
        boolean first = false;
        for (int i2 = this.getMyFiles().length - 1; i2 >= 0; --i2) {
            if (mapControl != null && mapControl.getMapContext().getViewPort().getExtent() == null) {
                first = true;
            }
            rects[i2] = this.getMyFiles()[i2].createLayer(mapControl);
        }
        if (first && rects.length > 1) {
            try {
                Envelope rect = geomManager.createEnvelope(rects[0].getMinimum(0), rects[0].getMinimum(1), rects[0].getMaximum(0), rects[0].getMaximum(1), 0);
                for (int i3 = 0; i3 < rects.length; ++i3) {
                    if (rects[i3] == null) continue;
                    rect.add(rects[i3]);
                }
                if (mapControl != null) {
                    mapControl.getMapContext().getViewPort().setEnvelope(rect);
                }
            }
            catch (CreateEnvelopeException e) {
                logger.error("Error creating the envelope", (Throwable)e);
            }
        }
        if (mapControl != null) {
            mapControl.getMapContext().endAtomicEvent();
        }
    }

    public void setTitle(String title) {
        this.getTitledBorder().setTitle(title);
    }

    public Object getProperties(Object selected) {
        return null;
    }

    public static String getLastPath() {
        return lastPath;
    }

    public static void setLastPath(String path) {
        lastPath = path;
    }

    public DataStoreParameters[] getParameters() {
        return null;
    }

    public void close() {
    }
}

