/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.tool.clip.ui.panel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import javax.swing.JPanel;
import org.gvsig.fmap.dal.coverage.store.RasterDataStore;
import org.gvsig.fmap.dal.coverage.store.parameter.RasterDataParameters;
import org.gvsig.fmap.dal.coverage.store.parameter.TileDataParameters;
import org.gvsig.gui.beans.table.TableContainer;
import org.gvsig.gui.beans.table.exceptions.NotInitializeException;
import org.gvsig.i18n.Messages;
import org.gvsig.raster.fmap.layers.FLyrRaster;
import org.gvsig.raster.swing.RasterSwingLibrary;

public class ClippingSelectionPanel
extends JPanel {
    private static final long serialVersionUID = 813234785743904477L;
    private TableContainer tableContainer = null;

    public ClippingSelectionPanel() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getTableContainer(), "Center");
    }

    public TableContainer getTableContainer() {
        if (this.tableContainer == null) {
            String[] columnNames = new String[]{Messages.getText((String)"bandas"), Messages.getText((String)"nombre"), ""};
            int[] columnWidths = new int[]{55, 305, 0};
            this.tableContainer = new TableContainer(columnNames, columnWidths);
            this.tableContainer.setModel("CheckBoxModel");
            this.tableContainer.initialize();
            this.tableContainer.setControlVisible(false);
            this.tableContainer.setMoveRowsButtonsVisible(true);
            this.tableContainer.getTable().getJTable().getColumnModel().getColumn(2).setMinWidth(0);
            this.tableContainer.getTable().getJTable().getColumnModel().getColumn(2).setMaxWidth(0);
            this.tableContainer.getTable().getJTable().getColumnModel().getColumn(0).setMinWidth(55);
            this.tableContainer.getTable().getJTable().getColumnModel().getColumn(0).setMaxWidth(55);
        }
        return this.tableContainer;
    }

    public void setLayer(FLyrRaster fLayer) {
        RasterDataStore dataStore = fLayer.getDataStore();
        int cont = 0;
        RasterDataParameters[] params = dataStore.getDataParametersByProvider();
        int[] nBands = dataStore.getBandCountByProvider();
        for (int i = 0; i < params.length; ++i) {
            String fName = null;
            if (params[i] instanceof RasterDataParameters) {
                fName = params[i].getURI().getPath();
            }
            if (params[i] == null && params[i] instanceof TileDataParameters && ((TileDataParameters)params[i]).getName() != null) {
                fName = ((TileDataParameters)params[i]).getName();
            }
            cont = this.loadBandsTable(nBands[i], fName, cont);
        }
    }

    private int loadBandsTable(int nBands, String fName, int cont) {
        String bandName = new File(fName).getName();
        if (nBands > 1) {
            for (int b = 0; b < nBands; ++b) {
                Object[] row = new Object[]{new Boolean(true), new String("B" + (b + 1) + " - " + bandName), new Integer(cont++)};
                try {
                    this.getTableContainer().addRow(row);
                    continue;
                }
                catch (NotInitializeException e) {
                    RasterSwingLibrary.messageBoxError((String)"error_rowtable", (Object)this, (Exception)((Object)e));
                }
            }
        } else {
            Object[] row = new Object[]{new Boolean(true), new String("B - " + bandName), new Integer(cont++)};
            try {
                this.getTableContainer().addRow(row);
            }
            catch (NotInitializeException e) {
                RasterSwingLibrary.messageBoxError((String)"error_rowtable", (Object)this, (Exception)((Object)e));
            }
        }
        return cont;
    }
}

