/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.tool.colortable;

import javax.swing.Icon;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.project.documents.view.toc.AbstractTocContextMenuAction;
import org.gvsig.app.project.documents.view.toc.ITocItem;
import org.gvsig.fmap.dal.coverage.exception.ColorTableException;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.i18n.Messages;
import org.gvsig.raster.fmap.layers.FLyrRaster;
import org.gvsig.raster.fmap.layers.ILayerState;
import org.gvsig.raster.fmap.layers.IRasterLayerActions;
import org.gvsig.raster.mainplugin.toolbar.IGenericToolBarMenuItem;
import org.gvsig.raster.swing.RasterSwingLibrary;
import org.gvsig.raster.tools.app.basic.tool.colortable.ui.ColorTableDialog;

public class ColorTableTocMenuEntry
extends AbstractTocContextMenuAction
implements IGenericToolBarMenuItem {
    private static ColorTableTocMenuEntry singleton = null;

    private ColorTableTocMenuEntry() {
    }

    public static ColorTableTocMenuEntry getSingleton() {
        if (singleton == null) {
            singleton = new ColorTableTocMenuEntry();
        }
        return singleton;
    }

    public String getGroup() {
        return "RasterLayer";
    }

    public int getGroupOrder() {
        return 10;
    }

    public int getOrder() {
        return 40;
    }

    public String getText() {
        return Messages.getText((String)"tablas_color");
    }

    public boolean isEnabled(ITocItem item, FLayer[] selectedItems) {
        if (selectedItems == null || selectedItems.length != 1) {
            return false;
        }
        if (!(selectedItems[0] instanceof FLyrRaster)) {
            return false;
        }
        return ((ILayerState)selectedItems[0]).isOpen();
    }

    public boolean isVisible(ITocItem item, FLayer[] selectedItems) {
        if (selectedItems == null || selectedItems.length != 1) {
            return false;
        }
        if (!(selectedItems[0] instanceof FLyrRaster)) {
            return false;
        }
        return ((FLyrRaster)selectedItems[0]).getDataStore() != null && ((FLyrRaster)selectedItems[0]).getDataStore().getBandCount() == 1 && ((IRasterLayerActions)selectedItems[0]).isActionEnabled(6);
    }

    public synchronized void execute(ITocItem item, FLayer[] selectedItems) {
        if (selectedItems[0] instanceof FLyrRaster) {
            ColorTableDialog colorTableDialog = null;
            try {
                colorTableDialog = new ColorTableDialog((FLyrRaster)selectedItems[0], 660, 465);
            }
            catch (ColorTableException e) {
                RasterSwingLibrary.messageBoxError((String)"colortables_not_loaded", (Object)PluginServices.getMDIManager().getActiveWindow(), (Exception)((Object)e));
                return;
            }
            PluginServices.getMDIManager().addCentredWindow((IWindow)colorTableDialog);
        }
    }

    public Icon getIcon() {
        return IconThemeHelper.getImageIcon((String)"layer-color-table");
    }
}

