/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.tool.enhanced.ui;

import java.util.ArrayList;
import java.util.List;
import org.gvsig.andami.PluginServices;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.datastruct.Params;
import org.gvsig.fmap.dal.coverage.exception.FilterManagerException;
import org.gvsig.fmap.dal.coverage.exception.FilterTypeException;
import org.gvsig.fmap.dal.coverage.grid.RasterFilter;
import org.gvsig.fmap.dal.coverage.grid.RasterFilterList;
import org.gvsig.fmap.dal.coverage.grid.RasterFilterListManager;
import org.gvsig.gui.beans.imagenavigator.ImageUnavailableException;
import org.gvsig.raster.fmap.layers.FLyrRaster;
import org.gvsig.raster.swing.RasterSwingLibrary;
import org.gvsig.raster.swing.preview.DataSourcePreview;
import org.gvsig.raster.swing.preview.PreviewRenderProcess;
import org.gvsig.raster.tools.app.basic.RasterToolsUtil;
import org.gvsig.raster.tools.app.basic.raster.bean.previewbase.ParamStruct;

public class PreviewFiltering
implements PreviewRenderProcess {
    private boolean showFiltersSelected = true;
    private List<ParamStruct> paramsList = new ArrayList<ParamStruct>();
    private List<RasterFilter> filtersInit = new ArrayList<RasterFilter>();
    private boolean showPreview = true;
    private boolean saveLayerFilters = true;

    public PreviewFiltering(boolean saveLayerFilters) {
        this.saveLayerFilters = saveLayerFilters;
    }

    public void showFiltersSelected(boolean show) {
        this.showFiltersSelected = show;
    }

    public List<ParamStruct> getParamsList() {
        return this.paramsList;
    }

    public void setParamsList(List<ParamStruct> params) {
        this.paramsList = params;
    }

    public void setFilterStatus(List<RasterFilter> filtersInit) {
        this.filtersInit = filtersInit;
    }

    public List<RasterFilter> getFilterStatus() {
        return this.filtersInit;
    }

    public void addNewParam(String name, Params params, Class<?> classFilter) {
        ParamStruct param = new ParamStruct();
        param.setFilterName(name);
        param.setFilterParam(params);
        param.setFilterClass(classFilter);
        this.paramsList.add(param);
    }

    public void process(DataSourcePreview rendering) throws ImageUnavailableException {
        if (!this.showPreview) {
            throw new ImageUnavailableException(RasterToolsUtil.getText(this, "panel_preview_not_available"));
        }
        if (!(rendering.getSource() instanceof FLyrRaster)) {
            return;
        }
        FLyrRaster lyr = (FLyrRaster)rendering.getSource();
        lyr.getRender().getFilterList().clear();
        if (this.showFiltersSelected) {
            RasterFilterList filterList = lyr.getRender().getFilterList();
            filterList.setInitDataType(lyr.getDataStore().getDataType()[0]);
            List<ParamStruct> listFilterUsed = null;
            listFilterUsed = this.saveLayerFilters ? this.applyAllFilters(lyr) : this.applySelectedFilters(null);
            ArrayList<Throwable> exc = new ArrayList<Throwable>();
            for (int i = 0; i < listFilterUsed.size(); ++i) {
                try {
                    RasterFilterListManager filterManager = filterList.getManagerByFilterClass(listFilterUsed.get(i).getFilterClass());
                    Class<?> c = listFilterUsed.get(i).getFilterClass();
                    Params p = listFilterUsed.get(i).getFilterParam();
                    filterManager.addFilter(c, p);
                    continue;
                }
                catch (FilterTypeException e) {
                    exc.add(e);
                    continue;
                }
                catch (FilterManagerException e) {
                    exc.add(e);
                }
            }
            if (exc.size() != 0) {
                RasterSwingLibrary.messageBoxError((String)PluginServices.getText((Object)this, (String)"error_adding_filters"), (Object)this, exc);
                exc.clear();
            }
        }
    }

    public List<ParamStruct> applyAllFilters(FLyrRaster layerRaster) {
        List<ParamStruct> listFilterUsed = new ArrayList<ParamStruct>();
        int initDataType = layerRaster.getRender().getFilterList().getInitDataType();
        RasterFilterList filterList = RasterLocator.getManager().createEmptyFilterList(initDataType);
        filterList.setEnv(layerRaster.getRender().getFilterList().getEnv());
        filterList.setInitDataType(initDataType);
        List registeredFilters = filterList.getRegisteredFilterList();
        if (this.filtersInit == null) {
            return listFilterUsed;
        }
        for (int i = 0; i < this.filtersInit.size(); ++i) {
            RasterFilter obj = null;
            for (int j = 0; j < registeredFilters.size(); ++j) {
                Class classFilter = (Class)registeredFilters.get(j);
                try {
                    obj = (RasterFilter)classFilter.newInstance();
                    if (!obj.getName().equals(this.filtersInit.get(i).getName())) continue;
                    break;
                }
                catch (InstantiationException e) {
                    RasterSwingLibrary.messageBoxError((String)"error_creando_filtro", (Object)this, (Exception)e);
                    continue;
                }
                catch (IllegalAccessException e) {
                    RasterSwingLibrary.messageBoxError((String)"error_creando_filtro", (Object)this, (Exception)e);
                }
            }
            if (obj == null) continue;
            try {
                Params params = (Params)this.filtersInit.get(i).getUIParams(this.filtersInit.get(i).getName()).clone();
                int[] renderBands = layerRaster.getRender().getRenderColorInterpretation().buildRenderBands();
                String rgb = renderBands[0] + " " + renderBands[1] + " " + renderBands[2];
                params.setParam("RenderBands", (Object)rgb, 0, null);
                ParamStruct newParam = new ParamStruct();
                newParam.setFilterClass(obj.getClass());
                newParam.setFilterName(this.filtersInit.get(i).getName());
                newParam.setFilterParam(params);
                listFilterUsed.add(newParam);
                continue;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
        }
        listFilterUsed = this.applySelectedFilters(listFilterUsed);
        return listFilterUsed;
    }

    public List<ParamStruct> applySelectedFilters(List<ParamStruct> listFilterUsed) {
        if (listFilterUsed == null) {
            return this.getParamStructListCopy();
        }
        for (int i = 0; i < this.paramsList.size(); ++i) {
            boolean finded = false;
            for (int j = 0; j < listFilterUsed.size(); ++j) {
                if (!listFilterUsed.get(j).getFilterName().equals(this.paramsList.get(i).getFilterName())) continue;
                listFilterUsed.set(j, this.paramsList.get(i));
                finded = true;
                break;
            }
            if (finded) continue;
            listFilterUsed.add(this.paramsList.get(i));
        }
        return listFilterUsed;
    }

    private List<ParamStruct> getParamStructListCopy() {
        ArrayList<ParamStruct> p = new ArrayList<ParamStruct>();
        for (int i = 0; i < this.paramsList.size(); ++i) {
            p.add(this.paramsList.get(i).clone());
        }
        return p;
    }

    public boolean isShowPreview() {
        return this.showPreview;
    }

    public void setShowPreview(boolean showPreview) {
        this.showPreview = showPreview;
    }
}

