/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.tool.geolocation;

import java.awt.Point;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.project.documents.view.gui.AbstractViewPanel;
import org.gvsig.app.project.documents.view.gui.IView;
import org.gvsig.app.project.documents.view.toc.AbstractTocContextMenuAction;
import org.gvsig.app.project.documents.view.toc.ITocItem;
import org.gvsig.app.project.documents.view.toolListeners.StatusBarListener;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.FLayers;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.fmap.mapcontrol.tools.Behavior.Behavior;
import org.gvsig.fmap.mapcontrol.tools.Behavior.MouseMovementBehavior;
import org.gvsig.fmap.mapcontrol.tools.Listeners.PanListener;
import org.gvsig.fmap.mapcontrol.tools.Listeners.PointListener;
import org.gvsig.raster.fmap.layers.FLyrRaster;
import org.gvsig.raster.fmap.layers.ILayerState;
import org.gvsig.raster.fmap.layers.IRasterLayerActions;
import org.gvsig.raster.mainplugin.toolbar.IGenericToolBarMenuItem;
import org.gvsig.raster.tools.app.basic.RasterToolsUtil;
import org.gvsig.raster.tools.app.basic.tool.geolocation.behavior.GeoRasterBehavior;
import org.gvsig.raster.tools.app.basic.tool.geolocation.listener.GeorefPanListener;
import org.gvsig.raster.tools.app.basic.tool.geolocation.ui.GeoLocationDialog;

public class GeoLocationTocMenuEntry
extends AbstractTocContextMenuAction
implements PropertyChangeListener,
IGenericToolBarMenuItem {
    private static GeoLocationTocMenuEntry singleton = null;
    private GeoRasterBehavior mb = null;

    private GeoLocationTocMenuEntry() {
    }

    public static GeoLocationTocMenuEntry getSingleton() {
        if (singleton == null) {
            singleton = new GeoLocationTocMenuEntry();
        }
        return singleton;
    }

    public String getGroup() {
        return "GeoRaster";
    }

    public int getGroupOrder() {
        return 10;
    }

    public int getOrder() {
        return 20;
    }

    public String getText() {
        return RasterToolsUtil.getText(this, "geolocation");
    }

    public boolean isEnabled(ITocItem item, FLayer[] selectedItems) {
        if (selectedItems == null || selectedItems.length != 1) {
            return false;
        }
        if (!(selectedItems[0] instanceof ILayerState)) {
            return false;
        }
        return ((ILayerState)selectedItems[0]).isOpen();
    }

    public boolean isVisible(ITocItem item, FLayer[] selectedItems) {
        if (selectedItems == null || selectedItems.length != 1) {
            return false;
        }
        if (!(selectedItems[0] instanceof IRasterLayerActions)) {
            return false;
        }
        return ((IRasterLayerActions)selectedItems[0]).isActionEnabled(15);
    }

    public void execute(ITocItem item, FLayer[] selectedItems) {
        FLayers lyrs;
        FLayer[] actives;
        boolean isOpen = false;
        AbstractViewPanel theView = (AbstractViewPanel)PluginServices.getMDIManager().getActiveWindow();
        MapControl mapCtrl = theView.getMapControl();
        StatusBarListener sbl = new StatusBarListener(mapCtrl);
        IWindow activeView = PluginServices.getMDIManager().getActiveWindow();
        if (activeView instanceof IView && ((actives = (lyrs = ((IView)activeView).getMapControl().getMapContext().getLayers()).getActives()) == null || actives.length == 0)) {
            return;
        }
        if (activeView instanceof GeoLocationDialog) {
            isOpen = true;
        }
        if (selectedItems == null || selectedItems.length != 1 || !(selectedItems[0] instanceof FLyrRaster)) {
            return;
        }
        FLyrRaster lyr = (FLyrRaster)selectedItems[0];
        GeoLocationDialog gld = new GeoLocationDialog(lyr, mapCtrl.getViewPort(), theView);
        if (!isOpen) {
            Point posit = RasterToolsUtil.iwindowPosition((int)gld.getSizeWindow().getWidth(), (int)gld.getSizeWindow().getHeight());
            gld.setPosition((int)posit.getX(), (int)posit.getY());
            RasterToolsUtil.addWindow(gld);
        }
        gld.init(mapCtrl);
        this.loadGeoPanListener(mapCtrl, sbl, gld, lyr);
        mapCtrl.setTool("geoPan");
    }

    private void loadGeoPanListener(MapControl mapCtrl, StatusBarListener sbl, GeoLocationDialog gld, FLyrRaster lyr) {
        if (mapCtrl.getNamesMapTools().get("geoPan") == null) {
            GeorefPanListener pl = new GeorefPanListener(mapCtrl);
            this.mb = new GeoRasterBehavior((PanListener)pl, gld, lyr);
            mapCtrl.addBehavior("geoPan", new Behavior[]{this.mb, new MouseMovementBehavior((PointListener)sbl)});
        }
        if (this.mb != null) {
            this.mb.setLayer(lyr);
            this.mb.setITransformIO(gld);
        }
    }

    public Icon getIcon() {
        return RasterToolsUtil.getIcon("layer-geolocalization");
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
    }

    public boolean isEnableEvents() {
        return true;
    }
}

