/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.tool.geolocation.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.KeyListener;
import java.awt.geom.AffineTransform;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.gvsig.andami.PluginServices;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.util.MathUtils;
import org.gvsig.fmap.mapcontext.ViewPort;
import org.gvsig.gui.beans.datainput.DataInputContainer;
import org.gvsig.gui.beans.datainput.DataInputContainerListener;
import org.gvsig.raster.fmap.layers.FLyrRaster;
import org.gvsig.raster.tools.app.basic.tool.geolocation.listener.GeoLocationPanelListener;
import org.gvsig.raster.tools.app.basic.tool.geolocation.ui.GeolocationBaseClassPanel;

public class GeoLocationOpeningRasterCornersPanel
extends GeolocationBaseClassPanel {
    private static final long serialVersionUID = -7797379892312214949L;
    private DataInputContainer ulx = null;
    private DataInputContainer uly = null;
    private DataInputContainer lrx = null;
    private DataInputContainer lry = null;
    private JPanel coordsULPanel = null;
    private JPanel coordsLRPanel = null;
    private String pathToImages = "images/";

    public GeoLocationOpeningRasterCornersPanel(GeoLocationPanelListener list) {
        this.listener = list;
        GridBagLayout gl = new GridBagLayout();
        this.setLayout(gl);
        this.setBorder(BorderFactory.createTitledBorder(null, PluginServices.getText((Object)this, (String)"geolocation"), 0, 0, null, null));
        this.ulx = new DataInputContainer();
        this.ulx.setLabelText(PluginServices.getText((Object)this, (String)"ux"));
        this.ulx.addValueChangedListener((DataInputContainerListener)this.listener);
        this.ulx.addKeyListener((KeyListener)this.listener);
        this.uly = new DataInputContainer();
        this.uly.setLabelText(PluginServices.getText((Object)this, (String)"uy"));
        this.uly.addValueChangedListener((DataInputContainerListener)this.listener);
        this.uly.addKeyListener((KeyListener)this.listener);
        this.lrx = new DataInputContainer();
        this.lrx.setLabelText(PluginServices.getText((Object)this, (String)"ux"));
        this.lrx.addValueChangedListener((DataInputContainerListener)this.listener);
        this.lrx.addKeyListener((KeyListener)this.listener);
        this.lry = new DataInputContainer();
        this.lry.setLabelText(PluginServices.getText((Object)this, (String)"uy"));
        this.lry.addValueChangedListener((DataInputContainerListener)this.listener);
        this.lry.addKeyListener((KeyListener)this.listener);
        GridLayout l = new GridLayout(2, 1);
        l.setVgap(2);
        this.coordsULPanel = new JPanel(l);
        this.coordsLRPanel = new JPanel(l);
        this.init();
    }

    private void init() {
        JPanel p1 = new JPanel(new BorderLayout());
        p1.add((Component)this.getIcoUL(), "West");
        p1.add((Component)this.ulx, "Center");
        JPanel p2 = new JPanel(new BorderLayout());
        p2.add((Component)this.getIcoUL(), "West");
        p2.add((Component)this.uly, "Center");
        this.coordsULPanel.add(p1);
        this.coordsULPanel.add(p2);
        JPanel p3 = new JPanel(new BorderLayout());
        p3.add((Component)this.getIcoLR(), "West");
        p3.add((Component)this.lrx, "Center");
        JPanel p4 = new JPanel(new BorderLayout());
        p4.add((Component)this.getIcoLR(), "West");
        p4.add((Component)this.lry, "Center");
        this.coordsLRPanel.add(p3);
        this.coordsLRPanel.add(p4);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(1, 1, 1, 1);
        this.add((Component)this.coordsULPanel, gbc);
        gbc.gridy = 1;
        this.add((Component)this.coordsLRPanel, gbc);
    }

    public void setParams(FLyrRaster lyr, ViewPort vp) {
        this.setLayer(lyr);
        this.setViewPort(vp);
        this.loadTransform(lyr.getAffineTransform());
    }

    private JLabel getIcoUL() {
        ImageIcon icon = null;
        try {
            icon = new ImageIcon(this.getClass().getResource(this.pathToImages + "upleft.png"));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (icon != null) {
            return new JLabel(icon);
        }
        return new JLabel("UL");
    }

    private JLabel getIcoLR() {
        ImageIcon icon = null;
        try {
            icon = new ImageIcon(this.getClass().getResource(this.pathToImages + "downright.png"));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (icon != null) {
            return new JLabel(icon);
        }
        return new JLabel("LR");
    }

    @Override
    public void loadTransform(AffineTransform at) {
        this.listener.setEnableValueChangeEvent(false);
        MathUtils math = RasterLocator.getManager().getMathUtils();
        this.setUlx(String.valueOf(math.format(at.getTranslateX(), this.tailValue)));
        this.setUly(String.valueOf(math.format(at.getTranslateY(), this.tailValue)));
        this.setLrx(String.valueOf(math.format(at.getTranslateX() + at.getScaleX() * this.getLayer().getDataStore().getWidth(), this.tailValue)));
        this.setLry(String.valueOf(math.format(at.getTranslateY() + at.getScaleY() * this.getLayer().getDataStore().getHeight(), this.tailValue)));
        this.listener.setEnableValueChangeEvent(true);
    }

    public void setUlx(String ulx) {
        this.ulx.setValue(ulx);
    }

    public void setUly(String uly) {
        this.uly.setValue(uly);
    }

    public void setLrx(String lrx) {
        this.lrx.setValue(lrx);
    }

    public void setLry(String lry) {
        this.lry.setValue(lry);
    }

    @Override
    public DataInputContainer getUlx() {
        return this.ulx;
    }

    @Override
    public DataInputContainer getUly() {
        return this.uly;
    }

    @Override
    public DataInputContainer getPsx() {
        DataInputContainer d = new DataInputContainer();
        try {
            double dUlx = Double.valueOf(this.ulx.getValue());
            double dLrx = Double.valueOf(this.lrx.getValue());
            d.setValue(String.valueOf((dLrx - dUlx) / this.getLayer().getDataStore().getWidth()));
        }
        catch (NumberFormatException e) {
            d.setValue("1");
        }
        return d;
    }

    @Override
    public DataInputContainer getPsy() {
        DataInputContainer d = new DataInputContainer();
        try {
            double dUly = Double.valueOf(this.uly.getValue());
            double dLry = Double.valueOf(this.lry.getValue());
            d.setValue(String.valueOf((dLry - dUly) / this.getLayer().getDataStore().getHeight()));
        }
        catch (NumberFormatException e) {
            d.setValue("1");
        }
        return d;
    }

    @Override
    public DataInputContainer getRotx() {
        DataInputContainer d = new DataInputContainer();
        d.setValue("0");
        return d;
    }

    @Override
    public DataInputContainer getRoty() {
        DataInputContainer d = new DataInputContainer();
        d.setValue("0");
        return d;
    }
}

