/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.tool.geolocation.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.geom.AffineTransform;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.gvsig.andami.PluginServices;
import org.gvsig.gui.beans.datainput.DataInputContainer;
import org.gvsig.raster.fmap.layers.FLyrRaster;
import org.gvsig.raster.tools.app.basic.tool.geolocation.listener.GeoLocationPanelListener;
import org.gvsig.raster.tools.app.basic.tool.geolocation.ui.GeoLocationOpeningRasterCornersPanel;
import org.gvsig.raster.tools.app.basic.tool.geolocation.ui.GeoLocationOpeningRasterDialog;
import org.gvsig.raster.tools.app.basic.tool.geolocation.ui.GeoLocationOpeningRasterTransfPanel;
import org.gvsig.raster.tools.app.basic.tool.geolocation.ui.GeolocationBaseClassPanel;

public class GeoLocationOpeningRasterPanel
extends GeolocationBaseClassPanel {
    private static final long serialVersionUID = -7797379892312214949L;
    private JButton apply = null;
    private JButton cancel = null;
    private JTabbedPane coordsPanel = null;
    private JPanel paramsPanel = null;
    private JPanel buttonsPanel = null;
    private GeoLocationOpeningRasterCornersPanel cornersPanel = null;
    private GeoLocationOpeningRasterTransfPanel transfPanel = null;
    private GeoLocationOpeningRasterDialog parent = null;

    public GeoLocationOpeningRasterPanel(GeoLocationOpeningRasterDialog parent) {
        this.parent = parent;
        this.listener = new GeoLocationPanelListener(this, null);
        this.transfPanel = new GeoLocationOpeningRasterTransfPanel(this.listener);
        this.cornersPanel = new GeoLocationOpeningRasterCornersPanel(this.listener);
        GridBagLayout gl = new GridBagLayout();
        this.setLayout(gl);
        this.apply = new JButton(PluginServices.getText((Object)this, (String)"apply"));
        this.apply.setPreferredSize(new Dimension(64, 24));
        this.apply.addActionListener(this.listener);
        this.cancel = new JButton(PluginServices.getText((Object)this, (String)"cancel"));
        this.cancel.setPreferredSize(new Dimension(64, 24));
        this.cancel.addActionListener(this.listener);
        this.getJTabbedPane();
        this.paramsPanel = new JPanel();
        GridLayout l1 = new GridLayout(2, 2);
        l1.setVgap(2);
        this.paramsPanel.setLayout(l1);
        this.getButtonsPanel();
        this.init();
    }

    public GeoLocationOpeningRasterDialog getDialog() {
        return this.parent;
    }

    private JTabbedPane getJTabbedPane() {
        if (this.coordsPanel == null) {
            this.coordsPanel = new JTabbedPane();
            this.coordsPanel.addTab(PluginServices.getText((Object)this, (String)"transf"), this.transfPanel);
            this.coordsPanel.addTab(PluginServices.getText((Object)this, (String)"corners"), this.cornersPanel);
        }
        return this.coordsPanel;
    }

    private void init() {
        JPanel applyButton = new JPanel();
        applyButton.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(1, 0, 0, 2);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 13;
        applyButton.add((Component)this.apply, gbc);
        gbc.gridx = 1;
        applyButton.add((Component)this.cancel, gbc);
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        this.buttonsPanel.add((Component)applyButton, gbc);
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(1, 1, 1, 1);
        this.add((Component)this.coordsPanel, gbc);
        gbc.gridy = 1;
        this.add((Component)this.paramsPanel, gbc);
        gbc.weightx = 1.0;
        gbc.gridy = 2;
        this.add((Component)this.buttonsPanel, gbc);
    }

    public JPanel getButtonsPanel() {
        if (this.buttonsPanel == null) {
            this.buttonsPanel = new JPanel();
            this.buttonsPanel.setLayout(new GridBagLayout());
        }
        return this.buttonsPanel;
    }

    public void setParams(FLyrRaster lyr) {
        this.setLayer(lyr);
        if (this.transfPanel != null) {
            this.transfPanel.setLayer(lyr);
        }
        if (this.cornersPanel != null) {
            this.cornersPanel.setLayer(lyr);
        }
        this.loadTransform(lyr.getDataStore().getAffineTransform());
    }

    @Override
    public void loadTransform(AffineTransform at) {
        this.transfPanel.loadTransform(at);
        this.cornersPanel.loadTransform(at);
    }

    @Override
    public JButton getApplyButton() {
        return this.apply;
    }

    @Override
    public JButton getCancelButton() {
        return this.cancel;
    }

    @Override
    public DataInputContainer getPsx() {
        if (this.coordsPanel.getSelectedComponent() == this.transfPanel) {
            return this.transfPanel.getPsx();
        }
        if (this.coordsPanel.getSelectedComponent() == this.cornersPanel) {
            return this.cornersPanel.getPsx();
        }
        return null;
    }

    @Override
    public DataInputContainer getPsy() {
        if (this.coordsPanel.getSelectedComponent() == this.transfPanel) {
            return this.transfPanel.getPsy();
        }
        if (this.coordsPanel.getSelectedComponent() == this.cornersPanel) {
            return this.cornersPanel.getPsy();
        }
        return null;
    }

    @Override
    public DataInputContainer getRotx() {
        if (this.coordsPanel.getSelectedComponent() == this.transfPanel) {
            return this.transfPanel.getRotx();
        }
        if (this.coordsPanel.getSelectedComponent() == this.cornersPanel) {
            return this.cornersPanel.getRotx();
        }
        return null;
    }

    @Override
    public DataInputContainer getRoty() {
        if (this.coordsPanel.getSelectedComponent() == this.transfPanel) {
            return this.transfPanel.getRoty();
        }
        if (this.coordsPanel.getSelectedComponent() == this.cornersPanel) {
            return this.cornersPanel.getRoty();
        }
        return null;
    }

    @Override
    public DataInputContainer getUlx() {
        if (this.coordsPanel.getSelectedComponent() == this.transfPanel) {
            return this.transfPanel.getUlx();
        }
        if (this.coordsPanel.getSelectedComponent() == this.cornersPanel) {
            return this.cornersPanel.getUlx();
        }
        return null;
    }

    @Override
    public DataInputContainer getUly() {
        if (this.coordsPanel.getSelectedComponent() == this.transfPanel) {
            return this.transfPanel.getUly();
        }
        if (this.coordsPanel.getSelectedComponent() == this.cornersPanel) {
            return this.cornersPanel.getUly();
        }
        return null;
    }
}

