/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.tool.histogram;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.table.DefaultTableModel;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.app.project.documents.Document;
import org.gvsig.app.project.documents.table.TableDocument;
import org.gvsig.app.project.documents.table.TableManager;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataServerExplorer;
import org.gvsig.fmap.dal.DataServerExplorerParameters;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.NewDataStoreParameters;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.datastruct.BufferHistogram;
import org.gvsig.fmap.dal.coverage.datastruct.HistogramClass;
import org.gvsig.fmap.dal.coverage.exception.HistogramException;
import org.gvsig.fmap.dal.coverage.exception.ProcessInterruptedException;
import org.gvsig.fmap.dal.coverage.exception.QueryException;
import org.gvsig.fmap.dal.coverage.store.props.HistogramComputer;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.exception.ValidateDataParametersException;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.EditableFeatureType;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.NewFeatureStoreParameters;
import org.gvsig.fmap.dal.serverexplorer.filesystem.FilesystemStoreParameters;
import org.gvsig.gui.beans.graphic.GraphicEvent;
import org.gvsig.gui.beans.graphic.GraphicListener;
import org.gvsig.raster.fmap.layers.FLyrRaster;
import org.gvsig.raster.swing.RasterSwingLibrary;
import org.gvsig.raster.tools.app.basic.RasterToolsUtil;
import org.gvsig.raster.tools.app.basic.raster.process.HistogramProcess;
import org.gvsig.raster.tools.app.basic.raster.process.IProcessActions;
import org.gvsig.raster.tools.app.basic.raster.process.StatisticsProcess;
import org.gvsig.raster.tools.app.basic.tool.histogram.ui.HistogramPanel;

public class HistogramPanelListener
implements GraphicListener,
ActionListener,
PropertyChangeListener,
IProcessActions {
    private HistogramPanel histogramPanel = null;
    private BufferHistogram lastHistogram = null;
    private BufferHistogram lastHistogramReal = null;
    private BufferHistogram lastHistogramRGB = null;
    public boolean eventsEnabled = false;
    private boolean[] showBands = null;
    private FLyrRaster lyr = null;
    private Color[] bandsColor = new Color[]{Color.red, Color.green, Color.blue, Color.cyan, Color.black, Color.darkGray, Color.gray, Color.magenta, Color.yellow, Color.orange};
    HistogramComputer histogramable = null;

    public HistogramPanelListener(HistogramPanel histogramPanel) {
        this.histogramPanel = histogramPanel;
    }

    private HistogramPanel getHistogramPanel() {
        return this.histogramPanel;
    }

    public void setLayer(FLyrRaster lyr) {
        this.lyr = lyr;
    }

    public void setControlListeners() {
        this.getHistogramPanel().getGraphicContainer().addValueChangedListener((GraphicListener)this);
    }

    private void updateStatistic() {
        if (this.getLastHistogram() == null) {
            this.getHistogramPanel().setStatistic(null);
            return;
        }
        double first = this.getHistogramPanel().getGraphicContainer().getX1();
        double end = this.getHistogramPanel().getGraphicContainer().getX2();
        this.getHistogramPanel().setStatistic(this.getLastHistogram().getBasicStats(first, end, this.showBands));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.eventsEnabled) {
            return;
        }
        if (e.getSource() == this.getHistogramPanel().getButtonClean()) {
            this.getHistogramPanel().refreshBands(false);
            for (int i = 0; i < this.showBands.length; ++i) {
                this.showBands[i] = false;
            }
            this.updateStatistic();
            this.updateGraphic();
            return;
        }
        if (e.getSource() == this.getHistogramPanel().getButtonShowAll()) {
            this.getHistogramPanel().refreshBands(true);
            for (int i = 0; i < this.showBands.length; ++i) {
                this.showBands[i] = true;
            }
            this.updateStatistic();
            this.updateGraphic();
            return;
        }
        JComboBox cbo = this.getHistogramPanel().getComboBoxSource();
        if (e.getSource() == cbo) {
            ArrayList comboSource = this.getHistogramPanel().getComboSource();
            for (int i = 0; i < comboSource.size(); ++i) {
                String name = (String)((ArrayList)comboSource.get(i)).get(1);
                if (cbo.getSelectedItem().equals(name) && name.compareTo(RasterToolsUtil.getText(this, "datos_visualizados")) == 0) {
                    ((ArrayList)comboSource.get(i)).remove(0);
                    try {
                        ((ArrayList)comboSource.get(i)).add(0, this.lyr.getRender().getLastRenderBuffer().getHistogramComputer());
                    }
                    catch (QueryException e1) {
                        RasterSwingLibrary.messageBoxError((String)"histogram_error", (Object)((Object)this.getHistogramPanel()), (Exception)((Object)e1));
                    }
                    catch (ProcessInterruptedException e1) {
                        // empty catch block
                    }
                }
                if (!cbo.getSelectedItem().equals(name) || name.compareTo(RasterToolsUtil.getText(this, "imagen_completa")) != 0) continue;
                ((ArrayList)comboSource.get(i)).remove(0);
                ((ArrayList)comboSource.get(i)).add(0, this.lyr.getDataStore().getHistogramComputer());
            }
            this.showHistogram();
            return;
        }
        if (e.getSource() == this.getHistogramPanel().getCheckBoxDeleteEdges()) {
            this.updateGraphic();
            return;
        }
        if (e.getSource() == this.getHistogramPanel().getCheckBoxRGB()) {
            this.selectHistogram();
            this.updateStatistic();
            this.updateGraphic();
            return;
        }
        JComboBox cbt = this.getHistogramPanel().getComboBoxType();
        if (e.getSource() == cbt) {
            this.getHistogramPanel().getGraphicContainer().getPGraphic().setViewType(this.getHistogramPanel().getComboBoxType().getSelectedIndex());
            return;
        }
        JButton table = this.getHistogramPanel().getBCreateTable();
        if (e.getSource() == table) {
            JFileChooser chooser = new JFileChooser();
            chooser.setDialogTitle(RasterToolsUtil.getText(this, "guardar_tabla"));
            int returnVal = chooser.showOpenDialog((Component)((Object)this.getHistogramPanel()));
            if (returnVal == 0) {
                String fName = chooser.getSelectedFile().toString();
                if (!fName.endsWith(".dbf")) {
                    fName = fName + ".dbf";
                }
                HistogramClass[][] histogram = this.getLastHistogram().getHistogram();
                int numBands = histogram.length;
                int numRecors = histogram[0].length;
                File file = new File(fName);
                String[] names = new String[numBands + 2];
                int[] types = new int[numBands + 2];
                int[] lengths = new int[numBands + 2];
                names[0] = "Min";
                types[0] = 7;
                lengths[0] = 15;
                names[1] = "Max";
                types[1] = 7;
                lengths[1] = 15;
                for (int band = 0; band < numBands; ++band) {
                    names[band + 2] = "Band" + band;
                    types[band + 2] = 7;
                    lengths[band + 2] = 15;
                }
                FeatureStore store = null;
                try {
                    DataManager manager = DALLocator.getDataManager();
                    DataServerExplorerParameters eparams = manager.createServerExplorerParameters("FilesystemExplorer");
                    eparams.setDynValue("initialpath", (Object)"/data");
                    DataServerExplorer serverExplorer = manager.openServerExplorer("FilesystemExplorer", eparams);
                    NewFeatureStoreParameters sparams = (NewFeatureStoreParameters)serverExplorer.getAddParameters("DBF");
                    ((FilesystemStoreParameters)sparams).setFile(file);
                    EditableFeatureType featureType = sparams.getDefaultFeatureType();
                    for (int i = 0; i < names.length; ++i) {
                        featureType.add(names[i], types[i], lengths[i]);
                    }
                    manager.newStore("FilesystemExplorer", "DBF", (NewDataStoreParameters)sparams, true);
                    store = (FeatureStore)manager.openStore(sparams.getDataStoreName(), (DataStoreParameters)sparams);
                    store.edit();
                    for (int j = 0; j < numRecors; ++j) {
                        EditableFeature feature = store.createNewFeature();
                        feature.set(names[0], (Object)histogram[0][j].getMin());
                        feature.set(names[1], (Object)histogram[0][j].getMax());
                        for (int r = 0; r < numBands; ++r) {
                            feature.set(names[r + 2], (Object)histogram[r][j].getValue());
                        }
                        store.insert(feature);
                    }
                    store.finishEditing();
                }
                catch (DataException e1) {
                    JOptionPane.showMessageDialog(null, this.getHistogramPanel().getName() + " " + RasterToolsUtil.getText(this, "table_not_create"));
                }
                catch (ValidateDataParametersException e2) {
                    JOptionPane.showMessageDialog(null, this.getHistogramPanel().getName() + " " + RasterToolsUtil.getText(this, "table_not_create"));
                }
                ApplicationManager application = ApplicationLocator.getManager();
                TableDocument tableDocument = (TableDocument)application.getProjectManager().createDocument(TableManager.TYPENAME, "Histogram_" + this.lyr.getName());
                tableDocument.setStore(store);
                application.getCurrentProject().add((Document)tableDocument);
                tableDocument.getFactory().getMainWindow((Document)tableDocument);
            }
        }
    }

    private void refreshBands() {
        this.getHistogramPanel().refreshBands(true);
        this.showBands = this.getLastHistogram() == null ? new boolean[0] : new boolean[this.getLastHistogram().getNumBands()];
        for (int i = 0; i < this.showBands.length; ++i) {
            this.showBands[i] = true;
        }
    }

    public void showHistogram() {
        if (this.getHistogramPanel().getComboBoxSource().getSelectedIndex() < 0) {
            return;
        }
        int dataSrc = this.getHistogramPanel().getComboBoxSource().getSelectedIndex();
        this.histogramable = (HistogramComputer)((ArrayList)this.getHistogramPanel().getComboSource().get(dataSrc)).get(0);
        if (this.getLastHistogram() == null) {
            try {
                if (this.histogramable != null) {
                    this.setNewHistogram(this.histogramable.getBufferHistogram());
                } else {
                    this.setNewHistogram(null);
                }
            }
            catch (HistogramException e) {
                RasterSwingLibrary.messageBoxError((String)"histogram_error", (Object)((Object)this.getHistogramPanel()), (Exception)((Object)e));
                return;
            }
            catch (ProcessInterruptedException e) {
                // empty catch block
            }
            return;
        }
        StatisticsProcess statisticsProcess = new StatisticsProcess();
        statisticsProcess.setActions(this);
        statisticsProcess.addParam("layer", this.lyr);
        statisticsProcess.addParam("force", Boolean.FALSE);
        statisticsProcess.start();
    }

    @Override
    public void end(Object object) {
        if (object instanceof BufferHistogram) {
            this.setNewHistogram((BufferHistogram)object);
            return;
        }
        if (object instanceof FLyrRaster) {
            if (this.histogramable != null) {
                HistogramProcess histogramProcess = new HistogramProcess();
                histogramProcess.setActions(this);
                histogramProcess.addParam("histogramable", this.histogramable);
                histogramProcess.start();
            } else {
                this.setNewHistogram(null);
            }
        }
    }

    private void updateGraphic() {
        if (this.getLastHistogram() == null) {
            this.getHistogramPanel().getGraphicContainer().getPGraphic().cleanChart();
            return;
        }
        HistogramClass[][] histogramClass = this.getLastHistogram().getHistogram();
        if (histogramClass == null) {
            return;
        }
        double[][][] datos = new double[histogramClass.length][histogramClass[0].length][2];
        for (int iBand = 0; iBand < histogramClass.length; ++iBand) {
            for (int i = 0; i < histogramClass[iBand].length; ++i) {
                datos[iBand][i][0] = histogramClass[iBand][i].getMin();
                datos[iBand][i][1] = histogramClass[iBand][i].getValue();
            }
        }
        int first = (int)this.getHistogramPanel().getBoxValueX1();
        int end = (int)this.getHistogramPanel().getBoxValueX2();
        int min = 0;
        int max = histogramClass[0].length - 1;
        first = min + first * (max - min) / 100;
        end = min + end * (max - min) / 100;
        if (this.getHistogramPanel().getCheckBoxDeleteEdges().isSelected()) {
            if (first + 1 <= end) {
                ++first;
            }
            if (end - 1 >= first) {
                --end;
            }
        }
        int bandCount = 0;
        for (int i = 0; i < this.showBands.length; ++i) {
            if (!this.showBands[i]) continue;
            ++bandCount;
        }
        double[][][] newHistogram = new double[bandCount][end - first + 1][2];
        String[] bandNames = new String[bandCount];
        int numBand = 0;
        for (int iBand = 0; iBand < this.showBands.length; ++iBand) {
            if (!this.showBands[iBand]) continue;
            for (int j = first; j <= end; ++j) {
                try {
                    newHistogram[numBand][j - first][0] = datos[iBand][j][0];
                    newHistogram[numBand][j - first][1] = datos[iBand][j][1];
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    RasterSwingLibrary.messageBoxError((String)("Error al crear el array del histograma. DataType: " + this.getHistogramPanel().getDataType() + " Posici\u00f3n: " + j), (Object)this, (Exception)e);
                }
            }
            bandNames[numBand] = (String)((DefaultTableModel)this.getHistogramPanel().getJTableBands().getModel()).getValueAt(iBand, 1);
            this.getHistogramPanel().getGraphicContainer().setBandColor(numBand, this.bandsColor[iBand % this.bandsColor.length]);
            ++numBand;
        }
        this.getHistogramPanel().getGraphicContainer().getPGraphic().setNewChart(newHistogram, bandNames);
    }

    public void selectHistogram() {
        this.lastHistogram = this.getHistogramPanel().getCheckBoxRGB().isSelected() ? this.lastHistogramRGB : this.lastHistogramReal;
    }

    public void setNewHistogram(BufferHistogram histogram) {
        this.getHistogramPanel().panelInizialited = false;
        this.eventsEnabled = false;
        this.lastHistogramReal = histogram;
        this.lastHistogramRGB = RasterLocator.getManager().getRasterUtils().convertHistogramToRGB(this.lastHistogramReal);
        this.selectHistogram();
        this.refreshBands();
        this.updateStatistic();
        this.updateGraphic();
        this.eventsEnabled = true;
        this.getHistogramPanel().panelInizialited = true;
    }

    public BufferHistogram getLastHistogram() {
        return this.lastHistogram;
    }

    public void actionValueChanged(GraphicEvent e) {
        this.updateStatistic();
        this.updateGraphic();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (!this.eventsEnabled) {
            return;
        }
        int countRow = ((DefaultTableModel)this.getHistogramPanel().getJTableBands().getModel()).getRowCount();
        for (int i = 0; i < countRow; ++i) {
            this.showBands[i] = (Boolean)((DefaultTableModel)this.getHistogramPanel().getJTableBands().getModel()).getValueAt(i, 0);
        }
        this.updateStatistic();
        this.updateGraphic();
    }

    @Override
    public void interrupted() {
    }
}

