/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.tool.histogram.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.andami.ui.mdiManager.WindowInfo;
import org.gvsig.gui.beans.buttonspanel.ButtonsPanelEvent;
import org.gvsig.gui.beans.buttonspanel.ButtonsPanelListener;
import org.gvsig.raster.fmap.layers.FLyrRaster;
import org.gvsig.raster.tools.app.basic.tool.histogram.ui.HistogramPanel;

public class HistogramDialog
extends JPanel
implements IWindow,
ButtonsPanelListener {
    private static final long serialVersionUID = 7362459094802955247L;
    private HistogramPanel histogramPanel = null;
    private String layerName = null;

    public HistogramDialog(int width, int height) {
        this.setSize(width, height);
        this.setLayout(new BorderLayout(5, 5));
        this.add((Component)((Object)this.getHistogramPanel()), "Center");
    }

    public void setLayer(FLyrRaster lyr) throws Exception {
        this.layerName = lyr.getName();
        this.getHistogramPanel().setDataType(lyr.getDataStore().getDataType()[0]);
        this.getHistogramPanel().setLayer(lyr);
    }

    public HistogramPanel getHistogramPanel() {
        if (this.histogramPanel == null) {
            this.histogramPanel = new HistogramPanel();
            this.histogramPanel.addButtonPressedListener(this);
        }
        return this.histogramPanel;
    }

    public WindowInfo getWindowInfo() {
        WindowInfo m_viewinfo = new WindowInfo(19);
        if (this.getLayerName() != null) {
            m_viewinfo.setAdditionalInfo(this.getLayerName());
        }
        m_viewinfo.setTitle(PluginServices.getText((Object)this, (String)"histograma"));
        m_viewinfo.setHeight(this.getHeight());
        m_viewinfo.setWidth(this.getWidth());
        return m_viewinfo;
    }

    private void close() {
        try {
            PluginServices.getMDIManager().closeWindow((IWindow)this);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void actionButtonPressed(ButtonsPanelEvent e) {
        if (e.getButton() == 6) {
            this.close();
        }
    }

    public String getLayerName() {
        return this.layerName;
    }

    public Object getWindowProfile() {
        return WindowInfo.PROPERTIES_PROFILE;
    }
}

