/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.tool.overview;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.PluginServices;
import org.gvsig.app.project.documents.view.toc.AbstractTocContextMenuAction;
import org.gvsig.app.project.documents.view.toc.ITocItem;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.exception.BandAccessException;
import org.gvsig.fmap.dal.coverage.exception.RasterDriverException;
import org.gvsig.fmap.mapcontext.exceptions.ReloadLayerException;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.FLyrDefault;
import org.gvsig.raster.fmap.layers.FLyrRaster;
import org.gvsig.raster.fmap.layers.ILayerState;
import org.gvsig.raster.fmap.layers.IRasterLayerActions;
import org.gvsig.raster.mainplugin.toolbar.IGenericToolBarMenuItem;
import org.gvsig.raster.swing.RasterSwingLibrary;
import org.gvsig.raster.tools.app.basic.raster.process.IProcessActions;
import org.gvsig.raster.tools.app.basic.raster.process.OverviewsProcess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OverviewsTocMenuEntry
extends AbstractTocContextMenuAction
implements PropertyChangeListener,
IGenericToolBarMenuItem,
IProcessActions {
    private Logger log = LoggerFactory.getLogger(OverviewsTocMenuEntry.class);
    private static OverviewsTocMenuEntry singleton = null;

    private OverviewsTocMenuEntry() {
    }

    public static OverviewsTocMenuEntry getSingleton() {
        if (singleton == null) {
            singleton = new OverviewsTocMenuEntry();
        }
        return singleton;
    }

    public String getGroup() {
        return "RasterLayer";
    }

    public int getGroupOrder() {
        return 10;
    }

    public int getOrder() {
        return 70;
    }

    public String getText() {
        return PluginServices.getText((Object)this, (String)"generar_overviews");
    }

    public boolean isEnabled(ITocItem item, FLayer[] selectedItems) {
        if (!RasterLocator.getManager().isOverviewBuilderSupported()) {
            return false;
        }
        if (selectedItems == null || selectedItems.length != 1) {
            return false;
        }
        if (!(selectedItems[0] instanceof FLyrRaster)) {
            return false;
        }
        if (!((ILayerState)selectedItems[0]).isOpen()) {
            return false;
        }
        if (!((FLyrRaster)selectedItems[0]).getDataStore().overviewsSupport()) {
            return false;
        }
        if (!((FLyrRaster)selectedItems[0]).getDataStore().overviewsSupport()) {
            return false;
        }
        return ((IRasterLayerActions)selectedItems[0]).isActionEnabled(16);
    }

    public boolean isVisible(ITocItem item, FLayer[] selectedItems) {
        if (!RasterLocator.getManager().isOverviewBuilderSupported()) {
            return false;
        }
        if (selectedItems == null || selectedItems.length != 1) {
            return false;
        }
        return selectedItems[0] instanceof FLyrRaster;
    }

    public void execute(ITocItem item, FLayer[] selectedItems) {
        FLayer lyr = selectedItems[0];
        if (lyr instanceof FLyrRaster && RasterSwingLibrary.messageBoxYesOrNot((String)"sobreescribir_datos_overview", (Object)this)) {
            try {
                if (((FLyrRaster)lyr).getDataStore().getOverviewCount(0) > 0 && !RasterSwingLibrary.messageBoxYesOrNot((String)"sobreescribir_overviews", (Object)this)) {
                    return;
                }
            }
            catch (BandAccessException e) {
                this.log.debug("Error accediendo a la banda en getOverViewCount", (Object)this, (Object)e);
            }
            catch (RasterDriverException e) {
                this.log.debug("Error en getOverViewCount", (Object)this, (Object)e);
            }
            OverviewsProcess process = new OverviewsProcess();
            process.addParam("layer", (FLyrRaster)lyr);
            process.setCancelable(false);
            process.setActions(this);
            process.start();
        }
    }

    public Icon getIcon() {
        return IconThemeHelper.getImageIcon((String)"layer-modify-overviews");
    }

    @Override
    public void end(Object param) {
        try {
            ((FLyrDefault)param).reload();
        }
        catch (ReloadLayerException reloadLayerException) {
            // empty catch block
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
    }

    @Override
    public void interrupted() {
    }

    public boolean isEnableEvents() {
        return true;
    }
}

