/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.tool.properties.control;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JRadioButton;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.project.documents.view.gui.AbstractViewPanel;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.datastruct.TransparencyRange;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.fmap.mapcontrol.tools.Behavior.Behavior;
import org.gvsig.fmap.mapcontrol.tools.Behavior.MouseMovementBehavior;
import org.gvsig.fmap.mapcontrol.tools.Behavior.PointBehavior;
import org.gvsig.fmap.mapcontrol.tools.Listeners.PointListener;
import org.gvsig.gui.beans.doubleslider.DoubleSliderEvent;
import org.gvsig.gui.beans.doubleslider.DoubleSliderListener;
import org.gvsig.raster.swing.RasterSwingLibrary;
import org.gvsig.raster.tools.app.basic.tool.properties.control.TranspByPixelStatusBarListener;
import org.gvsig.raster.tools.app.basic.tool.properties.panel.TranspByPixelPanel;
import org.gvsig.raster.tools.app.basic.tool.properties.panel.TranspByPixelRGBInputPanel;
import org.gvsig.raster.tools.app.basic.tool.selectrgb.ISelectRGB;
import org.gvsig.raster.tools.app.basic.tool.selectrgb.SelectRGBListener;

public class TranspByPixelListener
implements ActionListener,
ListSelectionListener,
DoubleSliderListener,
MouseListener,
ISelectRGB {
    private ArrayList<TransparencyRange> entries = new ArrayList();
    private JButton addButton = null;
    private JButton removeButton = null;
    private JButton selectColorButton = null;
    private JCheckBox cbActivar = null;
    private JList list = null;
    private JRadioButton andRb = null;
    private JRadioButton orRb = null;
    private TranspByPixelPanel panel = null;
    private TranspByPixelRGBInputPanel rgbInputPanel = null;
    private boolean eventsDisabled = false;
    private int itemSelected = -1;
    private String viewName = "";

    public TranspByPixelListener(TranspByPixelPanel panel) {
        AbstractViewPanel view = (AbstractViewPanel)PluginServices.getMDIManager().getActiveWindow();
        this.viewName = PluginServices.getMDIManager().getWindowInfo((IWindow)view).getTitle();
        this.panel = panel;
        this.rgbInputPanel = panel.getPRGBInput();
        this.list = panel.getJList();
        this.addButton = panel.getBAdd();
        this.removeButton = panel.getBRemove();
        this.selectColorButton = panel.getBSelectColor();
        this.andRb = panel.getPOperation().getRbAnd();
        this.orRb = panel.getPOperation().getRbOr();
        this.cbActivar = panel.getActiveCheck();
        this.addButton.addActionListener(this);
        this.removeButton.addActionListener(this);
        this.andRb.addActionListener(this);
        this.orRb.addActionListener(this);
        this.cbActivar.addActionListener(this);
        this.selectColorButton.addActionListener(this);
        this.list.addListSelectionListener(this);
        panel.getPRGBInput().getTBlue().addValueChangedListener((DoubleSliderListener)this);
        panel.getPRGBInput().getTGreen().addValueChangedListener((DoubleSliderListener)this);
        panel.getPRGBInput().getTRed().addValueChangedListener((DoubleSliderListener)this);
        panel.getPRGBInput().getTAlpha().addValueChangedListener((DoubleSliderListener)this);
        this.list.addMouseListener(this);
    }

    private TransparencyRange getEntrySelected() {
        TransparencyRange entry = RasterLocator.getManager().getDataStructFactory().createTransparencyRange();
        entry.setRed(this.rgbInputPanel.getRangeRed());
        entry.setGreen(this.rgbInputPanel.getRangeGreen());
        entry.setBlue(this.rgbInputPanel.getRangeBlue());
        if (this.rgbInputPanel.getTAlpha().isChecked()) {
            entry.setAlpha(255 - this.rgbInputPanel.getTAlpha().getValue());
        } else {
            entry.setAlpha(0);
        }
        String textR = this.rgbInputPanel.getTRed().getValue() + "";
        if (!this.rgbInputPanel.getTRed().isChecked()) {
            textR = "*";
        }
        String textG = this.rgbInputPanel.getTGreen().getValue() + "";
        if (!this.rgbInputPanel.getTGreen().isChecked()) {
            textG = "*";
        }
        String textB = this.rgbInputPanel.getTBlue().getValue() + "";
        if (!this.rgbInputPanel.getTBlue().isChecked()) {
            textB = "*";
        }
        String strEntry = "";
        String separator = "";
        if (this.andRb.isSelected()) {
            separator = " & ";
            entry.setAnd(true);
        } else {
            separator = " | ";
            entry.setAnd(false);
        }
        strEntry = textR + separator + textG + separator + textB;
        if (this.rgbInputPanel.getTAlpha().getValue() != 255) {
            strEntry = strEntry + " (A: " + this.rgbInputPanel.getTAlpha().getValue() + ")";
        }
        entry.setStrEntry(strEntry);
        return entry;
    }

    public void colorToolButton() {
        AbstractViewPanel theView = null;
        try {
            IWindow[] allViews = PluginServices.getMDIManager().getAllWindows();
            for (int i = 0; i < allViews.length; ++i) {
                if (!(allViews[i] instanceof AbstractViewPanel) || !PluginServices.getMDIManager().getWindowInfo((IWindow)((AbstractViewPanel)allViews[i])).getTitle().equals(this.viewName)) continue;
                theView = (AbstractViewPanel)allViews[i];
            }
            if (theView == null) {
                return;
            }
        }
        catch (ClassCastException ex) {
            RasterSwingLibrary.messageBoxError((String)"error_view_not_found", (Object)this, (Exception)ex);
            return;
        }
        MapControl m_MapControl = theView.getMapControl();
        TranspByPixelStatusBarListener sbl = new TranspByPixelStatusBarListener(m_MapControl);
        SelectRGBListener selectRGBListener = new SelectRGBListener(m_MapControl, this);
        m_MapControl.addBehavior("selectColorRaster", new Behavior[]{new PointBehavior((PointListener)selectRGBListener), new MouseMovementBehavior((PointListener)sbl)});
        m_MapControl.setTool("selectColorRaster");
    }

    private void updateData() {
        if (this.itemSelected == -1) {
            return;
        }
        TransparencyRange entry = this.getEntrySelected();
        if (entry != null && this.itemSelected < this.entries.size()) {
            this.entries.set(this.itemSelected, entry);
            this.panel.getListModel().set(this.itemSelected, entry.getStrEntry());
            this.panel.callValueChanged();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.andRb || e.getSource() == this.orRb) {
            this.updateData();
            return;
        }
        if (e.getSource() == this.addButton) {
            TransparencyRange entry = this.getEntrySelected();
            if (entry != null) {
                this.entries.add(entry);
                this.itemSelected = this.entries.size() - 1;
                this.panel.getListModel().addElement(entry.getStrEntry());
                this.setValues(this.itemSelected);
                this.removeButton.setEnabled(true);
                this.panel.callValueChanged();
            }
            return;
        }
        if (e.getSource() == this.removeButton) {
            this.deleteSelected();
            return;
        }
        if (e.getSource() == this.selectColorButton) {
            this.colorToolButton();
            return;
        }
        if (e.getSource() == this.cbActivar) {
            this.panel.setControlEnabled(this.cbActivar.isSelected());
            this.panel.callValueChanged();
            return;
        }
    }

    private void deleteSelected() {
        if (this.itemSelected == -1) {
            return;
        }
        this.entries.remove(this.itemSelected);
        this.panel.getListModel().remove(this.itemSelected);
        if (this.itemSelected >= this.entries.size()) {
            this.itemSelected = this.entries.size() - 1;
        }
        this.setValues(this.itemSelected);
        if (this.entries.size() == 0) {
            this.removeButton.setEnabled(false);
        }
        this.panel.callValueChanged();
    }

    private void setValues(int item) {
        if (item >= this.entries.size()) {
            item = this.entries.size() - 1;
        }
        if (this.entries.size() == 0) {
            this.rgbInputPanel.getTRed().setValue(0);
            this.rgbInputPanel.getTRed().setChecked(true);
            this.rgbInputPanel.getTGreen().setValue(0);
            this.rgbInputPanel.getTGreen().setChecked(true);
            this.rgbInputPanel.getTBlue().setValue(0);
            this.rgbInputPanel.getTBlue().setChecked(true);
            this.rgbInputPanel.getTAlpha().setValue(255);
            this.rgbInputPanel.getTAlpha().setChecked(false);
            this.andRb.setSelected(true);
            this.orRb.setSelected(false);
            return;
        }
        TransparencyRange tr = this.entries.get(item);
        this.andRb.setSelected(tr.isAnd());
        this.orRb.setSelected(!tr.isAnd());
        if (tr.getRed() == null) {
            this.rgbInputPanel.getTRed().setValue(0);
            this.rgbInputPanel.getTRed().setChecked(false);
        } else {
            this.rgbInputPanel.getTRed().setValue(tr.getRed()[0]);
            this.rgbInputPanel.getTRed().setChecked(true);
        }
        if (tr.getGreen() == null) {
            this.rgbInputPanel.getTGreen().setValue(0);
            this.rgbInputPanel.getTGreen().setChecked(false);
        } else {
            this.rgbInputPanel.getTGreen().setValue(tr.getGreen()[0]);
            this.rgbInputPanel.getTGreen().setChecked(true);
        }
        if (tr.getBlue() == null) {
            this.rgbInputPanel.getTBlue().setValue(0);
            this.rgbInputPanel.getTBlue().setChecked(false);
        } else {
            this.rgbInputPanel.getTBlue().setValue(tr.getBlue()[0]);
            this.rgbInputPanel.getTBlue().setChecked(true);
        }
        int alpha = 255 - tr.getAlpha();
        this.rgbInputPanel.getTAlpha().setValue(alpha);
        this.rgbInputPanel.getTAlpha().setChecked(alpha != 255);
        if (this.list.getSelectedIndex() != item) {
            this.list.setSelectedIndex(item);
        }
    }

    public ArrayList<TransparencyRange> getEntries() {
        return this.entries;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.eventsDisabled = true;
        if (this.list.getSelectedIndex() != -1) {
            this.itemSelected = this.list.getSelectedIndex();
        }
        this.setValues(this.itemSelected);
        this.eventsDisabled = false;
    }

    public void actionValueChanged(DoubleSliderEvent e) {
        if (this.eventsDisabled) {
            return;
        }
        this.eventsDisabled = true;
        this.updateData();
        this.eventsDisabled = false;
    }

    public void setEventsDisabled(boolean value) {
        this.eventsDisabled = value;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getSource() == this.list && e.getClickCount() == 2) {
            this.deleteSelected();
        }
    }

    @Override
    public void actionRGBSelected(int r, int g, int b) {
        this.rgbInputPanel.getTRed().setValue(r);
        this.rgbInputPanel.getTGreen().setValue(g);
        this.rgbInputPanel.getTBlue().setValue(b);
    }

    public void actionValueDragged(DoubleSliderEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }
}

