/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.tool.properties.panel;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;
import org.gvsig.andami.PluginServices;
import org.gvsig.fmap.dal.coverage.store.props.Statistics;
import org.gvsig.gui.beans.panelGroup.panels.AbstractPanel;
import org.gvsig.i18n.Messages;
import org.gvsig.raster.fmap.layers.FLyrRaster;
import org.gvsig.raster.fmap.layers.IRasterLayerActions;
import org.gvsig.raster.mainplugin.properties.RasterPropertiesTocMenuEntry;
import org.gvsig.raster.tools.app.basic.RasterToolsUtil;
import org.gvsig.raster.tools.app.basic.raster.process.IProcessActions;
import org.gvsig.raster.tools.app.basic.raster.process.StatisticsProcess;
import org.gvsig.raster.tools.app.basic.tool.properties.panel.NoDataPanel;

public class GeneralPanel
extends AbstractPanel
implements ActionListener,
IProcessActions {
    private static final long serialVersionUID = -4761218260868307869L;
    private FLyrRaster fLayer = null;
    private JLabel labelNotShowLayer = null;
    private JLabel labelMinim = null;
    private JLabel labelMaxim = null;
    private JCheckBox checkBoxMinim = null;
    private JCheckBox checkBoxMaxim = null;
    private JFormattedTextField textFieldMinim = null;
    private JFormattedTextField textFieldMaxim = null;
    private NumberFormat doubleDisplayFormat = null;
    private NumberFormat doubleEditFormat = null;
    private double initMaxScale = -1.0;
    private double initMinScale = -1.0;
    private JButton calcButton = null;
    private JPanel scalePanel = null;
    private JPanel recalcStatsPanel = null;
    private NoDataPanel pNoDataPanel = null;
    private JScrollPane jScrollPane = null;
    private JEditorPane jEditorPane = null;
    private final String bgColor0 = "\"#FEEDD6\"";
    private final String bgColor1 = "\"#EAEAEA\"";
    private final String bgColor3 = "\"#FBFFE1\"";
    private final String bgColor4 = "\"#D6D6D6\"";
    private boolean rowColor = true;

    public GeneralPanel() {
        this.setUpFormats();
        this.initialize();
        this.translate();
    }

    private void setUpFormats() {
        this.doubleDisplayFormat = NumberFormat.getNumberInstance();
        this.doubleDisplayFormat.setMinimumFractionDigits(0);
        this.doubleEditFormat = NumberFormat.getNumberInstance();
    }

    private void translate() {
        this.getJLabelNotShowLayer().setText(PluginServices.getText((Object)this, (String)"no_mostrar_la_capa_cuando_la_escala_sea") + ":");
        this.getJLabelMinim().setText("(" + PluginServices.getText((Object)this, (String)"escala_maxima") + ")");
        this.getJLabelMaxim().setText("(" + PluginServices.getText((Object)this, (String)"escala_minima") + ")");
        this.getJCheckBoxMinim().setText(PluginServices.getText((Object)this, (String)"mayor_de") + " 1:");
        this.getJCheckBoxMaxim().setText(PluginServices.getText((Object)this, (String)"menor_de") + " 1:");
        this.getScalePanel().setBorder(BorderFactory.createTitledBorder(PluginServices.getText((Object)this, (String)"rango_de_escalas")));
        this.getRecalcStatsPanel().setBorder(BorderFactory.createTitledBorder(PluginServices.getText((Object)this, (String)"stats")));
        this.setLabel(PluginServices.getText((Object)this, (String)"general"));
    }

    protected void initialize() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add(this.getScalePanel(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.add((Component)((Object)this.getNoDataPanel()), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.add(this.getRecalcStatsPanel(), gridBagConstraints);
        this.setPreferredSize(new Dimension(100, 80));
        this.setPriority(90);
    }

    private void actionEnabled() {
        IRasterLayerActions actions = null;
        if (this.fLayer instanceof IRasterLayerActions) {
            actions = (IRasterLayerActions)this.fLayer;
        }
        if (!actions.isActionEnabled(21)) {
            this.getRecalcStatsPanel().setVisible(false);
        }
        if (!actions.isActionEnabled(22)) {
            this.getNoDataPanel().setVisible(false);
        }
    }

    public NoDataPanel getNoDataPanel() {
        if (this.pNoDataPanel == null) {
            this.pNoDataPanel = new NoDataPanel();
            this.pNoDataPanel.setBorder(BorderFactory.createTitledBorder(null, PluginServices.getText((Object)this, (String)"nodata"), 0, 0, null, null));
        }
        return this.pNoDataPanel;
    }

    public JPanel getScalePanel() {
        if (this.scalePanel == null) {
            this.scalePanel = new JPanel();
            this.scalePanel.setLayout(new GridBagLayout());
            int y = 0;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = y++;
            gridBagConstraints.gridwidth = 3;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(2, 2, 2, 2);
            this.scalePanel.add((Component)this.getJLabelNotShowLayer(), gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = y;
            gridBagConstraints.insets = new Insets(2, 2, 2, 0);
            gridBagConstraints.anchor = 17;
            this.scalePanel.add((Component)this.getJCheckBoxMinim(), gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = y;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(2, 0, 2, 2);
            this.scalePanel.add((Component)this.getJTextFieldMinim(), gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = y++;
            gridBagConstraints.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints.anchor = 17;
            this.scalePanel.add((Component)this.getJLabelMinim(), gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = y;
            gridBagConstraints.insets = new Insets(2, 2, 2, 0);
            gridBagConstraints.anchor = 17;
            this.scalePanel.add((Component)this.getJCheckBoxMaxim(), gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = y;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(2, 0, 2, 2);
            this.scalePanel.add((Component)this.getJTextFieldMaxim(), gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = y++;
            gridBagConstraints.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints.anchor = 17;
            this.scalePanel.add((Component)this.getJLabelMaxim(), gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = y;
            gridBagConstraints.gridwidth = 3;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            JPanel emptyPanel = new JPanel();
            emptyPanel.setMinimumSize(new Dimension(0, 0));
            this.scalePanel.add((Component)emptyPanel, gridBagConstraints);
        }
        return this.scalePanel;
    }

    public JPanel getRecalcStatsPanel() {
        if (this.recalcStatsPanel == null) {
            this.recalcStatsPanel = new JPanel();
            this.recalcStatsPanel.setLayout(new BorderLayout(5, 5));
            this.recalcStatsPanel.add((Component)this.getJScrollPane(), "Center");
            this.recalcStatsPanel.add((Component)this.getCalcStatsButton(), "South");
        }
        return this.recalcStatsPanel;
    }

    public JButton getCalcStatsButton() {
        if (this.calcButton == null) {
            this.calcButton = new JButton(RasterToolsUtil.getText(this, "recalc_stats"));
            this.calcButton.addActionListener(this);
        }
        return this.calcButton;
    }

    private JLabel getJLabelNotShowLayer() {
        if (this.labelNotShowLayer == null) {
            this.labelNotShowLayer = new JLabel();
        }
        return this.labelNotShowLayer;
    }

    private JFormattedTextField getJTextFieldMinim() {
        if (this.textFieldMinim == null) {
            this.textFieldMinim = new JFormattedTextField(new DefaultFormatterFactory(new NumberFormatter(this.doubleDisplayFormat), new NumberFormatter(this.doubleDisplayFormat), new NumberFormatter(this.doubleEditFormat)));
            this.textFieldMinim.setEnabled(false);
            this.textFieldMinim.setBackground(this.getBackground());
        }
        return this.textFieldMinim;
    }

    private JFormattedTextField getJTextFieldMaxim() {
        if (this.textFieldMaxim == null) {
            this.textFieldMaxim = new JFormattedTextField(new DefaultFormatterFactory(new NumberFormatter(this.doubleDisplayFormat), new NumberFormatter(this.doubleDisplayFormat), new NumberFormatter(this.doubleEditFormat)));
            this.textFieldMaxim.setEnabled(false);
            this.textFieldMaxim.setBackground(this.getBackground());
        }
        return this.textFieldMaxim;
    }

    private JCheckBox getJCheckBoxMinim() {
        if (this.checkBoxMinim == null) {
            this.checkBoxMinim = new JCheckBox();
            this.checkBoxMinim.addActionListener(this);
            this.checkBoxMinim.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.checkBoxMinim.setMargin(new Insets(0, 0, 0, 0));
        }
        return this.checkBoxMinim;
    }

    private JLabel getJLabelMinim() {
        if (this.labelMinim == null) {
            this.labelMinim = new JLabel();
            this.labelMinim.setEnabled(false);
        }
        return this.labelMinim;
    }

    private JCheckBox getJCheckBoxMaxim() {
        if (this.checkBoxMaxim == null) {
            this.checkBoxMaxim = new JCheckBox();
            this.checkBoxMaxim.addActionListener(this);
            this.checkBoxMaxim.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.checkBoxMaxim.setMargin(new Insets(0, 0, 0, 0));
        }
        return this.checkBoxMaxim;
    }

    private JLabel getJLabelMaxim() {
        if (this.labelMaxim == null) {
            this.labelMaxim = new JLabel();
            this.labelMaxim.setEnabled(false);
        }
        return this.labelMaxim;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        boolean enabled;
        if (e.getSource() == this.getJCheckBoxMinim()) {
            enabled = this.getJCheckBoxMinim().isSelected();
            this.getJLabelMinim().setEnabled(enabled);
            this.getJTextFieldMinim().setEnabled(enabled);
            this.getJTextFieldMinim().setBackground(enabled ? Color.white : this.getBackground());
        }
        if (e.getSource() == this.getCalcStatsButton()) {
            StatisticsProcess process = new StatisticsProcess();
            process.addParam("layer", this.fLayer);
            process.addParam("force", new Boolean(true));
            process.setActions(this);
            process.start();
        }
        if (e.getSource() == this.getJCheckBoxMaxim()) {
            enabled = this.getJCheckBoxMaxim().isSelected();
            this.getJLabelMaxim().setEnabled(enabled);
            this.getJTextFieldMaxim().setEnabled(enabled);
            this.getJTextFieldMaxim().setBackground(enabled ? Color.white : this.getBackground());
        }
    }

    private String getColor() {
        String color = this.rowColor ? "\"#FEEDD6\"" : "\"#EAEAEA\"";
        this.rowColor = !this.rowColor;
        return color;
    }

    private String setHTMLBasicProperty(String prop, String value) {
        String content = "<tr valign=\"top\">";
        if (prop != null) {
            content = content + "<td bgcolor=\"#D6D6D6\"align=\"right\" width=\"140\"><font face=\"Arial\" size=\"3\">" + prop + ":&nbsp;</font></td>";
        }
        content = content + "<td bgcolor=" + this.getColor() + "align=\"left\"><font face=\"Arial\" size=\"3\">" + value + "</font></td>";
        content = content + "</tr>";
        return content;
    }

    private String setHTMLTitleTable(String title, int colspan) {
        return "<tr valign=\"middle\" ><td bgcolor=\"#FBFFE1\" align=\"center\" colspan=\"" + colspan + "\"><font face=\"Arial\" size=\"3\"><b> " + title + "</b></font></td>" + "</tr>";
    }

    private String setHTMLTable(String content) {
        return "<table cellpadding=\"0\" cellspacing=\"0\" align=\"center\" width=\"100%\">" + content + "</table>";
    }

    public void setReference(Object ref) {
        super.setReference(ref);
        if (!(ref instanceof FLyrRaster)) {
            return;
        }
        this.fLayer = (FLyrRaster)ref;
        this.actionEnabled();
        this.getNoDataPanel().setLayer(this.fLayer);
        if (this.fLayer.getMaxScale() != -1.0) {
            this.initMaxScale = this.fLayer.getMaxScale();
            this.getJTextFieldMaxim().setValue(this.fLayer.getMaxScale());
            this.getJCheckBoxMaxim().setSelected(true);
            this.getJLabelMaxim().setEnabled(true);
            this.getJTextFieldMaxim().setEnabled(true);
            this.getJTextFieldMaxim().setBackground(Color.WHITE);
        }
        if (this.fLayer.getMinScale() != -1.0) {
            this.initMinScale = this.fLayer.getMinScale();
            this.getJTextFieldMinim().setValue(this.fLayer.getMinScale());
            this.getJCheckBoxMinim().setSelected(true);
            this.getJLabelMinim().setEnabled(true);
            this.getJTextFieldMinim().setEnabled(true);
            this.getJTextFieldMinim().setBackground(Color.WHITE);
        }
        this.refreshHTMLStatistics();
        this.setValuesFromPanelToTransparency();
    }

    private void refreshHTMLStatistics() {
        String html = "";
        Statistics statistics = null;
        statistics = this.fLayer.getDataStore().getStatistics();
        if (statistics == null) {
            return;
        }
        if (statistics.isCalculated()) {
            double[] maxRGB = statistics.getMaxByteUnsigned();
            double[] max = statistics.getMax();
            double[] minRGB = statistics.getMinByteUnsigned();
            double[] min = statistics.getMin();
            double[] variance = statistics.getVariance();
            double[] mean = statistics.getMean();
            if (max != null) {
                for (int i = 0; i < max.length; ++i) {
                    html = html + this.setHTMLTitleTable(Messages.getText((String)"band") + " " + (i + 1), 2);
                    html = html + this.setHTMLBasicProperty(Messages.getText((String)"minimo"), Double.valueOf(min[i]).toString());
                    html = html + this.setHTMLBasicProperty(Messages.getText((String)"maximo"), Double.valueOf(max[i]).toString());
                    html = html + this.setHTMLBasicProperty(Messages.getText((String)"minimoRGB"), Double.valueOf(minRGB[i]).toString());
                    html = html + this.setHTMLBasicProperty(Messages.getText((String)"maximoRGB"), Double.valueOf(maxRGB[i]).toString());
                    html = html + this.setHTMLBasicProperty(Messages.getText((String)"media"), Double.valueOf(mean[i]).toString());
                    html = html + this.setHTMLBasicProperty(Messages.getText((String)"varianza"), Double.valueOf(variance[i]).toString());
                }
            }
            html = this.setHTMLTable(html);
        } else {
            html = html + this.setHTMLTitleTable(Messages.getText((String)"no_statistics_computed"), 2);
            html = this.setHTMLTable(html);
        }
        this.getJEditorStatsPanel().setText(html);
        this.getJEditorStatsPanel().setCaretPosition(0);
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getJEditorStatsPanel());
        }
        return this.jScrollPane;
    }

    private JEditorPane getJEditorStatsPanel() {
        if (this.jEditorPane == null) {
            this.jEditorPane = new JEditorPane();
            this.jEditorPane.setEditable(false);
            this.jEditorPane.setContentType("text/html");
        }
        return this.jEditorPane;
    }

    public void accept() {
        this.onlyApply();
    }

    private void setValuesFromPanelToTransparency() {
        if (this.fLayer == null || this.fLayer.getDataStore() == null) {
            return;
        }
        this.fLayer.setNoDataTransparent(this.getNoDataPanel().getCheckBoxNoDataEnabled().isSelected());
        this.fLayer.getMapContext().invalidate();
    }

    public void onlyApply() {
        if (RasterPropertiesTocMenuEntry.enableEvents) {
            this.setValuesFromPanelToTransparency();
        }
        if (this.fLayer == null) {
            return;
        }
        double maxScale = -1.0;
        double minScale = -1.0;
        if (this.getJCheckBoxMaxim().isSelected() && this.getJTextFieldMaxim().getValue() != null) {
            maxScale = ((Number)this.getJTextFieldMaxim().getValue()).doubleValue();
        }
        if (this.getJCheckBoxMinim().isSelected() && this.getJTextFieldMinim().getValue() != null) {
            minScale = ((Number)this.getJTextFieldMinim().getValue()).doubleValue();
        }
        this.fLayer.setMaxScale(maxScale);
        this.fLayer.setMinScale(minScale);
    }

    public void apply() {
        this.onlyApply();
    }

    public void restoreStatus() {
        this.fLayer.setMaxScale(this.initMaxScale);
        this.fLayer.setMinScale(this.initMinScale);
    }

    public void cancel() {
        this.restoreStatus();
    }

    @Override
    public void end(Object param) {
        this.refreshHTMLStatistics();
    }

    public void selected() {
    }

    @Override
    public void interrupted() {
    }
}

