/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.tool.properties.panel;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.EventObject;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.gvsig.andami.PluginServices;
import org.gvsig.fmap.dal.coverage.datastruct.TransparencyRange;
import org.gvsig.raster.tools.app.basic.RasterToolsUtil;
import org.gvsig.raster.tools.app.basic.tool.properties.control.TranspByPixelEventListener;
import org.gvsig.raster.tools.app.basic.tool.properties.control.TranspByPixelListener;
import org.gvsig.raster.tools.app.basic.tool.properties.panel.TranspByPixelAndOrSelectorPanel;
import org.gvsig.raster.tools.app.basic.tool.properties.panel.TranspByPixelRGBInputPanel;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;

public class TranspByPixelPanel
extends JPanel {
    private static final long serialVersionUID = -1131297200332579683L;
    private boolean controlEnabled = false;
    private JCheckBox activeCheck = null;
    private JList jList = null;
    private JPanel pixelSelector = null;
    private JPanel activeControl = null;
    private JPanel pEast = null;
    private JPanel pCenter = null;
    private JPanel pButtons = null;
    private JButton bAdd = null;
    private JButton bRemove = null;
    private JButton bSelectColor = null;
    private JScrollPane jScrollList = null;
    private TranspByPixelRGBInputPanel pWest = null;
    private TranspByPixelAndOrSelectorPanel pOperation = null;
    private TranspByPixelListener listener = null;
    private ArrayList<TranspByPixelEventListener> actionCommandListeners = new ArrayList();

    public TranspByPixelPanel() {
        this.initialize();
        this.getListener();
        this.setControlEnabled(false);
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getActiveControl(), "North");
        this.add((Component)this.getPixelSelector(), "Center");
    }

    private JPanel getPixelSelector() {
        if (this.pixelSelector == null) {
            this.pixelSelector = new JPanel();
            this.pixelSelector.setBorder(BorderFactory.createEmptyBorder(5, 11, 5, 11));
            this.pixelSelector.setLayout(new BorderLayout(5, 5));
            JPanel jpanel1 = new JPanel();
            jpanel1.setLayout(new BorderLayout(5, 5));
            jpanel1.add((Component)this.getPRGBInput(), "Center");
            jpanel1.add((Component)this.getPCenter(), "East");
            this.pixelSelector.add((Component)jpanel1, "Center");
            this.pixelSelector.add((Component)this.getPList(), "East");
        }
        return this.pixelSelector;
    }

    private JPanel getActiveControl() {
        if (this.activeControl == null) {
            this.activeControl = new JPanel();
            FlowLayout fl = new FlowLayout();
            fl.setAlignment(0);
            this.activeControl.setLayout(fl);
            this.activeControl.add(this.getActiveCheck());
        }
        return this.activeControl;
    }

    public JCheckBox getActiveCheck() {
        if (this.activeCheck == null) {
            this.activeCheck = new JCheckBox(PluginServices.getText((Object)this, (String)"activar"));
            this.activeCheck.setSelected(false);
        }
        return this.activeCheck;
    }

    public TranspByPixelRGBInputPanel getPRGBInput() {
        if (this.pWest == null) {
            this.pWest = new TranspByPixelRGBInputPanel();
        }
        return this.pWest;
    }

    public JPanel getPList() {
        if (this.pEast == null) {
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.fill = 1;
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.gridy = 0;
            gridBagConstraints3.weightx = 1.0;
            gridBagConstraints3.weighty = 1.0;
            gridBagConstraints3.insets = new Insets(0, 0, 0, 0);
            this.pEast = new JPanel();
            this.pEast.setLayout(new GridBagLayout());
            this.pEast.add((Component)this.getJScrollList(), gridBagConstraints3);
        }
        return this.pEast;
    }

    private JPanel getPCenter() {
        if (this.pCenter == null) {
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints1.gridy = 1;
            gridBagConstraints1.gridx = 0;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridx = 0;
            this.pCenter = new JPanel();
            this.pCenter.setLayout(new GridBagLayout());
            this.pCenter.add((Component)this.getPButtons(), gridBagConstraints);
            this.pCenter.add((Component)this.getPOperation(), gridBagConstraints1);
        }
        return this.pCenter;
    }

    public JButton getBAdd() {
        if (this.bAdd == null) {
            I18nManager i18nManager = ToolsLocator.getI18nManager();
            this.bAdd = new JButton(i18nManager.getTranslation("add"));
            this.bAdd.setHorizontalTextPosition(2);
            this.bAdd.setIcon(RasterToolsUtil.getIcon("forward-icon"));
        }
        return this.bAdd;
    }

    public JButton getBRemove() {
        if (this.bRemove == null) {
            I18nManager i18nManager = ToolsLocator.getI18nManager();
            this.bRemove = new JButton(i18nManager.getTranslation("remove"));
            this.bRemove.setHorizontalTextPosition(4);
            this.bRemove.setIcon(RasterToolsUtil.getIcon("backward-icon"));
            this.bRemove.setEnabled(false);
        }
        return this.bRemove;
    }

    public JButton getBSelectColor() {
        if (this.bSelectColor == null) {
            this.bSelectColor = new JButton();
            this.bSelectColor.setIcon(RasterToolsUtil.getIcon("selectrgb-icon"));
            this.bSelectColor.setPreferredSize(new Dimension(26, 26));
            this.bSelectColor.setToolTipText(RasterToolsUtil.getText(this, "select_rgb"));
        }
        return this.bSelectColor;
    }

    private JPanel getPButtons() {
        if (this.pButtons == null) {
            this.pButtons = new JPanel();
            this.pButtons.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(3, 3, 3, 3);
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.fill = 2;
            this.pButtons.add((Component)this.getBAdd(), gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(3, 3, 3, 3);
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.fill = 2;
            this.pButtons.add((Component)this.getBRemove(), gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(3, 3, 3, 3);
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridx = 0;
            this.pButtons.add((Component)this.getBSelectColor(), gridBagConstraints);
        }
        return this.pButtons;
    }

    public TranspByPixelAndOrSelectorPanel getPOperation() {
        if (this.pOperation == null) {
            this.pOperation = new TranspByPixelAndOrSelectorPanel();
            this.pOperation.setPreferredSize(new Dimension(60, 60));
        }
        return this.pOperation;
    }

    public JList getJList() {
        if (this.jList == null) {
            this.jList = new JList(new DefaultListModel());
            this.jList.setFont(new Font("Monospaced", 0, 10));
            this.jList.setSelectionMode(0);
        }
        return this.jList;
    }

    public JScrollPane getJScrollList() {
        if (this.jScrollList == null) {
            this.jScrollList = new JScrollPane();
            this.jScrollList.setViewportView(this.getJList());
            this.jScrollList.setPreferredSize(new Dimension(160, 100));
        }
        return this.jScrollList;
    }

    public DefaultListModel getListModel() {
        return (DefaultListModel)this.getJList().getModel();
    }

    public void setControlEnabled(boolean enabled) {
        this.getActiveCheck().setSelected(enabled);
        this.getJList().setEnabled(enabled);
        if (enabled) {
            this.getJList().setBackground(Color.WHITE);
        } else {
            this.getJList().setBackground(this.getBackground());
        }
        this.getPRGBInput().setControlEnabled(enabled);
        this.getBAdd().setEnabled(enabled);
        this.getBSelectColor().setEnabled(enabled);
        if (enabled) {
            this.getBRemove().setEnabled(this.getJList().getModel().getSize() > 0);
        } else {
            this.getBRemove().setEnabled(false);
        }
        this.getPOperation().setControlEnabled(enabled);
        this.controlEnabled = enabled;
    }

    public boolean isControlEnabled() {
        return this.controlEnabled;
    }

    public void setActiveBands(int n) {
        this.getPRGBInput().setActiveBands(n);
    }

    public ArrayList<TransparencyRange> getEntries() {
        return this.getListener().getEntries();
    }

    public TranspByPixelListener getListener() {
        if (this.listener == null) {
            this.listener = new TranspByPixelListener(this);
        }
        return this.listener;
    }

    public void addStringElement(TransparencyRange entry) {
        this.getEntries().add(entry);
        this.getListModel().addElement(entry.getStrEntry());
        this.getBRemove().setEnabled(true);
    }

    public void clear() {
        this.getPRGBInput().clear();
        this.getListModel().clear();
        this.getEntries().clear();
        this.getBRemove().setEnabled(false);
    }

    public void addValueChangedListener(TranspByPixelEventListener listener) {
        if (!this.actionCommandListeners.contains(listener)) {
            this.actionCommandListeners.add(listener);
        }
    }

    public void removeValueChangedListener(TranspByPixelEventListener listener) {
        this.actionCommandListeners.remove(listener);
    }

    public void callValueChanged() {
        for (TranspByPixelEventListener listener : this.actionCommandListeners) {
            listener.actionPixelListChanged(new EventObject(this));
        }
    }
}

