/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.tool.rasterresolution;

import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.messages.NotificationManager;
import org.gvsig.fmap.dal.exception.ReadException;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.exception.CreateEnvelopeException;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.mapcontext.ViewPort;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.fmap.mapcontrol.tools.BehaviorException;
import org.gvsig.fmap.mapcontrol.tools.Events.PointEvent;
import org.gvsig.fmap.mapcontrol.tools.Listeners.PointListener;
import org.gvsig.raster.fmap.layers.FLyrRaster;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZoomPixelCursorListener
implements PointListener {
    private static final GeometryManager geomManager = GeometryLocator.getGeometryManager();
    private static final Logger logger = LoggerFactory.getLogger(ZoomPixelCursorListener.class);
    private Image img = null;
    private Cursor cur = null;
    private MapControl mapCtrl;

    public ZoomPixelCursorListener(MapControl mc) {
        this.mapCtrl = mc;
    }

    public void point(PointEvent event) throws BehaviorException {
        Point2D pReal = this.mapCtrl.getMapContext().getViewPort().toMapPoint(event.getPoint());
        ViewPort v = this.mapCtrl.getMapContext().getViewPort();
        FLayer[] actives = this.mapCtrl.getMapContext().getLayers().getActives();
        Envelope ext = null;
        try {
            ext = actives[0].getFullEnvelope();
        }
        catch (ReadException e1) {
            NotificationManager.addError((String)"Error al obtener el extent", (Throwable)e1);
        }
        ArrayList attr = ((FLyrRaster)actives[0]).getAttributes();
        int width = 0;
        int height = 0;
        for (int i = 0; i < attr.size(); ++i) {
            Object[] a = (Object[])attr.get(i);
            if (a[0].toString().equals("Width")) {
                width = (Integer)a[1];
            }
            if (!a[0].toString().equals("Height")) continue;
            height = (Integer)a[1];
        }
        if (ext != null && width != 0 && height != 0) {
            double wcOriginCenterX = pReal.getX();
            double wcOriginCenterY = pReal.getY();
            double relacionPixelWcWidth = (ext.getMaximum(0) - ext.getMinimum(0)) / (double)width;
            double relacionPixelWcHeight = (ext.getMaximum(1) - ext.getMinimum(1)) / (double)height;
            double wcOriginX = wcOriginCenterX - (double)v.getImageWidth() * relacionPixelWcWidth / 2.0;
            double wcOriginY = wcOriginCenterY - (double)v.getImageHeight() * relacionPixelWcHeight / 2.0;
            double wcDstMinX = wcOriginX;
            double wcDstMinY = wcOriginY;
            double wcDstMaxX = wcDstMinX + (double)v.getImageWidth() * relacionPixelWcWidth;
            double wcDstMaxY = wcDstMinY + (double)v.getImageHeight() * relacionPixelWcHeight;
            double wcDstWidth = wcDstMaxX - wcDstMinX;
            double wcDstHeight = wcDstMaxY - wcDstMinY;
            try {
                ext = geomManager.createEnvelope(wcDstMinX, wcDstMinY, wcDstMinX + wcDstWidth, wcDstMinY + wcDstHeight, 0);
            }
            catch (CreateEnvelopeException e) {
                logger.error("Error creating the Envelope", (Throwable)e);
            }
            this.mapCtrl.getMapContext().getViewPort().setEnvelope(ext);
        }
    }

    public Cursor getCursor() {
        if (this.cur == null) {
            this.cur = Toolkit.getDefaultToolkit().createCustomCursor(this.getImageCursor(), new Point(16, 16), "");
        }
        return this.cur;
    }

    public boolean cancelDrawing() {
        return false;
    }

    public void pointDoubleClick(PointEvent event) throws BehaviorException {
    }

    public Image getImageCursor() {
        if (this.img == null) {
            this.img = IconThemeHelper.getImage((String)"zoom-pixel-cursor");
        }
        return this.img;
    }
}

