/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.tool.roi.ui.listener;

import java.awt.Color;
import java.awt.Image;
import java.awt.geom.Point2D;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.primitive.GeneralPathX;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.layers.vectorial.GraphicLayer;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.fmap.mapcontext.rendering.symbols.SymbolManager;
import org.gvsig.fmap.mapcontrol.tools.BehaviorException;
import org.gvsig.fmap.mapcontrol.tools.Events.MeasureEvent;
import org.gvsig.fmap.mapcontrol.tools.Events.PointEvent;
import org.gvsig.fmap.mapcontrol.tools.Listeners.PointListener;
import org.gvsig.fmap.mapcontrol.tools.Listeners.PolylineListener;
import org.gvsig.gui.beans.table.exceptions.NotInitializeException;
import org.gvsig.raster.roi.ROI;
import org.gvsig.raster.roi.VectorialROI;
import org.gvsig.raster.swing.RasterSwingLibrary;
import org.gvsig.raster.tools.app.basic.tool.roi.ROIDataModel;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.marker.impl.SimpleMarkerSymbol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DrawMouseViewListener
implements PolylineListener,
PointListener {
    private static final GeometryManager geomManager = GeometryLocator.getGeometryManager();
    private static final Logger logger = LoggerFactory.getLogger(DrawMouseViewListener.class);
    private ROIDataModel roiDataModel = null;
    private VectorialROI roi = null;
    private SymbolManager symbolManager = MapContextLocator.getSymbolManager();

    public DrawMouseViewListener(ROIDataModel roiManagerPanel) {
        this.roiDataModel = roiManagerPanel;
    }

    public void pointFixed(MeasureEvent event) throws BehaviorException {
    }

    public void points(MeasureEvent event) throws BehaviorException {
    }

    public void polylineFinished(MeasureEvent event) throws BehaviorException {
        GeneralPathX gp = event.getGP();
        Object geometry = null;
        try {
            geometry = this.roiDataModel.getMapControl().getCurrentTool().equals("drawPolygonROI") ? geomManager.createSurface(gp, 0) : geomManager.createCurve(gp, 0);
        }
        catch (CreateGeometryException e) {
            logger.error("Error creating the envelope", (Throwable)e);
        }
        String roiName = "";
        try {
            int selectedRow = this.roiDataModel.getTable().getSelectedRow();
            roiName = (String)this.roiDataModel.getTable().getModel().getValueAt(selectedRow, 0);
            this.roi = (VectorialROI)this.roiDataModel.getROI(roiName);
            if (this.roi == null) {
                RasterSwingLibrary.messageBoxError((String)"error_roi_not_selected", (Object)this.roiDataModel, (Exception)new NullPointerException("ROI no seleccionada DrawMouseViewListener L 61"));
                return;
            }
            this.roi.addGeometry((Geometry)geometry);
            this.roi.setID(System.currentTimeMillis());
            ISymbol sym = null;
            Color geometryColor = (Color)this.roiDataModel.getTable().getModel().getValueAt(selectedRow, 4);
            if (this.roiDataModel.getROIPanel().getButton(4).isSelected()) {
                int numGeometries = (Integer)this.roiDataModel.getTable().getModel().getValueAt(selectedRow, 1);
                this.roiDataModel.getTable().getModel().setValueAt(new Integer(numGeometries + 1), selectedRow, 1);
                sym = this.symbolManager.createSymbol("fill", geometryColor);
            } else {
                int numGeometries = (Integer)this.roiDataModel.getTable().getModel().getValueAt(selectedRow, 2);
                this.roiDataModel.getTable().getModel().setValueAt(new Integer(numGeometries + 1), selectedRow, 2);
                sym = this.symbolManager.createSymbol("line", geometryColor);
            }
            GraphicLayer graphicLayer = this.roiDataModel.getGraphicLayer();
            FeatureStore store = graphicLayer.getFeatureStore();
            if (!store.isEditing()) {
                store.edit();
            }
            EditableFeature feature = this.roiDataModel.getRoiFeatureManager().addROIFeature((ROI)this.roi, graphicLayer, (Geometry)geometry, sym);
            store.insert(feature);
            this.roiDataModel.getMapControl().drawGraphics();
        }
        catch (NotInitializeException e) {
            RasterSwingLibrary.messageBoxError((String)"error_tabla_rois", (Object)this.roiDataModel, (Exception)((Object)e));
        }
        catch (DataException e) {
            RasterSwingLibrary.messageBoxError((String)"error_tabla_rois", (Object)this.roiDataModel, (Exception)((Object)e));
        }
    }

    public boolean cancelDrawing() {
        return true;
    }

    public Image getImageCursor() {
        return this.roiDataModel.getToolImage();
    }

    public void point(PointEvent event) throws BehaviorException {
        Point2D point = event.getPoint();
        Point2D p = this.roiDataModel.getMapControl().getViewPort().toMapPoint(point);
        Point geometry = null;
        try {
            geometry = geomManager.createPoint(p.getX(), p.getY(), 0);
        }
        catch (CreateGeometryException e1) {
            logger.error("Error creating a point", (Throwable)e1);
        }
        String roiName = "";
        try {
            int selectedRow = this.roiDataModel.getTable().getSelectedRow();
            roiName = (String)this.roiDataModel.getTable().getModel().getValueAt(selectedRow, 0);
            this.roi = (VectorialROI)this.roiDataModel.getROI(roiName);
            this.roi.addGeometry((Geometry)geometry);
            int numPoints = (Integer)this.roiDataModel.getTable().getModel().getValueAt(selectedRow, 3);
            this.roiDataModel.getTable().getModel().setValueAt(new Integer(numPoints + 1), selectedRow, 3);
            Color geometryColor = (Color)this.roiDataModel.getTable().getModel().getValueAt(selectedRow, 4);
            ISymbol sym = this.symbolManager.createSymbol("marker", geometryColor);
            ((SimpleMarkerSymbol)sym).setStyle(0);
            GraphicLayer graphicLayer = this.roiDataModel.getGraphicLayer();
            FeatureStore store = graphicLayer.getFeatureStore();
            if (!store.isEditing()) {
                store.edit();
            }
            EditableFeature feature = this.roiDataModel.getRoiFeatureManager().addROIFeature((ROI)this.roi, graphicLayer, (Geometry)geometry, sym);
            store.insert(feature);
            this.roiDataModel.getMapControl().drawGraphics();
        }
        catch (NotInitializeException e) {
            RasterSwingLibrary.messageBoxError((String)"error_tabla_rois", (Object)this.roiDataModel, (Exception)((Object)e));
        }
        catch (DataException e) {
            RasterSwingLibrary.messageBoxError((String)"error_tabla_rois", (Object)this.roiDataModel, (Exception)((Object)e));
        }
    }

    public void pointDoubleClick(PointEvent event) throws BehaviorException {
    }
}

