/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.tool.saveraster.ui.listener;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.EventObject;
import javax.swing.filechooser.FileFilter;
import org.gvsig.andami.PluginServices;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.util.MathUtils;
import org.gvsig.gui.beans.datainput.DataInputContainer;
import org.gvsig.gui.beans.datainput.DataInputContainerListener;
import org.gvsig.gui.beans.swing.JFileChooser;
import org.gvsig.raster.tools.app.basic.tool.saveraster.ui.SaveRasterDialog;
import org.gvsig.raster.tools.app.basic.tool.saveraster.ui.SaveRasterPanel;
import org.gvsig.raster.util.ExtendedFileFilter;

public class DataInputListener
implements ActionListener,
MouseListener,
FocusListener,
KeyListener,
DataInputContainerListener {
    private static final long serialVersionUID = -3370601314380922368L;
    private SaveRasterPanel controlPanel = null;
    private SaveRasterDialog dialog = null;
    private String fName = null;
    private double widthInPixels = 0.0;
    private double heightInPixels = 0.0;
    private double mtsPerPixel = 0.0;
    private Object obj = null;
    private double widthMts = 0.0;
    private double heightMts = 0.0;
    private boolean enableEventValueChanged = true;
    private MathUtils math = RasterLocator.getManager().getMathUtils();

    public DataInputListener(SaveRasterPanel controlPanel) {
        this.controlPanel = controlPanel;
        this.initialize();
    }

    void initialize() {
        this.controlPanel.getTScale().addValueChangedListener((DataInputContainerListener)this);
        this.controlPanel.getTMtsPixel().addValueChangedListener((DataInputContainerListener)this);
        this.controlPanel.getTWidth().addValueChangedListener((DataInputContainerListener)this);
        this.controlPanel.getTHeight().addValueChangedListener((DataInputContainerListener)this);
        this.controlPanel.getCbMeasureType().addActionListener(this);
        this.controlPanel.getTInfDerX().addValueChangedListener((DataInputContainerListener)this);
        this.controlPanel.getTInfDerY().addValueChangedListener((DataInputContainerListener)this);
        this.controlPanel.getTSupIzqX().addValueChangedListener((DataInputContainerListener)this);
        this.controlPanel.getTSupIzqY().addValueChangedListener((DataInputContainerListener)this);
        this.controlPanel.getBSelect().addActionListener(this);
        this.controlPanel.getBProperties().addActionListener(this);
        this.controlPanel.getCbResolution().addActionListener(this);
        this.controlPanel.getCbResolution().addKeyListener(this);
    }

    public void setDialogPanel(SaveRasterDialog dialog) {
        this.dialog = dialog;
    }

    public SaveRasterPanel getSaveParameters() {
        if (this.controlPanel == null) {
            this.controlPanel = new SaveRasterPanel();
        }
        return this.controlPanel;
    }

    private int getCorrectMeasure(String value) {
        if (this.controlPanel.getCbMeasureType().getSelectedItem().equals("Pixels")) {
            return (int)Double.parseDouble(value);
        }
        int ppp = Integer.parseInt((String)this.controlPanel.getCbResolution().getSelectedItem());
        if (this.controlPanel.getCbMeasureType().getSelectedItem().equals("Mts")) {
            return this.math.convertMtsToPixels(Double.parseDouble(value), ppp);
        }
        if (this.controlPanel.getCbMeasureType().getSelectedItem().equals("Cms")) {
            return this.math.convertCmsToPixels(Double.parseDouble(value), ppp);
        }
        if (this.controlPanel.getCbMeasureType().getSelectedItem().equals("Mms")) {
            return this.math.convertMmsToPixels(Double.parseDouble(value), ppp);
        }
        if (this.controlPanel.getCbMeasureType().getSelectedItem().equals("Inches")) {
            return this.math.convertInchesToPixels(Double.parseDouble(value), ppp);
        }
        return 0;
    }

    private void setCorrectMeasure(double pixel, DataInputContainer field) {
        if (this.controlPanel.getCbMeasureType().getSelectedItem().equals("Pixels")) {
            field.setValue(String.valueOf(pixel));
            return;
        }
        this.enableEventValueChanged = false;
        int ppp = Integer.parseInt((String)this.controlPanel.getCbResolution().getSelectedItem());
        if (this.controlPanel.getCbMeasureType().getSelectedItem().equals("Mts")) {
            field.setValue(String.valueOf(this.math.clipDecimals(this.math.convertPixelsToMts(pixel, ppp), 5)));
        }
        if (this.controlPanel.getCbMeasureType().getSelectedItem().equals("Cms")) {
            field.setValue(String.valueOf(this.math.clipDecimals(this.math.convertPixelsToCms(pixel, ppp), 5)));
        }
        if (this.controlPanel.getCbMeasureType().getSelectedItem().equals("Mms")) {
            field.setValue(String.valueOf(this.math.clipDecimals(this.math.convertPixelsToMms(pixel, ppp), 5)));
        }
        if (this.controlPanel.getCbMeasureType().getSelectedItem().equals("Inches")) {
            field.setValue(String.valueOf(this.math.clipDecimals(this.math.convertPixelsToInches(pixel, ppp), 5)));
        }
        this.enableEventValueChanged = true;
    }

    private void recalcParams() {
        this.validateFields();
        try {
            double[] size = this.calcSizeInMts();
            if (size == null) {
                return;
            }
            this.widthMts = size[0];
            this.heightMts = size[1];
        }
        catch (NumberFormatException e) {
            return;
        }
        int resolution = Integer.parseInt((String)this.controlPanel.getCbResolution().getSelectedItem());
        if (this.obj.equals(this.controlPanel.getCbResolution())) {
            String escala = this.controlPanel.getTScale().getValue();
            try {
                if (this.controlPanel.getViewPort().getProjection().isProjected()) {
                    this.calcSizeMtsPixel(Double.parseDouble(escala), resolution);
                }
            }
            catch (NumberFormatException exc) {
                this.calcSizeMtsPixel(0.0, resolution);
            }
            return;
        }
        if (this.controlPanel.getRbScale().isSelected() && !this.controlPanel.getTScale().getValue().equals("")) {
            double scale = Double.parseDouble(this.controlPanel.getTScale().getValue());
            this.calcSizeMtsPixel(scale, resolution);
        }
        if (this.controlPanel.getRbSize().isSelected()) {
            double rel = this.widthMts / this.heightMts;
            if (this.obj != null && this.obj.equals(this.controlPanel.getTWidth().getDataInputField()) && !this.controlPanel.getTWidth().getValue().equals("")) {
                this.widthInPixels = this.getCorrectMeasure(this.controlPanel.getTWidth().getValue());
                this.heightInPixels = (int)Math.floor(this.widthInPixels / rel);
                this.calcScaleMtsPixel(this.widthInPixels, this.heightInPixels, resolution);
            }
            if (this.obj != null && this.obj.equals(this.controlPanel.getTHeight().getDataInputField()) && !this.controlPanel.getTHeight().getValue().equals("")) {
                this.heightInPixels = this.getCorrectMeasure(this.controlPanel.getTHeight().getValue());
                this.widthInPixels = (int)Math.ceil(this.heightInPixels * rel);
                this.calcScaleMtsPixel(this.widthInPixels, this.heightInPixels, resolution);
            }
            if (this.obj != null && this.obj.equals(this.controlPanel.getCbMeasureType())) {
                this.calcScaleMtsPixel(this.widthInPixels, this.heightInPixels, resolution);
            }
        }
        if (this.controlPanel.getRbMtsPixel().isSelected() && !this.controlPanel.getTMtsPixel().getValue().equals("")) {
            double mtsPixel = Double.parseDouble(this.controlPanel.getTMtsPixel().getValue());
            this.calcSizeScale(mtsPixel, resolution);
        }
    }

    private void validateTextField(DataInputContainer field) {
        try {
            Double.parseDouble(field.getValue());
        }
        catch (NumberFormatException e) {
            field.setValue("0");
        }
    }

    private void validateFields() {
        if (!this.controlPanel.getTScale().getValue().equals("")) {
            this.validateTextField(this.controlPanel.getTScale());
        }
        if (!this.controlPanel.getTMtsPixel().getValue().equals("")) {
            this.validateTextField(this.controlPanel.getTMtsPixel());
        }
        if (!this.controlPanel.getTWidth().getValue().equals("")) {
            this.validateTextField(this.controlPanel.getTWidth());
        }
        if (!this.controlPanel.getTHeight().getValue().equals("")) {
            this.validateTextField(this.controlPanel.getTHeight());
        }
    }

    private double[] calcSizeInMts() throws NumberFormatException {
        double lrx = Double.parseDouble(this.controlPanel.getTInfDerX().getValue());
        double lry = Double.parseDouble(this.controlPanel.getTInfDerY().getValue());
        double ulx = Double.parseDouble(this.controlPanel.getTSupIzqX().getValue());
        double uly = Double.parseDouble(this.controlPanel.getTSupIzqY().getValue());
        double distWidth = 0.0;
        double distHeight = 0.0;
        distWidth = ulx > lrx ? ulx - lrx : lrx - ulx;
        distHeight = uly > lry ? uly - lry : lry - uly;
        return new double[]{distWidth, distHeight};
    }

    private void calcSizeMtsPixel(double scale, int resolution) {
        if (this.widthMts <= 0.0 || this.heightMts <= 0.0 || scale == 0.0) {
            this.controlPanel.getTWidth().setValue("0");
            this.controlPanel.getTHeight().setValue("0");
            return;
        }
        double widthInches = this.widthMts / scale * 39.73007874;
        double heightInches = this.heightMts / scale * 39.73007874;
        this.widthInPixels = (int)((double)resolution * widthInches);
        this.heightInPixels = (int)((double)resolution * heightInches);
        this.mtsPerPixel = this.widthMts / this.widthInPixels;
        this.mtsPerPixel = this.math.clipDecimals(this.mtsPerPixel, 5);
        this.enableEventValueChanged = false;
        this.controlPanel.getTMtsPixel().setValue(String.valueOf(this.mtsPerPixel));
        this.enableEventValueChanged = true;
        this.setCorrectMeasure(this.widthInPixels, this.controlPanel.getTWidth());
        this.setCorrectMeasure(this.heightInPixels, this.controlPanel.getTHeight());
    }

    private void calcSizeScale(double mtsPixel, int resolution) {
        this.widthInPixels = (int)(this.widthMts / mtsPixel);
        this.heightInPixels = (int)(this.heightMts / mtsPixel);
        this.mtsPerPixel = this.widthMts / this.widthInPixels;
        this.mtsPerPixel = this.math.clipDecimals(this.mtsPerPixel, 5);
        double widthInches = this.widthInPixels / (double)Integer.parseInt(this.controlPanel.getCbResolution().getSelectedItem().toString());
        int scale = (int)(this.widthMts * 39.73007874 / widthInches);
        this.controlPanel.getTScale().setValue(String.valueOf(scale));
        this.controlPanel.getTMtsPixel().setValue(String.valueOf(this.mtsPerPixel));
        this.setCorrectMeasure(this.widthInPixels, this.controlPanel.getTWidth());
        this.setCorrectMeasure(this.heightInPixels, this.controlPanel.getTHeight());
    }

    private void calcScaleMtsPixel(double widthPixels, double heightPixels, int resolution) {
        this.widthInPixels = widthPixels;
        this.heightInPixels = heightPixels;
        this.mtsPerPixel = this.widthMts / widthPixels;
        this.mtsPerPixel = this.math.clipDecimals(this.mtsPerPixel, 5);
        double widthInches = widthPixels / (double)Integer.parseInt(this.controlPanel.getCbResolution().getSelectedItem().toString());
        int scale = (int)(this.widthMts * 39.73007874 / widthInches);
        this.controlPanel.getTScale().setValue(String.valueOf(scale));
        this.controlPanel.getTMtsPixel().setValue(String.valueOf(this.mtsPerPixel));
        this.setCorrectMeasure(widthPixels, this.controlPanel.getTWidth());
        this.setCorrectMeasure(heightPixels, this.controlPanel.getTHeight());
    }

    public void enableButtons() {
        try {
            if (Double.parseDouble(this.controlPanel.getTWidth().getValue()) == 0.0 || Double.parseDouble(this.controlPanel.getTHeight().getValue()) == 0.0 || this.controlPanel.getTWidth().getValue().equals("") || this.controlPanel.getTHeight().getValue().equals("") || this.fName == null || this.fName.equals("")) {
                if (this.dialog != null) {
                    this.dialog.getButtonsPanel().getButton(3).setEnabled(false);
                }
                return;
            }
        }
        catch (NumberFormatException e) {
            this.dialog.getButtonsPanel().getButton(3).setEnabled(false);
            return;
        }
        if (this.dialog != null) {
            this.dialog.getButtonsPanel().getButton(3).setEnabled(true);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.obj = e.getSource();
        if (this.obj.equals(this.controlPanel.getBSelect())) {
            int returnVal;
            ExtendedFileFilter fileFilter;
            JFileChooser chooser = new JFileChooser("DATA_INPUT_LISTENER", JFileChooser.getLastPath((String)"DATA_INPUT_LISTENER", null));
            chooser.setDialogTitle(PluginServices.getText((Object)this, (String)"seleccionar_fichero"));
            chooser.setAcceptAllFileFilterUsed(false);
            String[] extList = RasterLocator.getManager().getProviderServices().getDriversExtensions();
            ExtendedFileFilter selectedFilter = null;
            for (int i = 0; i < extList.length; ++i) {
                fileFilter = new ExtendedFileFilter(extList[i]);
                chooser.addChoosableFileFilter((FileFilter)fileFilter);
                if (!extList[i].toLowerCase().equals("tif")) continue;
                selectedFilter = fileFilter;
            }
            if (selectedFilter != null) {
                chooser.setFileFilter(selectedFilter);
            }
            if ((returnVal = chooser.showOpenDialog((Component)this.controlPanel)) == 0) {
                fileFilter = (ExtendedFileFilter)chooser.getFileFilter();
                this.fName = chooser.getSelectedFile().toString();
                this.fName = fileFilter.getNormalizedFilename(chooser.getSelectedFile());
                String ext = RasterLocator.getManager().getFileUtils().getExtensionFromFileName(this.fName);
                this.controlPanel.getBProperties().setText(PluginServices.getText((Object)this, (String)"props") + " " + RasterLocator.getManager().getProviderServices().getWriteDriverType(ext));
                this.controlPanel.getBProperties().setEnabled(true);
                this.controlPanel.getLFileName().setText(this.fName.substring(this.fName.lastIndexOf(File.separator) + 1, this.fName.length()));
                this.enableButtons();
                JFileChooser.setLastPath((String)"DATA_INPUT_LISTENER", (File)chooser.getSelectedFile());
            }
        }
        if (e.getSource().equals(this.controlPanel.getCbMeasureType())) {
            this.setCorrectMeasure(this.widthInPixels, this.controlPanel.getTWidth());
            this.setCorrectMeasure(this.heightInPixels, this.controlPanel.getTHeight());
        }
        if (!this.obj.equals(this.controlPanel.getBSelect())) {
            this.recalcParams();
        }
        this.enableButtons();
    }

    public String getFileName() {
        return this.fName;
    }

    public void resetFileName() {
        this.fName = null;
        this.controlPanel.getLFileName().setText("");
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.obj.equals(this.controlPanel.getTHeight()) && e.getSource().equals(this.controlPanel.getTWidth()) || this.obj.equals(this.controlPanel.getTWidth()) && e.getSource().equals(this.controlPanel.getTHeight())) {
            return;
        }
        this.obj = e.getSource();
        this.recalcParams();
        this.enableButtons();
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.obj = e.getSource();
        this.recalcParams();
        this.enableButtons();
    }

    @Override
    public void keyTyped(KeyEvent e) {
        this.enableButtons();
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.enableButtons();
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.enableButtons();
    }

    public double getHeightInPixels() {
        return this.heightInPixels;
    }

    public double getWidthInPixels() {
        return this.widthInPixels;
    }

    public void setWidthInPixels(double value) {
        this.widthInPixels = value;
    }

    public void setHeightInPixels(double value) {
        this.heightInPixels = value;
    }

    public void actionValueChanged(EventObject e) {
        if (this.enableEventValueChanged) {
            this.obj = e.getSource();
            this.recalcParams();
            this.enableButtons();
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void focusGained(FocusEvent e) {
    }
}

