/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.tool.saveviewtoraster.tool;

import java.awt.Image;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.mapcontext.ViewPort;
import org.gvsig.fmap.mapcontext.layers.FLayers;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.fmap.mapcontrol.tools.Events.EnvelopeEvent;
import org.gvsig.fmap.mapcontrol.tools.Listeners.RectangleListener;
import org.gvsig.raster.tools.algorithm.swing.saveraster.SaveRasterPanel;
import org.gvsig.raster.tools.app.basic.tool.saveviewtoraster.ui.SaveViewToRasterDialog;

public class SaveRasterRectangleTool
implements RectangleListener {
    private final Image isaveraster = IconThemeHelper.getImage((String)"rectangle-select-cursor");
    protected MapControl mapCtrl = null;
    protected Rectangle2D pixelRect = null;
    protected Envelope rect = null;
    private String viewName = null;

    public SaveRasterRectangleTool(MapControl mapCtrl, String viewName) {
        this.mapCtrl = mapCtrl;
        this.viewName = viewName;
    }

    public void rectangle(EnvelopeEvent event) {
        this.rect = event.getWorldCoordRect();
        this.pixelRect = event.getPixelCoordRect();
        if (PluginServices.getMainFrame() != null) {
            PluginServices.getMainFrame().enableControls();
        }
        FLayers layers = this.mapCtrl.getMapContext().getLayers();
        SaveViewToRasterDialog saveRaster = null;
        boolean open = false;
        IWindow[] win = PluginServices.getMDIManager().getAllWindows();
        for (int i = 0; i < win.length; ++i) {
            if (!(win[i] instanceof SaveViewToRasterDialog)) continue;
            saveRaster = (SaveViewToRasterDialog)win[i];
            open = true;
        }
        if (saveRaster == null) {
            saveRaster = new SaveViewToRasterDialog(layers, this.mapCtrl, this.viewName);
        }
        ViewPort vp = this.mapCtrl.getViewPort();
        Point2D ini = vp.fromMapPoint(this.rect.getMinimum(0), this.rect.getMinimum(1));
        Point2D fin = vp.fromMapPoint(this.rect.getMaximum(0), this.rect.getMaximum(1));
        if (Math.abs(fin.getY() - ini.getY()) > 10.0 && Math.abs(fin.getX() - ini.getX()) > 10.0) {
            SaveRasterPanel panel = saveRaster.getSaveRasterPanel();
            panel.getBProperties().setEnabled(false);
            DecimalFormat nf = (DecimalFormat)NumberFormat.getInstance(Locale.ENGLISH);
            nf.applyPattern("#.#");
            nf.setMaximumFractionDigits(4);
            if (!vp.getProjection().isProjected()) {
                nf.setMaximumFractionDigits(6);
            }
            try {
                panel.setValueLRX(nf.format(this.rect.getMaximum(0)));
            }
            catch (IndexOutOfBoundsException ex) {
                panel.setValueLRX(String.valueOf(this.rect.getMaximum(0)));
            }
            try {
                panel.setValueLRY(nf.format(this.rect.getMinimum(1)));
            }
            catch (IndexOutOfBoundsException ex) {
                panel.setValueLRY(String.valueOf(this.rect.getMinimum(1)));
            }
            try {
                panel.setValueULX(nf.format(this.rect.getMinimum(0)));
            }
            catch (IndexOutOfBoundsException ex) {
                panel.setValueULX(String.valueOf(this.rect.getMinimum(0)));
            }
            try {
                panel.setValueULY(nf.format(this.rect.getMaximum(1)));
            }
            catch (IndexOutOfBoundsException ex) {
                panel.setValueULY(String.valueOf(this.rect.getMaximum(1)));
            }
            if (!open) {
                PluginServices.getMDIManager().addCentredWindow((IWindow)saveRaster);
            }
            panel.setWidthPxValue(String.valueOf((int)this.pixelRect.getWidth()));
        }
    }

    public Image getImageCursor() {
        return this.isaveraster;
    }

    public boolean cancelDrawing() {
        System.out.println("cancelDrawing del SaveRasterListenerImpl");
        return true;
    }
}

