/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.georeferencing.app.georeferencingclient;

import java.awt.geom.Point2D;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.datastruct.GeoPoint;
import org.gvsig.fmap.dal.coverage.datastruct.GeoPointList;
import org.gvsig.fmap.dal.coverage.exception.RmfSerializerException;
import org.gvsig.fmap.dal.coverage.store.RasterDataStore;
import org.gvsig.i18n.Messages;
import org.gvsig.raster.georeferencing.app.georeferencingclient.TableWrapper;
import org.gvsig.raster.georeferencing.swing.impl.GeoreferencingSwingImplLibrary;
import org.gvsig.raster.georeferencing.swing.impl.layer.GPGraphic;
import org.gvsig.raster.georeferencing.swing.model.GCPList;
import org.gvsig.raster.georeferencing.swing.model.GeoreferencingOptionsDataModel;
import org.gvsig.raster.georeferencing.swing.view.SynchronizedViews;
import org.gvsig.raster.swing.RasterSwingLibrary;
import org.gvsig.raster.util.ExtendedFileFilter;

public class GeoPointsPersistence {
    private GeoreferencingOptionsDataModel dataModel = null;

    public GeoPointsPersistence(GeoreferencingOptionsDataModel dataModel) {
        this.dataModel = dataModel;
    }

    public void saveToRMF(GCPList pointList, RasterDataStore store) {
        if (!RasterSwingLibrary.messageBoxYesOrNot((String)"sobreescribir_puntos", null)) {
            return;
        }
        GeoPointList geoPointList = pointList.getGeoPointList();
        try {
            store.setGeoPointList(geoPointList);
            store.saveGeoPointListToRmf(geoPointList);
        }
        catch (RmfSerializerException e) {
            RasterSwingLibrary.messageBoxError((String)"error_salvando_rmf", null, (Exception)((Object)e));
        }
    }

    public void loadFromRMF(SynchronizedViews syncViews, TableWrapper tableWrapper) {
        if (!RasterSwingLibrary.messageBoxYesOrNot((String)"eliminar_puntos", null)) {
            return;
        }
        syncViews.removeAllPoints();
        tableWrapper.getPagedTable().removeAllRowsWithoutAsk();
        GeoPointList geoPointList = this.dataModel.getDataStore().getGeoPointList();
        if (geoPointList == null) {
            RasterSwingLibrary.messageBoxInfo((String)"no_points_to_load", null);
            return;
        }
        GeoPointListImpl clonedPointList = new GeoPointListImpl();
        for (int i = 0; i < geoPointList.size(); ++i) {
            clonedPointList.add(((GeoPoint)geoPointList.get(i)).cloneGeoPoint());
        }
        this.buildPointListFromGeoPointListObject(this.dataModel, tableWrapper, syncViews, clonedPointList);
    }

    public void exportToCSV(GCPList pointList, boolean error) {
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle(Messages.getText((String)"seleccionar_fichero"));
        int returnVal = chooser.showSaveDialog(null);
        if (returnVal == 0) {
            String fName = chooser.getSelectedFile().toString();
            if (!fName.endsWith(".csv")) {
                fName = fName + ".csv";
            }
            this.saveCSVPointList(fName, pointList, error);
        }
    }

    public void importFromCSV(SynchronizedViews syncViews, TableWrapper tableWrapper) {
        int returnVal;
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle(Messages.getText((String)"seleccionar_fichero"));
        ExtendedFileFilter fileFilter = null;
        fileFilter = new ExtendedFileFilter();
        fileFilter.addExtension("csv");
        fileFilter.setDescription("CSV File");
        chooser.addChoosableFileFilter((FileFilter)fileFilter);
        if (fileFilter != null) {
            chooser.setFileFilter((FileFilter)fileFilter);
        }
        if ((returnVal = chooser.showOpenDialog(null)) == 0) {
            File f = chooser.getSelectedFile();
            if (!f.exists()) {
                RasterSwingLibrary.messageBoxError((String)"error_file_not_found", null);
                return;
            }
            if (!RasterSwingLibrary.messageBoxYesOrNot((String)"eliminar_puntos", null)) {
                return;
            }
            this.loadCSVPointList(f.getAbsolutePath(), syncViews, tableWrapper);
            tableWrapper.updateErrors();
        }
    }

    public void saveCSVPointList(String file, GCPList pointList, boolean error) {
        try {
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file)));
            if (error) {
                out.write("\"Pt\",\"X\",\"Y\",\"X'\",\"Y'\",\"ErrX\",\"ErrY\",\"RMS\"\n");
            } else {
                out.write("\"Pt\",\"X\",\"Y\",\"X'\",\"Y'\"\n");
            }
            for (int i = 0; i < pointList.size(); ++i) {
                GeoPoint geoPoint = pointList.getGeoPoint(i);
                String point = i + "," + geoPoint.getPixelPoint().getX() + "," + geoPoint.getPixelPoint().getY() + "," + geoPoint.getMapPoint().getX() + "," + geoPoint.getMapPoint().getY();
                String errorTxt = "";
                try {
                    errorTxt = geoPoint.getErrorX() + "," + geoPoint.getErrorY() + "," + geoPoint.getRms();
                    if (error) {
                        out.write(point + "," + errorTxt + "\n");
                        continue;
                    }
                    out.write(point + "\n");
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException ex) {
                    out.write(point + "\n");
                }
            }
            out.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void loadCSVPointList(String file, SynchronizedViews syncViews, TableWrapper tableWrapper) {
        GeoPointListImpl geoPointList = new GeoPointListImpl();
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            String line = in.readLine();
            int nPoint = 0;
            while (line != null) {
                if (nPoint == 0) {
                    if (!(line.equals("\"Pt\",\"X\",\"Y\",\"X'\",\"Y'\",\"ErrX\",\"ErrY\",\"RMS\"") || line.equals("\"Pt\",\"X\",\"Y\",\"X'\",\"Y'\"") || line.equals("\"Pt\",\"X\",\"Y\",\"X'\",\"Y'\",\"Z\",\"ErrX\",\"ErrY\",\"RMS\"") || line.equals("\"Pt\",\"X\",\"Y\",\"X'\",\"Y'\",\"Z\""))) {
                        GeoreferencingSwingImplLibrary.messageBoxError((String)"error_point_file", null);
                        return;
                    }
                    syncViews.removeAllPoints();
                    tableWrapper.getPagedTable().removeAllRowsWithoutAsk();
                } else {
                    double x = 0.0;
                    double y = 0.0;
                    double xx = 0.0;
                    double yy = 0.0;
                    String[] tokens = line.split(",");
                    for (int tok = 0; tok < tokens.length; ++tok) {
                        try {
                            if (tok == 1) {
                                x = Double.parseDouble(tokens[tok]);
                            }
                            if (tok == 2) {
                                y = Double.parseDouble(tokens[tok]);
                            }
                            if (tok == 3) {
                                xx = Double.parseDouble(tokens[tok]);
                            }
                            if (tok != 4) continue;
                            yy = Double.parseDouble(tokens[tok]);
                            continue;
                        }
                        catch (NumberFormatException ex) {
                            break;
                        }
                    }
                    if (x == 0.0 && y == 0.0 && xx == 0.0 && yy == 0.0) {
                        line = in.readLine();
                        continue;
                    }
                    Point2D.Double map = new Point2D.Double(xx, yy);
                    Point2D.Double raster = new Point2D.Double(x, y);
                    GeoPoint gp = RasterLocator.getManager().getDataStructFactory().createGeoPoint((Point2D)raster, (Point2D)map);
                    geoPointList.add(gp);
                }
                ++nPoint;
                line = in.readLine();
            }
            in.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.buildPointListFromGeoPointListObject(this.dataModel, tableWrapper, syncViews, geoPointList);
    }

    public void buildPointListFromGeoPointListObject(GeoreferencingOptionsDataModel dataModel, TableWrapper table, SynchronizedViews syncViews, GeoPointList geoPointList) {
        long id = System.currentTimeMillis();
        if (geoPointList == null) {
            return;
        }
        for (int i = 0; i < geoPointList.size(); ++i) {
            GeoPoint gp = (GeoPoint)geoPointList.get(i);
            GPGraphic graphicGCP = new GPGraphic((GeoPoint)geoPointList.get(i));
            graphicGCP.setId(id);
            graphicGCP.setNumber(i);
            dataModel.getGCPList().add((Object)graphicGCP);
            table.getPagedTable().addRow(new Object[]{true, gp.getNumber(), gp.getMapPoint().getX(), gp.getMapPoint().getY(), gp.getPixelPoint().getX(), gp.getPixelPoint().getY(), gp.getErrorX(), gp.getErrorY(), gp.getRms(), id});
            ++id;
            if (i != geoPointList.size() - 1) continue;
            dataModel.getGCPList().setSelectedPoint(i);
        }
        table.updateErrors();
        syncViews.redrawPoints();
    }

    class GeoPointListImpl
    extends ArrayList<GeoPoint>
    implements GeoPointList {
        private static final long serialVersionUID = 1L;

        GeoPointListImpl() {
        }

        public GeoPointList clone() {
            GeoPointListImpl clonedPointList = new GeoPointListImpl();
            for (int i = 0; i < this.size(); ++i) {
                clonedPointList.add(((GeoPoint)this.get(i)).cloneGeoPoint());
            }
            return clonedPointList;
        }
    }
}

