/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.georeferencing.app.georeferencingclient;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.app.project.documents.Document;
import org.gvsig.app.project.documents.view.ViewDocument;
import org.gvsig.app.project.documents.view.gui.IView;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.datastruct.Extent;
import org.gvsig.fmap.dal.coverage.datastruct.GeoPoint;
import org.gvsig.fmap.dal.coverage.datastruct.GeoPointList;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.gui.beans.incrementabletask.IncrementableEvent;
import org.gvsig.i18n.Messages;
import org.gvsig.raster.georeferencing.app.georeferencingclient.TableWrapper;
import org.gvsig.raster.georeferencing.app.georeferencingclient.listener.ApplicationControlsListener;
import org.gvsig.raster.georeferencing.app.georeferencingclient.listener.GeoreferencingProcessActions;
import org.gvsig.raster.georeferencing.app.georeferencingclient.listener.LauncherDialogListener;
import org.gvsig.raster.georeferencing.app.georeferencingclient.listener.PointListListener;
import org.gvsig.raster.georeferencing.app.georeferencingclient.listener.ViewDialogListener;
import org.gvsig.raster.georeferencing.app.georeferencingclient.listener.ViewMapRequestManager;
import org.gvsig.raster.georeferencing.app.georeferencingclient.listener.ViewRasterRequestManager;
import org.gvsig.raster.georeferencing.swing.GeoreferencingLauncher;
import org.gvsig.raster.georeferencing.swing.GeoreferencingSwingLibrary;
import org.gvsig.raster.georeferencing.swing.GeoreferencingSwingLocator;
import org.gvsig.raster.georeferencing.swing.GeoreferencingSwingManager;
import org.gvsig.raster.georeferencing.swing.LayoutEnvironment;
import org.gvsig.raster.georeferencing.swing.control.GeorefControlPanel;
import org.gvsig.raster.georeferencing.swing.exception.InvalidRequestException;
import org.gvsig.raster.georeferencing.swing.impl.GeoreferencingSwingImplLibrary;
import org.gvsig.raster.georeferencing.swing.impl.layer.GPGraphic;
import org.gvsig.raster.georeferencing.swing.model.GeoreferencingOptionsDataModel;
import org.gvsig.raster.georeferencing.swing.view.GeoreferencingView;
import org.gvsig.raster.georeferencing.swing.view.IViewRequestManager;
import org.gvsig.raster.georeferencing.swing.view.SynchronizedViews;
import org.gvsig.raster.georeferencing.swing.view.ToolListener;
import org.gvsig.raster.georeferencing.swing.view.ViewListener;
import org.gvsig.raster.swing.basepanel.ButtonsPanelListener;
import org.gvsig.raster.swing.pagedtable.PagedTable;
import org.gvsig.raster.swing.pagedtable.PagedTableListener;

public class Georeferencing {
    public static final int UNDEFINED = -1;
    public static final int WITH_MAP = 0;
    public static final int WITHOUT_MAP = 1;
    public static int DEFAULT_DEGREE = 3;
    public static int ZOOM_RATIO = 5;
    private GeoreferencingSwingManager sManager = null;
    private GeoreferencingLauncher launcher = null;
    private GeoreferencingView viewRaster = null;
    private GeoreferencingView viewMap = null;
    private GeoreferencingView zoomMap = null;
    private GeoreferencingView zoomRaster = null;
    private ViewRasterRequestManager zoomRasterRequestManager = null;
    private ViewMapRequestManager zoomMapRequestManager = null;
    private ViewRasterRequestManager viewRasterRequestManager = null;
    private ViewMapRequestManager viewMapRequestManager = null;
    private GeorefControlPanel georefControlPanel = null;
    private TableWrapper table = null;
    private MapControl mapCtrl = null;
    private GeoreferencingOptionsDataModel dataModel = null;
    private SynchronizedViews syncViews = null;
    private ViewDialogListener listener = null;
    private GeoreferencingProcessActions processActions = null;
    private ApplicationControlsListener appControlsListener = null;
    private PointListListener pointListListener = null;
    public static boolean enableTableEvent = true;

    public void initialize() {
        this.sManager = GeoreferencingSwingLocator.getSwingManager();
        this.listener = new ViewDialogListener(this);
        this.processActions = new GeoreferencingProcessActions();
        this.launcher();
    }

    private void launcher() {
        ApplicationManager application = ApplicationLocator.getManager();
        List docs = application.getProjectManager().getCurrentProject().getDocuments();
        ArrayList<String> viewList = new ArrayList<String>();
        for (int i = 0; i < docs.size(); ++i) {
            Document doc = (Document)docs.get(i);
            if (!(doc instanceof ViewDocument)) continue;
            viewList.add(doc.getName());
        }
        this.launcher = this.sManager.createWindowLauncher(viewList, DEFAULT_DEGREE);
        LauncherDialogListener dialogListener = new LauncherDialogListener(this, this.launcher);
        this.launcher.setButtonsListener((ButtonsPanelListener)dialogListener);
        this.sManager.showWindow(this.launcher.getComponent(), 400, 380, Messages.getText((String)"georeferencing"));
    }

    public MapControl getMapCtrl() {
        if (this.mapCtrl == null) {
            IWindow[] windowList;
            for (IWindow windowList1 : windowList = PluginServices.getMDIManager().getAllWindows()) {
                String name;
                if (!(windowList1 instanceof IView) || !(name = ((IView)windowList1).getViewDocument().getName()).equals(this.dataModel.getSelectedView())) continue;
                this.mapCtrl = ((IView)windowList1).getMapControl();
            }
        }
        return this.mapCtrl;
    }

    public MapControl getFirstMapCtrl() {
        if (this.mapCtrl == null) {
            IWindow[] windowList;
            for (IWindow windowList1 : windowList = PluginServices.getMDIManager().getAllWindows()) {
                if (!(windowList1 instanceof IView)) continue;
                this.mapCtrl = ((IView)windowList1).getMapControl();
            }
        }
        return this.mapCtrl;
    }

    public void endLauncherDialog(GeoreferencingOptionsDataModel dataModel) {
        this.dataModel = dataModel;
        if (dataModel.getType() == 0) {
            this.initWindowsWithMap(dataModel);
        }
        if (dataModel.getType() == 1) {
            this.initWindowsWithoutMap(dataModel);
        }
        this.createAppControlsListener();
        this.createPointListListener();
        this.getSyncViews().enableTool(GeoreferencingSwingLibrary.PAN_TOOL);
        SwingUtilities.invokeLater(() -> this.initCartography());
    }

    public GeoreferencingView getViewRaster() {
        if (this.viewRaster == null) {
            this.viewRaster = this.sManager.createView(true, false, true, (ToolListener)this.listener);
            this.viewRasterRequestManager = new ViewRasterRequestManager(this.viewRaster, this.dataModel.getDataStore());
            this.viewRaster.setMinxMaxyUL(false);
            this.viewRaster.setViewListener((ViewListener)this.listener);
            this.viewRaster.setRequestListener((IViewRequestManager)this.viewRasterRequestManager);
            this.viewRaster.setListenerToTool(GeoreferencingSwingLibrary.SELECT_POINT_TOOL, (ToolListener)this.listener);
        }
        return this.viewRaster;
    }

    public GeoreferencingView getViewMap() {
        if (this.viewMap == null) {
            this.viewMap = this.sManager.createView(true, false, false, (ToolListener)this.listener);
            this.viewMap.setMinxMaxyUL(true);
            this.viewMapRequestManager = new ViewMapRequestManager(this.viewMap, this.getMapCtrl());
            this.viewMap.setViewListener((ViewListener)this.listener);
            this.viewMap.setRequestListener((IViewRequestManager)this.viewMapRequestManager);
            this.viewMap.setListenerToTool(GeoreferencingSwingLibrary.SELECT_POINT_TOOL, (ToolListener)this.listener);
        }
        return this.viewMap;
    }

    public GeoreferencingView getZoomMap() {
        if (this.zoomMap == null) {
            this.zoomMap = this.sManager.createZoom(true, false);
            this.zoomMap.setMinxMaxyUL(true);
            this.zoomMapRequestManager = new ViewMapRequestManager(this.zoomMap, this.getMapCtrl());
            this.zoomMap.setRequestListener((IViewRequestManager)this.zoomMapRequestManager);
            this.zoomMap.setListenerToTool(GeoreferencingSwingLibrary.SELECT_POINT_TOOL, (ToolListener)this.listener);
        }
        return this.zoomMap;
    }

    public GeoreferencingView getZoomRaster() {
        if (this.zoomRaster == null) {
            this.zoomRaster = this.sManager.createZoom(true, false);
            this.zoomRasterRequestManager = new ViewRasterRequestManager(this.zoomRaster, this.dataModel.getDataStore());
            this.zoomRaster.setMinxMaxyUL(false);
            this.zoomRaster.setRequestListener((IViewRequestManager)this.zoomRasterRequestManager);
            this.zoomRaster.setListenerToTool(GeoreferencingSwingLibrary.SELECT_POINT_TOOL, (ToolListener)this.listener);
        }
        return this.zoomRaster;
    }

    public TableWrapper getTableWrapper() {
        if (this.table == null) {
            this.table = new TableWrapper(this.getDataModel(), this.getGeorefControlPanel());
        }
        return this.table;
    }

    public void createAppControlsListener() {
        if (this.appControlsListener == null) {
            this.appControlsListener = new ApplicationControlsListener(this.getTableWrapper(), this);
            this.getTableWrapper().getPagedTable().addListener((PagedTableListener)this.appControlsListener);
        }
    }

    public void createPointListListener() {
        if (this.pointListListener == null) {
            this.pointListListener = new PointListListener(this);
        }
    }

    public void buildPointListFromDataStoreGCP() {
        GeoPointList geoPointList = this.getDataModel().getDataStore().getGeoPointList();
        if (geoPointList == null) {
            return;
        }
        this.buildPointListFromGeoPointListObject(geoPointList.clone());
    }

    public void buildPointListFromGeoPointListObject(GeoPointList geoPointList) {
        long id = System.currentTimeMillis();
        if (geoPointList == null) {
            return;
        }
        for (int i = 0; i < geoPointList.size(); ++i) {
            GeoPoint gp = (GeoPoint)geoPointList.get(i);
            gp.setNumber(i);
            GPGraphic graphicGCP = new GPGraphic(gp);
            graphicGCP.setId(id);
            this.getDataModel().getGCPList().add((Object)graphicGCP);
            this.getTableWrapper().getPagedTable().addRow(new Object[]{true, gp.getNumber(), gp.getMapPoint().getX(), gp.getMapPoint().getY(), gp.getPixelPoint().getX(), gp.getPixelPoint().getY(), gp.getErrorX(), gp.getErrorY(), gp.getRms(), id});
            ++id;
            if (i != geoPointList.size() - 1) continue;
            this.getDataModel().getGCPList().setSelectedPoint(i);
        }
        this.getTableWrapper().updateErrors();
        this.getSyncViews().redrawPoints();
    }

    private void initWindowsWithoutMap(GeoreferencingOptionsDataModel dataModel) {
        this.getDataModel().setType(1);
        this.viewRaster = this.getViewRaster();
        this.zoomRaster = this.getZoomRaster();
        PagedTable pt = this.getTableWrapper().getPagedTable();
        LayoutEnvironment layoutEnv = this.sManager.createLayoutEnvironment();
        layoutEnv.setTable((JPanel)pt.getComponent());
        layoutEnv.setViewRasterToGeoref(this.viewRaster.getComponent());
        layoutEnv.setViewZoomRasterToGeoref(this.zoomRaster.getComponent());
        layoutEnv.setControlBar(this.getGeorefControlPanel().getComponent());
        this.sManager.createLayout(layoutEnv);
        GeoreferencingView[] v = new GeoreferencingView[]{null, this.viewRaster, null, this.zoomRaster};
        IViewRequestManager[] rm = new IViewRequestManager[]{null, this.viewRasterRequestManager, null, this.zoomRasterRequestManager};
        this.syncViews = this.sManager.createSyncViews(v, rm, this.getGeorefControlPanel(), pt, (ToolListener)this.listener);
        this.getSyncViews().setGraphicsColor(this.getDataModel().getTextColor());
        this.getSyncViews().setBackgroundColor(this.getDataModel().getBackgroundColor());
        this.getSyncViews().setActiveNumberPoint(this.getDataModel().isShowNumber());
        try {
            this.viewRaster.setCursorSize(this.zoomRaster.getCanvasWidth() / ZOOM_RATIO, this.zoomRaster.getCanvasHeight() / ZOOM_RATIO);
            this.viewRaster.setCursorPosition(this.viewRaster.getCanvasWidth() / 2, this.viewRaster.getCanvasHeight() / 2);
        }
        catch (Exception e1) {
            GeoreferencingSwingImplLibrary.messageBoxError((String)"error_setview_preview", null, (Exception)e1);
            this.sManager.closeGeoreferencingPanel();
        }
        this.buildPointListFromDataStoreGCP();
    }

    private void initWindowsWithMap(GeoreferencingOptionsDataModel dataModel) {
        this.getDataModel().setType(0);
        this.viewRaster = this.getViewRaster();
        this.zoomRaster = this.getZoomRaster();
        this.viewMap = this.getViewMap();
        this.zoomMap = this.getZoomMap();
        PagedTable pt = this.getTableWrapper().getPagedTable();
        LayoutEnvironment layoutEnv = this.sManager.createLayoutEnvironment();
        layoutEnv.setTable((JPanel)pt.getComponent());
        layoutEnv.setViewRasterToGeoref(this.viewRaster.getComponent());
        layoutEnv.setViewZoomRasterToGeoref(this.zoomRaster.getComponent());
        layoutEnv.setViewBaseCartography(this.viewMap.getComponent());
        layoutEnv.setViewZoomBaseCartography(this.zoomMap.getComponent());
        layoutEnv.setControlBar(this.getGeorefControlPanel().getComponent());
        this.sManager.createLayout(layoutEnv);
        GeoreferencingView[] v = new GeoreferencingView[]{this.viewMap, this.viewRaster, this.zoomMap, this.zoomRaster};
        IViewRequestManager[] rm = new IViewRequestManager[]{this.viewMapRequestManager, this.viewRasterRequestManager, this.zoomMapRequestManager, this.zoomRasterRequestManager};
        this.syncViews = this.sManager.createSyncViews(v, rm, this.getGeorefControlPanel(), pt, (ToolListener)this.listener);
        this.getSyncViews().setGraphicsColor(this.getDataModel().getTextColor());
        this.getSyncViews().setBackgroundColor(this.getDataModel().getBackgroundColor());
        this.getSyncViews().setActiveNumberPoint(this.getDataModel().isShowNumber());
        this.getDataModel().setType(0);
        try {
            this.viewMap.setCursorSize(this.zoomMap.getCanvasWidth() / ZOOM_RATIO, this.zoomMap.getCanvasHeight() / ZOOM_RATIO);
            this.viewRaster.setCursorSize(this.zoomRaster.getCanvasWidth() / ZOOM_RATIO, this.zoomRaster.getCanvasHeight() / ZOOM_RATIO);
            this.viewMap.setCursorPosition(this.viewMap.getCanvasWidth() / 2, this.viewMap.getCanvasHeight() / 2);
            this.viewRaster.setCursorPosition(this.viewRaster.getCanvasWidth() / 2, this.viewRaster.getCanvasHeight() / 2);
            if (this.getMapCtrl().getMapContext().getLayers().getFullEnvelope() == null) {
                GeoreferencingSwingImplLibrary.messageBoxError((String)"error_setview_preview", null);
            }
            this.processActions.setViewMapRequest(this.viewMapRequestManager);
        }
        catch (Exception e1) {
            GeoreferencingSwingImplLibrary.messageBoxError((String)"error_setview_preview", (Object)this, (Exception)e1);
            this.sManager.closeGeoreferencingPanel();
        }
        this.buildPointListFromDataStoreGCP();
    }

    private void initCartography() {
        try {
            if (this.getDataModel().getType() == 0) {
                Envelope e = this.getMapCtrl().getViewPort().getAdjustedEnvelope();
                Extent extent = RasterLocator.getManager().getDataStructFactory().createExtent(e.getMinimum(0), e.getMaximum(1), e.getMaximum(0), e.getMinimum(1));
                this.viewMapRequestManager.initRequest(extent);
            }
            this.viewRasterRequestManager.initRequest(this.dataModel.getRasterExtent());
        }
        catch (InvalidRequestException e1) {
            GeoreferencingSwingImplLibrary.messageBoxError((String)"error_setview_preview", null, (Exception)((Object)e1));
            this.sManager.closeGeoreferencingPanel();
        }
    }

    public ViewRasterRequestManager getZoomRasterRequestManager() {
        return this.zoomRasterRequestManager;
    }

    public ViewMapRequestManager getZoomMapRequestManager() {
        return this.zoomMapRequestManager;
    }

    public GeorefControlPanel getGeorefControlPanel() {
        if (this.georefControlPanel == null) {
            this.georefControlPanel = this.sManager.createGeorefControlPanel();
        }
        return this.georefControlPanel;
    }

    public SynchronizedViews getSyncViews() {
        return this.syncViews;
    }

    public GeoreferencingProcessActions getProcessActions() {
        return this.processActions;
    }

    public GeoreferencingOptionsDataModel getDataModel() {
        return GeoreferencingSwingLocator.getSwingManager().getDataModel();
    }

    public void actionCanceled(IncrementableEvent e) {
    }

    public void actionResumed(IncrementableEvent e) {
    }

    public void actionSuspended(IncrementableEvent e) {
    }
}

