/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.georeferencing.app.georeferencingclient.listener;

import java.awt.event.ActionEvent;
import java.awt.geom.Point2D;
import javax.swing.JPanel;
import org.gvsig.andami.PluginServices;
import org.gvsig.fmap.dal.coverage.datastruct.GeoPoint;
import org.gvsig.fmap.dal.coverage.exception.RmfSerializerException;
import org.gvsig.fmap.dal.coverage.store.RasterDataStore;
import org.gvsig.fmap.mapcontext.exceptions.LoadLayerException;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.FLayers;
import org.gvsig.i18n.Messages;
import org.gvsig.raster.georeferencing.app.georeferencingclient.GeoPointsPersistence;
import org.gvsig.raster.georeferencing.app.georeferencingclient.Georeferencing;
import org.gvsig.raster.georeferencing.app.georeferencingclient.TableWrapper;
import org.gvsig.raster.georeferencing.swing.GeoreferencingSwingLibrary;
import org.gvsig.raster.georeferencing.swing.GeoreferencingSwingLocator;
import org.gvsig.raster.georeferencing.swing.GeoreferencingSwingManager;
import org.gvsig.raster.georeferencing.swing.control.GeorefControlPanel;
import org.gvsig.raster.georeferencing.swing.control.GeorefControlPanelListener;
import org.gvsig.raster.georeferencing.swing.impl.option.GeorefOptionsDialog;
import org.gvsig.raster.georeferencing.swing.model.GeoreferencingOptionsDataModel;
import org.gvsig.raster.georeferencing.swing.view.SynchronizedViews;
import org.gvsig.raster.swing.RasterSwingLibrary;
import org.gvsig.raster.swing.basepanel.ButtonsPanelEvent;
import org.gvsig.raster.swing.basepanel.ButtonsPanelListener;
import org.gvsig.raster.swing.pagedtable.PagedTableEvent;

public class ApplicationControlsListener
implements GeorefControlPanelListener {
    private TableWrapper tableWrapper = null;
    private Georeferencing appMain = null;
    private GeorefControlPanel controlPanel = null;
    private GeorefOptionsDialog optionsDialog = null;
    private GeoreferencingSwingManager sManager = null;
    private GeoPointsPersistence persistence = null;
    private JPanel cellSizePanel = null;
    private boolean newPointCreated = false;

    public ApplicationControlsListener(TableWrapper tableWrapper, Georeferencing appMain) {
        this.tableWrapper = tableWrapper;
        this.appMain = appMain;
        this.controlPanel = appMain.getGeorefControlPanel();
        this.controlPanel.setListener((GeorefControlPanelListener)this);
        this.sManager = GeoreferencingSwingLocator.getSwingManager();
        this.persistence = new GeoPointsPersistence(appMain.getDataModel());
    }

    private SynchronizedViews getSyncViews() {
        return this.appMain.getSyncViews();
    }

    private GeoreferencingOptionsDataModel getDataModel() {
        return this.appMain.getDataModel();
    }

    public void actionPerformed(ActionEvent e) {
        if (!Georeferencing.enableTableEvent) {
            return;
        }
        Georeferencing.enableTableEvent = false;
        try {
            if (this.controlPanel.getButtonIDPressed(e.getSource()) == 7) {
                this.endGeoref();
            }
            if (this.controlPanel.getButtonIDPressed(e.getSource()) == 8) {
                this.getSyncViews().centerToPoint(this.tableWrapper.getPagedTable().getSelectedRows()[0]);
            }
            if (e.getActionCommand().equals("SELECT_ROW")) {
                if (this.getDataModel().isCenterView() && !this.newPointCreated) {
                    this.getSyncViews().centerToPoint(e.getID());
                }
                this.newPointCreated = false;
            }
            if (this.controlPanel.getButtonIDPressed(e.getSource()) == 4) {
                if (this.optionsDialog == null) {
                    this.optionsDialog = new GeorefOptionsDialog(Georeferencing.DEFAULT_DEGREE, (ButtonsPanelListener)this);
                }
                this.optionsDialog.setDegree(this.getDataModel().getDegree());
                this.optionsDialog.setAlgorithm(this.getDataModel().getAlgorithm());
                this.optionsDialog.setBackGroundColor(this.getDataModel().getBackgroundColor());
                this.optionsDialog.setTextColor(this.getDataModel().getTextColor());
                this.optionsDialog.getOptionsPanel((ButtonsPanelListener)this).getCheckOptionsPanel().getAddErrorsCSVCheck().setSelected(this.getDataModel().isAddErrorsCSV());
                this.optionsDialog.getOptionsPanel((ButtonsPanelListener)this).getCheckOptionsPanel().getCenterViewCheck().setSelected(this.getDataModel().isCenterView());
                this.optionsDialog.getOptionsPanel((ButtonsPanelListener)this).getCheckOptionsPanel().getShowNumberCheck().setSelected(this.getDataModel().isShowNumber());
                this.optionsDialog.setThresholdError(this.getDataModel().getThreshold());
                this.optionsDialog.setInterpolationMethod(this.getDataModel().getInterpolationMethod());
                this.optionsDialog.setOutFile(this.getDataModel().getOutFile());
                this.sManager.showWindow((JPanel)this.optionsDialog, 410, 400, Messages.getText((String)"georeferencing"));
            }
            if (e.getSource() == this.appMain.getGeorefControlPanel().getMovePointButton() && this.getSyncViews() != null) {
                if (this.appMain.getGeorefControlPanel().getMovePointButton().isSelected()) {
                    this.getSyncViews().disableAllTools();
                    this.getSyncViews().enableTool(GeoreferencingSwingLibrary.SELECT_POINT_TOOL);
                } else {
                    this.getSyncViews().disableTool(GeoreferencingSwingLibrary.SELECT_POINT_TOOL);
                }
            }
            if (e.getSource() == this.appMain.getGeorefControlPanel().getDragPointButton() && this.getSyncViews() != null) {
                if (this.appMain.getGeorefControlPanel().getDragPointButton().isSelected()) {
                    this.getSyncViews().disableAllTools();
                    this.getSyncViews().enableTool(GeoreferencingSwingLibrary.DRAG_POINT_TOOL);
                } else {
                    this.getSyncViews().disableTool(GeoreferencingSwingLibrary.DRAG_POINT_TOOL);
                }
            }
            if (this.controlPanel.getButtonIDPressed(e.getSource()) == 5) {
                this.cellSizePanel = GeoreferencingSwingLocator.getSwingManager().createCellSizeWindow((ButtonsPanelListener)this);
                if (this.getDataModel().getAlgorithm() == 1) {
                    this.cellSizePanel.setEnabled(false);
                } else {
                    this.cellSizePanel.setEnabled(true);
                }
                this.sManager.showWindow(this.cellSizePanel, 280, 180, Messages.getText((String)"cellsize"));
            }
            if (this.controlPanel.getButtonIDPressed(e.getSource()) == 6) {
                if (this.getDataModel().getType() == 0) {
                    if (this.appMain != null && this.appMain.getProcessActions().getLastTestLayer() != null) {
                        this.appMain.getProcessActions().removeTestRasterLayer();
                    }
                } else {
                    RasterSwingLibrary.messageBoxInfo((String)"action_disable_without_view", null);
                }
            }
            if (this.controlPanel.getButtonIDPressed(e.getSource()) == 2) {
                this.persistence.exportToCSV(this.getDataModel().getGCPList(), this.getDataModel().isAddErrorsCSV());
            }
            if (this.controlPanel.getButtonIDPressed(e.getSource()) == 3) {
                this.persistence.importFromCSV(this.getSyncViews(), this.tableWrapper);
            }
            if (this.controlPanel.getButtonIDPressed(e.getSource()) == 0) {
                this.persistence.saveToRMF(this.getDataModel().getGCPList(), this.getDataModel().getDataStore());
            }
            if (this.controlPanel.getButtonIDPressed(e.getSource()) == 1) {
                this.persistence.loadFromRMF(this.getSyncViews(), this.tableWrapper);
            }
        }
        finally {
            Georeferencing.enableTableEvent = true;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void endGeoref() {
        block21: {
            boolean saveTransform;
            block20: {
                block22: {
                    if (!RasterSwingLibrary.messageBoxYesOrNot((String)"ask_end_georef", null)) break block21;
                    saveTransform = false;
                    if (this.getDataModel().getAlgorithm() == 1) {
                        if (!RasterSwingLibrary.messageBoxYesOrNot((String)"ask_save_transformation", null)) {
                            this.appMain.getProcessActions().removeTestRasterLayer();
                            this.sManager.closeGeoreferencingPanel();
                            return;
                        }
                        saveTransform = true;
                    }
                    if (this.getDataModel().getType() == 0 && this.appMain.getProcessActions().getLastTestLayer() != null) {
                        this.appMain.getProcessActions().getLastTestLayer().setRemoveRasterFlag(false);
                    }
                    if (this.appMain.getProcessActions().getLastTestLayer() == null || !RasterSwingLibrary.messageBoxYesOrNot((String)(Messages.getText((String)"ask_load_view") + " " + this.appMain.getProcessActions().getLastTestLayer().getURI()), null)) break block22;
                    FLayers lyrs = null;
                    if (this.appMain.getMapCtrl() != null && (lyrs = this.appMain.getMapCtrl().getMapContext().getLayers()) != null) {
                        try {
                            if (this.appMain.getProcessActions().getLastTestLayer() != null) {
                                lyrs.removeLayer((FLayer)this.appMain.getProcessActions().getLastTestLayer());
                                PluginServices.getMainFrame().enableControls();
                            }
                        }
                        catch (NullPointerException nullPointerException) {
                            // empty catch block
                        }
                    }
                    if (this.getDataModel().getAlgorithm() == 1) {
                        try {
                            this.appMain.getProcessActions().addTestRasterLayer(this.getDataModel().getDataStore(), this.getDataModel().getAlgorithm(), this.getDataModel().getInterpolationMethod(), this.getDataModel().getDegree(), this.getDataModel().getOutFile(), this.getDataModel().getXCellSize(), this.getDataModel().getYCellSize(), this.tableWrapper.getGeoTransformDataResult(), this.appMain.getMapCtrl().getProjection());
                        }
                        catch (LoadLayerException e) {
                            RasterSwingLibrary.messageBoxError((String)"error_loading_layer", null, (Exception)((Object)e));
                        }
                    }
                    if (this.getDataModel().getAlgorithm() == 0) {
                        if (this.appMain.getProcessActions().getLastTestLayer() == null) {
                            RasterSwingLibrary.messageBoxInfo((String)"raster_not_created", null);
                            return;
                        }
                        if (this.appMain.getMapCtrl() != null) {
                            this.appMain.getMapCtrl().getMapContext().getLayers().addLayer((FLayer)this.appMain.getProcessActions().getLastTestLayer());
                            break block20;
                        } else {
                            this.appMain.getFirstMapCtrl().getMapContext().getLayers().addLayer((FLayer)this.appMain.getProcessActions().getLastTestLayer());
                        }
                    }
                    break block20;
                }
                this.appMain.getProcessActions().removeTestRasterLayer();
            }
            if (saveTransform) {
                if (this.appMain.getProcessActions().getLastTestLayer() == null) {
                    RasterSwingLibrary.messageBoxInfo((String)"raster_not_created", null);
                    return;
                }
                RasterDataStore store = this.appMain.getProcessActions().getLastTestLayer().getDataStore();
                try {
                    store.setProjection(this.appMain.getMapCtrl().getProjection(), true);
                }
                catch (Exception e) {
                    RasterSwingLibrary.messageBoxError((String)"_Cant_assign_the_projection", null, (Exception)e);
                }
                try {
                    store.saveGeoreferencingToRmf();
                }
                catch (RmfSerializerException e) {
                    RasterSwingLibrary.messageBoxError((String)"error_salvando_rmf", null, (Exception)((Object)e));
                }
            }
            this.sManager.closeGeoreferencingPanel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tableChanged(PagedTableEvent e) {
        if (!Georeferencing.enableTableEvent) {
            return;
        }
        Georeferencing.enableTableEvent = false;
        try {
            if (e.getEvent() == PagedTableEvent.EVENT_ADD_ENTRY) {
                long id = this.getSyncViews().addPoint((Point2D)new Point2D.Double(0.0, 0.0), (Point2D)new Point2D.Double(0.0, 0.0));
                this.tableWrapper.initializeRow(e.getRows()[0], id);
                this.getSyncViews().synchronizeTablePointsNumerationWithGCPList();
                if (this.getSyncViews() != null) {
                    this.getSyncViews().disableAllTools();
                    this.getSyncViews().enableTool(GeoreferencingSwingLibrary.SELECT_POINT_TOOL);
                }
                this.newPointCreated = true;
            }
            if (e.getEvent() == PagedTableEvent.EVENT_REMOVE_ENTRY) {
                Object obj = ((Object[])e.getRowDeleted())[1];
                int n = (Integer)obj;
                this.appMain.getSyncViews().removePoint(n);
                this.getSyncViews().synchronizeTablePointsNumerationWithGCPList();
                this.tableWrapper.updateErrors();
            }
            if (e.getEvent() == PagedTableEvent.EVENT_REMOVE_ALL) {
                this.getSyncViews().removeAllPoints();
            }
            if (e.getEvent() == PagedTableEvent.EVENT_MODIFY_ENTRY) {
                this.getSyncViews().synchronizeTablePointsNumerationWithGCPList();
                for (int i = 0; i < this.tableWrapper.getPagedTable().getRowCount(); ++i) {
                    boolean active = (Boolean)this.tableWrapper.getPagedTable().getValueAt(i, 0);
                    int position = this.appMain.getSyncViews().getPointPositionByNumber(i);
                    if (position < 0) {
                        return;
                    }
                    GeoPoint pt = this.getDataModel().getGCPList().getGeoPoint(position);
                    pt.setActive(active);
                    this.getSyncViews().setVisiblePoint(active, position);
                    double[] values = this.tableWrapper.getCoordinatesByTableRow(i);
                    this.getSyncViews().setCoordinates(position, values[0], values[1], values[2], values[3]);
                }
                this.tableWrapper.updateErrors();
            }
            if (e.getEvent() == PagedTableEvent.EVENT_SELECTED_ROWS) {
                if (this.getDataModel().isCenterView()) {
                    this.getSyncViews().centerToPoint(this.tableWrapper.getPagedTable().getSelectedRows()[0]);
                }
                this.getDataModel().getGCPList().setSelectedPoint(this.tableWrapper.getPagedTable().getSelectedRows()[0]);
                this.getSyncViews().redrawPoints();
            }
            if (e.getEvent() == PagedTableEvent.EVENT_SWAP_ENTRIES) {
                this.getSyncViews().synchronizeTablePointsNumerationWithGCPList();
            }
            this.tableWrapper.updateTableEntryColor();
        }
        finally {
            Georeferencing.enableTableEvent = true;
        }
    }

    public void actionButtonPressed(ButtonsPanelEvent e) {
        block14: {
            Georeferencing.enableTableEvent = false;
            try {
                if (this.cellSizePanel != null && e.getSource() == this.cellSizePanel) {
                    if (e.getButton() == 1 && this.cellSizePanel != null) {
                        try {
                            if (this.appMain.getProcessActions().getLastTestLayer() != null) {
                                this.appMain.getProcessActions().removeTestRasterLayer();
                            }
                            this.appMain.getProcessActions().addTestRasterLayer(this.getDataModel().getDataStore(), this.getDataModel().getAlgorithm(), this.getDataModel().getInterpolationMethod(), this.getDataModel().getDegree(), this.getDataModel().getOutFile(), this.getDataModel().getXCellSize(), this.getDataModel().getYCellSize(), this.tableWrapper.getGeoTransformDataResult(), this.appMain.getMapCtrl().getProjection());
                        }
                        catch (LoadLayerException e1) {
                            RasterSwingLibrary.messageBoxError((String)"error_loading_layer", (Object)this.tableWrapper.getPagedTable(), (Exception)((Object)e1));
                        }
                    }
                    if ((e.getButton() == 2 || e.getButton() == 1) && this.cellSizePanel != null) {
                        this.sManager.closeWindow(this.cellSizePanel);
                    }
                }
                if (this.optionsDialog == null || this.optionsDialog.getOptionsPanel(null) == null || e.getSource() != this.optionsDialog.getOptionsPanel(null)) break block14;
                if ((e.getButton() == 3 || e.getButton() == 1) && this.optionsDialog != null) {
                    this.getDataModel().setAlgorithm(this.optionsDialog.getAlgorithm());
                    this.getDataModel().setBackGroundColor(this.optionsDialog.getBackGroundColor());
                    this.getDataModel().setTextColor(this.optionsDialog.getTextColor());
                    this.getDataModel().setAddErrorsCSV(this.optionsDialog.getOptionsPanel((ButtonsPanelListener)this).getCheckOptionsPanel().getAddErrorsCSVCheck().isSelected());
                    this.getDataModel().setCenterView(this.optionsDialog.getOptionsPanel((ButtonsPanelListener)this).getCheckOptionsPanel().getCenterViewCheck().isSelected());
                    this.getDataModel().setShowNumber(this.optionsDialog.getOptionsPanel((ButtonsPanelListener)this).getCheckOptionsPanel().getShowNumberCheck().isSelected());
                    this.getDataModel().setInterpolationMethod(this.optionsDialog.getInterpolationMethod());
                    this.getDataModel().setOutFile(this.optionsDialog.getOptionsPanel((ButtonsPanelListener)this).getOutFileSelectionPanel().getOutFile());
                    if (this.optionsDialog.getDegree() != this.getDataModel().getDegree()) {
                        this.getDataModel().setDegree(this.optionsDialog.getDegree());
                        this.tableWrapper.updateErrors();
                    }
                    try {
                        this.getDataModel().setThreshold(this.optionsDialog.getThresholdError());
                    }
                    catch (NumberFormatException exc) {
                        RasterSwingLibrary.messageBoxError((String)"error_numeric_format", null, (Exception)exc);
                    }
                    this.getSyncViews().setGraphicsColor(this.getDataModel().getTextColor());
                    this.getSyncViews().setBackgroundColor(this.getDataModel().getBackgroundColor());
                    this.getSyncViews().setActiveNumberPoint(this.getDataModel().isShowNumber());
                }
                if ((e.getButton() == 2 || e.getButton() == 1) && this.optionsDialog != null) {
                    this.sManager.closeWindow((JPanel)this.optionsDialog);
                }
            }
            finally {
                Georeferencing.enableTableEvent = true;
            }
        }
    }
}

