/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.georeferencing.app.georeferencingclient.listener;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.datastruct.Extent;
import org.gvsig.fmap.dal.coverage.datastruct.GeoPoint;
import org.gvsig.raster.georeferencing.app.georeferencingclient.Georeferencing;
import org.gvsig.raster.georeferencing.swing.GeoreferencingSwingLibrary;
import org.gvsig.raster.georeferencing.swing.exception.InvalidRequestException;
import org.gvsig.raster.georeferencing.swing.impl.GeoreferencingSwingImplLibrary;
import org.gvsig.raster.georeferencing.swing.impl.layer.GCPsGraphicLayer;
import org.gvsig.raster.georeferencing.swing.impl.layer.GPGraphic;
import org.gvsig.raster.georeferencing.swing.impl.layer.ZoomCursorGraphicLayer;
import org.gvsig.raster.georeferencing.swing.impl.tool.PanTool;
import org.gvsig.raster.georeferencing.swing.impl.tool.SelectCoordOnViewTool;
import org.gvsig.raster.georeferencing.swing.impl.tool.ZoomRectangleTool;
import org.gvsig.raster.georeferencing.swing.view.ToolEvent;
import org.gvsig.raster.georeferencing.swing.view.ToolListener;
import org.gvsig.raster.georeferencing.swing.view.ViewEvent;
import org.gvsig.raster.georeferencing.swing.view.ViewListener;
import org.gvsig.raster.swing.RasterSwingLibrary;

public class ViewDialogListener
implements ViewListener,
ToolListener {
    private Georeferencing app = null;

    public ViewDialogListener(Georeferencing app) {
        this.app = app;
    }

    public void addingTool(ViewEvent ev) {
    }

    public void endDraw(ViewEvent ev) {
    }

    public void startDraw(ViewEvent ev) {
    }

    public void zoomViewChanged(ViewEvent ev) {
        Rectangle2D ext = null;
        try {
            Extent request;
            if (this.app.getZoomRasterRequestManager() != null) {
                ext = this.app.getViewRaster().getCursorAdjustedWorldCoordinates(this.app.getZoomRaster().getCanvasWidth(), this.app.getZoomRaster().getCanvasHeight());
                request = RasterLocator.getManager().getDataStructFactory().createExtent(ext);
                this.app.getZoomRasterRequestManager().request(request, null);
            }
            if (this.app.getDataModel().getType() == 0 && this.app.getZoomMapRequestManager() != null) {
                ext = this.app.getViewMap().getCursorAdjustedWorldCoordinates(this.app.getZoomMap().getCanvasWidth(), this.app.getZoomMap().getCanvasHeight());
                request = RasterLocator.getManager().getDataStructFactory().createExtent(ext);
                this.app.getZoomMapRequestManager().request(request, null);
            }
        }
        catch (InvalidRequestException ex) {
            GeoreferencingSwingImplLibrary.messageBoxError((String)"error_set_view", null, (Exception)((Object)ex));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endAction(ToolEvent ev) {
        block21: {
            if (!Georeferencing.enableTableEvent) {
                return;
            }
            Georeferencing.enableTableEvent = false;
            try {
                if (ev.getSource() instanceof ZoomCursorGraphicLayer) {
                    try {
                        Extent request;
                        Rectangle2D ext = null;
                        if (this.app.getViewRaster() != null) {
                            ext = this.app.getViewRaster().getCursorAdjustedWorldCoordinates(this.app.getZoomRaster().getCanvasWidth(), this.app.getZoomRaster().getCanvasHeight());
                            request = RasterLocator.getManager().getDataStructFactory().createExtent(ext);
                            this.app.getZoomRasterRequestManager().request(request, ev.getCancellable());
                        }
                        if (this.app.getViewMap() != null) {
                            ext = this.app.getViewMap().getCursorAdjustedWorldCoordinates(this.app.getZoomMap().getCanvasWidth(), this.app.getZoomMap().getCanvasHeight());
                            request = RasterLocator.getManager().getDataStructFactory().createExtent(ext);
                            this.app.getZoomMapRequestManager().request(request, ev.getCancellable());
                        }
                    }
                    catch (InvalidRequestException e1) {
                        GeoreferencingSwingImplLibrary.messageBoxError((String)"error_setview_preview", null, (Exception)((Object)e1));
                    }
                }
                if (ev.getSource() instanceof GCPsGraphicLayer) {
                    if (this.app.getSyncViews() != null) {
                        this.app.getSyncViews().redrawPoints();
                    }
                    GPGraphic gPoint = ((GCPsGraphicLayer)ev.getSource()).getLastPoint();
                    Point2D pRaster = gPoint.getGeoPoint().getPixelPoint();
                    Point2D pMap = gPoint.getGeoPoint().getMapPoint();
                    try {
                        this.app.getTableWrapper().updatePoint(new Double(pMap.getX()), new Double(pMap.getY()), new Double(pRaster.getX()), new Double(pRaster.getY()), gPoint.getGeoPoint().getNumber());
                        this.app.getTableWrapper().getPagedTable().setSelectedRow(gPoint.getGeoPoint().getNumber());
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        RasterSwingLibrary.messageBoxError((String)"no_rows_selected", (Object)this.app.getTableWrapper().getPagedTable(), (Exception)e);
                    }
                    if (this.app.getDataModel().isCenterView()) {
                        this.app.getSyncViews().centerToPoint(gPoint.getGeoPoint().getNumber());
                    }
                }
                if (!(ev.getSource() instanceof SelectCoordOnViewTool)) break block21;
                try {
                    Point2D[] p;
                    int nPoint = this.app.getDataModel().getGCPList().getSelectedPoint();
                    GeoPoint gp = this.app.getSyncViews().getPointByNumber(nPoint);
                    if (((SelectCoordOnViewTool)ev.getSource()).getParentView() == this.app.getViewRaster() || ((SelectCoordOnViewTool)ev.getSource()).getParentView() == this.app.getZoomRaster()) {
                        p = (Point2D[])((SelectCoordOnViewTool)ev.getSource()).getResult();
                        if (gp != null) {
                            gp.setPixelPoint(p[1]);
                            this.app.getTableWrapper().updateRasterPoint(new Double(p[1].getX()), new Double(p[1].getY()), nPoint);
                            this.app.getSyncViews().redrawPoints();
                        }
                    }
                    if (((SelectCoordOnViewTool)ev.getSource()).getParentView() == this.app.getViewMap() || ((SelectCoordOnViewTool)ev.getSource()).getParentView() == this.app.getZoomMap()) {
                        p = (Point2D[])((SelectCoordOnViewTool)ev.getSource()).getResult();
                        if (gp != null) {
                            gp.setMapPoint(p[1]);
                            this.app.getTableWrapper().updateMapPoint(new Double(p[1].getX()), new Double(p[1].getY()), nPoint);
                            this.app.getSyncViews().redrawPoints();
                        }
                    }
                    if (this.app.getDataModel().isCenterView()) {
                        this.app.getSyncViews().centerToPoint(nPoint);
                    }
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    RasterSwingLibrary.messageBoxError((String)"no_rows_selected", (Object)this.app.getTableWrapper().getPagedTable(), (Exception)e);
                }
            }
            finally {
                Georeferencing.enableTableEvent = true;
            }
        }
    }

    public void offTool(ToolEvent ev) {
        if (!Georeferencing.enableTableEvent) {
            return;
        }
        Georeferencing.enableTableEvent = false;
        try {
            if (ev.getSource() instanceof ZoomCursorGraphicLayer) {
                this.app.getSyncViews().awakeActiveTools();
                return;
            }
            if (ev.getSource() instanceof PanTool && ev.getParentView() != null) {
                ev.getParentView().disableTool(GeoreferencingSwingLibrary.PAN_TOOL);
            }
            if (ev.getSource() instanceof ZoomRectangleTool && ev.getParentView() != null) {
                ev.getParentView().disableTool(GeoreferencingSwingLibrary.ZOOM_RECTANGLE_TOOL);
            }
            if (ev.getSource() instanceof SelectCoordOnViewTool && this.app.getSyncViews() != null) {
                this.app.getSyncViews().disableTool(GeoreferencingSwingLibrary.MOVE_POINT_TOOL);
            }
        }
        finally {
            Georeferencing.enableTableEvent = true;
        }
    }

    public void onTool(ToolEvent ev) {
        if (!Georeferencing.enableTableEvent) {
            return;
        }
        Georeferencing.enableTableEvent = false;
        try {
            if (ev.getSource() instanceof ZoomCursorGraphicLayer) {
                this.app.getSyncViews().sleepActiveTools();
                return;
            }
            if (ev.getSource() instanceof PanTool) {
                if (ev.getParentView() != null) {
                    ev.getParentView().disableTool(GeoreferencingSwingLibrary.ZOOM_RECTANGLE_TOOL);
                }
                if (this.app.getSyncViews() != null) {
                    this.app.getSyncViews().disableTool(GeoreferencingSwingLibrary.MOVE_POINT_TOOL);
                    this.app.getSyncViews().disableTool(GeoreferencingSwingLibrary.DRAG_POINT_TOOL);
                }
            }
            if (ev.getSource() instanceof ZoomRectangleTool) {
                if (ev.getParentView() != null) {
                    ev.getParentView().disableTool(GeoreferencingSwingLibrary.PAN_TOOL);
                }
                if (this.app.getSyncViews() != null) {
                    this.app.getSyncViews().disableTool(GeoreferencingSwingLibrary.MOVE_POINT_TOOL);
                    this.app.getSyncViews().disableTool(GeoreferencingSwingLibrary.DRAG_POINT_TOOL);
                }
            }
            if (ev.getSource() instanceof SelectCoordOnViewTool) {
                if (ev.getParentView() != null) {
                    ev.getParentView().disableAllTools();
                }
                if (this.app.getSyncViews() != null) {
                    this.app.getSyncViews().disableTool(GeoreferencingSwingLibrary.DRAG_POINT_TOOL);
                }
            }
        }
        finally {
            Georeferencing.enableTableEvent = true;
        }
    }
}

