/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.sldsupport.impl.sld.parsing;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gvsig.sldsupport.exception.InvalidSLDObjectException;
import org.gvsig.sldsupport.exception.SLDReadException;
import org.gvsig.sldsupport.exception.UnsupportedSLDObjectException;
import org.gvsig.sldsupport.impl.sld.parsing.RuleElement;
import org.gvsig.sldsupport.impl.util.SLDUtils;
import org.gvsig.sldsupport.impl.util.XmlBuilder;
import org.gvsig.sldsupport.sld.rule.SLDRule;
import org.gvsig.sldsupport.sld.style.SLDFeatureStyle;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class FeatureStyleElement {
    public static void append(SLDFeatureStyle obj, XmlBuilder xb, Map<String, String> atts) throws InvalidSLDObjectException, UnsupportedSLDObjectException {
        String v = obj.getVersion();
        if (v == null) {
            v = "1.0.0";
        }
        if (v.compareToIgnoreCase("1.1.0") == 0) {
            FeatureStyleElement.appendv110(obj, xb);
        } else {
            FeatureStyleElement.appendv100(obj, xb);
        }
    }

    private static void appendv100(SLDFeatureStyle obj, XmlBuilder xb) throws InvalidSLDObjectException, UnsupportedSLDObjectException {
        if (obj.getVersion() != null) {
            HashMap<String, String> atts = new HashMap<String, String>();
            atts.put("version", obj.getVersion());
            xb.openTag("FeatureTypeStyle", atts);
        } else {
            xb.openTag("FeatureTypeStyle");
        }
        if (obj.getName() != null) {
            xb.writeTag("Name", obj.getName());
        }
        if (obj.getTitle() != null) {
            xb.writeTag("Title", obj.getTitle());
        }
        if (obj.getDescription() != null) {
            xb.writeTag("Abstract", obj.getDescription());
        }
        if (obj.getFeatureTypeName() != null) {
            xb.writeTag("FeatureTypeName", obj.getFeatureTypeName());
        }
        List list = obj.getSemanticTypeIdentifiers();
        for (int i = 0; i < list.size(); ++i) {
            xb.writeTag("SemanticTypeIdentifier", (String)list.get(i));
        }
        List rules = obj.getRules();
        if (rules == null || rules.size() == 0) {
            throw new InvalidSLDObjectException("FeatureTypeStyle", "No rules found");
        }
        for (int i = 0; i < rules.size(); ++i) {
            RuleElement.append((SLDRule)rules.get(i), xb, "1.0.0");
        }
        xb.closeTag();
    }

    private static void appendv110(SLDFeatureStyle obj, XmlBuilder xb) throws InvalidSLDObjectException, UnsupportedSLDObjectException {
        if (obj.getVersion() != null) {
            HashMap<String, String> atts = new HashMap<String, String>();
            atts.put("version", obj.getVersion());
            xb.openTag("FeatureStyle", atts);
        } else {
            xb.openTag("FeatureStyle");
        }
        if (obj.getName() != null) {
            xb.writeTag("Name", obj.getName());
        }
        if (obj.getDescription() != null) {
            xb.writeTag("Description", obj.getDescription());
        }
        if (obj.getFeatureTypeName() == null) {
            throw new InvalidSLDObjectException("FeatureStyle", "FeatureTypeName is mandatory in version 1.1.0");
        }
        xb.writeTag("FeatureTypeName", obj.getFeatureTypeName());
        List list = obj.getSemanticTypeIdentifiers();
        for (int i = 0; i < list.size(); ++i) {
            xb.writeTag("SemanticTypeIdentifier", (String)list.get(i));
        }
        List rules = obj.getRules();
        if (rules == null || rules.size() == 0) {
            throw new InvalidSLDObjectException("FeatureStyle", "No rules found");
        }
        for (int i = 0; i < rules.size(); ++i) {
            RuleElement.append((SLDRule)rules.get(i), xb, "1.0.0");
        }
        xb.closeTag();
    }

    public static SLDFeatureStyle parse(XmlPullParser parser, String version) throws XmlPullParserException, IOException, SLDReadException {
        String ent_name = parser.getName();
        if (!SLDUtils.isStr(ent_name, "FeatureStyle") && !SLDUtils.isStr(ent_name, "FeatureTypeStyle")) {
            throw new SLDReadException("Bad opening tag: " + ent_name);
        }
        String txt = null;
        int tag = 0;
        SLDFeatureStyle resp = new SLDFeatureStyle();
        if (SLDUtils.isStr(ent_name, "FeatureStyle")) {
            txt = parser.getAttributeValue(null, "version");
            if (txt == null) {
                throw new SLDReadException("The 'version' attribute is mandatory in FeatureStyle");
            }
            resp.setVersion(txt);
        }
        tag = parser.nextTag();
        String name = parser.getName();
        while (!SLDUtils.isStr(name, ent_name) || tag != 3) {
            switch (tag) {
                case 2: {
                    if (SLDUtils.isStr(name, "Name")) {
                        txt = parser.nextText();
                        resp.setName(txt);
                        parser.nextTag();
                        break;
                    }
                    if (SLDUtils.isStr(name, "Title")) {
                        txt = parser.nextText();
                        resp.setTitle(txt);
                        parser.nextTag();
                        break;
                    }
                    if (SLDUtils.isStr(name, "Description") || SLDUtils.isStr(name, "Abstract")) {
                        txt = parser.nextText();
                        resp.setDescription(txt);
                        parser.nextTag();
                        break;
                    }
                    if (SLDUtils.isStr(name, "FeatureTypeName")) {
                        txt = parser.nextText();
                        resp.setFeatureTypeName(txt);
                        parser.nextTag();
                        break;
                    }
                    if (SLDUtils.isStr(name, "SemanticTypeIdentifier")) {
                        txt = parser.nextText();
                        resp.getSemanticTypeIdentifiers().add(txt);
                        parser.nextTag();
                        break;
                    }
                    if (SLDUtils.isStr(name, "Rule")) {
                        SLDRule rule = RuleElement.parse(parser, version);
                        resp.getRules().add(rule);
                        break;
                    }
                    throw new SLDReadException("Bad SLD file. Unexpected entity in feature[type] style: " + name);
                }
                case 3: {
                    break;
                }
            }
            tag = parser.getEventType();
            name = parser.getName();
        }
        parser.nextTag();
        return resp;
    }
}

