/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.sldsupport.impl.sld.parsing;

import java.io.IOException;
import java.util.List;
import org.gvsig.sldsupport.exception.InvalidSLDObjectException;
import org.gvsig.sldsupport.exception.SLDReadException;
import org.gvsig.sldsupport.exception.UnsupportedSLDObjectException;
import org.gvsig.sldsupport.impl.sld.parsing.LayerFeatureConstraintsElement;
import org.gvsig.sldsupport.impl.sld.parsing.NamedStyleElement;
import org.gvsig.sldsupport.impl.sld.parsing.UserStyleElement;
import org.gvsig.sldsupport.impl.util.SLDUtils;
import org.gvsig.sldsupport.impl.util.XmlBuilder;
import org.gvsig.sldsupport.sld.constraints.SLDLayerFeatureConstraints;
import org.gvsig.sldsupport.sld.layer.SLDNamedLayer;
import org.gvsig.sldsupport.sld.style.layer.SLDNamedStyle;
import org.gvsig.sldsupport.sld.style.layer.SLDUserStyle;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class NamedLayerElement {
    public static void append(SLDNamedLayer obj, XmlBuilder xb, String version) throws InvalidSLDObjectException, UnsupportedSLDObjectException {
        xb.openTag("NamedLayer");
        if (obj.getName() == null) {
            throw new InvalidSLDObjectException("NamedLayer", "No name found");
        }
        xb.writeTag("Name", obj.getName());
        if (obj.getLayerFeatureConstraints() != null) {
            LayerFeatureConstraintsElement.append(obj.getLayerFeatureConstraints(), xb, version);
        }
        List stys = obj.getStyles();
        for (int i = 0; i < stys.size(); ++i) {
            if (stys.get(i) instanceof SLDNamedStyle) {
                NamedStyleElement.append((SLDNamedStyle)stys.get(i), xb, version);
                continue;
            }
            if (!(stys.get(i) instanceof SLDUserStyle)) continue;
            UserStyleElement.append((SLDUserStyle)stys.get(i), xb, version);
        }
        xb.closeTag();
    }

    public static SLDNamedLayer parse(XmlPullParser parser, String version) throws XmlPullParserException, IOException, SLDReadException {
        parser.require(2, null, "NamedLayer");
        int tag = 0;
        SLDNamedLayer resp = new SLDNamedLayer();
        tag = parser.nextTag();
        String name = parser.getName();
        String txt = null;
        while (!SLDUtils.isStr(name, "NamedLayer") || tag != 3) {
            switch (tag) {
                case 2: {
                    if (SLDUtils.isStr(name, "Name")) {
                        txt = parser.nextText();
                        resp.setName(txt);
                        parser.nextTag();
                        break;
                    }
                    if (SLDUtils.isStr(name, "LayerFeatureConstraints")) {
                        SLDLayerFeatureConstraints cons = null;
                        cons = LayerFeatureConstraintsElement.parse(parser, version);
                        resp.setLayerFeatureConstraints(cons);
                        break;
                    }
                    if (SLDUtils.isStr(name, "NamedStyle")) {
                        SLDNamedStyle ns = NamedStyleElement.parse(parser, version);
                        resp.getStyles().add(ns);
                        break;
                    }
                    if (SLDUtils.isStr(name, "UserStyle")) {
                        SLDUserStyle us = UserStyleElement.parse(parser, version);
                        resp.getStyles().add(us);
                        break;
                    }
                    throw new SLDReadException("Bad SLD file. Unexpected entity in named layer: " + name);
                }
                case 3: {
                    break;
                }
            }
            tag = parser.getEventType();
            name = parser.getName();
        }
        parser.nextTag();
        return resp;
    }
}

