/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.sldsupport.impl.sld.parsing;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.gvsig.sldsupport.exception.InvalidSLDObjectException;
import org.gvsig.sldsupport.exception.SLDReadException;
import org.gvsig.sldsupport.exception.UnsupportedSLDObjectException;
import org.gvsig.sldsupport.impl.sld.parsing.expression.ExpressionElement;
import org.gvsig.sldsupport.impl.util.SLDUtils;
import org.gvsig.sldsupport.impl.util.XmlBuilder;
import org.gvsig.sldsupport.sld.filter.expression.SLDExpression;
import org.gvsig.sldsupport.sld.filter.expression.operator.SLDLiteral;
import org.gvsig.sldsupport.sld.symbol.misc.SLDSvgCssParameter;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class SvgCssParameterElement {
    public static void append(SLDSvgCssParameter obj, XmlBuilder xb, String version) throws InvalidSLDObjectException, UnsupportedSLDObjectException {
        String v = version;
        if (v == null) {
            v = "1.0.0";
        }
        String entName = "";
        entName = v.compareToIgnoreCase("1.1.0") == 0 ? "SvgParameter" : "CssParameter";
        HashMap<String, String> atts = new HashMap<String, String>();
        atts.put("name", obj.getName());
        xb.openTag(entName, atts);
        List list = obj.getExpressionList();
        if (list == null || list.size() == 0) {
            throw new InvalidSLDObjectException(entName, "No expressions found for att: " + obj.getName());
        }
        for (int i = 0; i < list.size(); ++i) {
            ExpressionElement.append((SLDExpression)list.get(i), xb, version);
        }
        xb.closeTag();
    }

    public static SLDSvgCssParameter parse(XmlPullParser parser, String version) throws XmlPullParserException, IOException, SLDReadException {
        String ent_name = parser.getName();
        if (!SLDUtils.isStr(ent_name, "SvgParameter") && !SLDUtils.isStr(ent_name, "CssParameter")) {
            throw new SLDReadException("Expected SVG or CSS parameter entity. Found: " + ent_name);
        }
        SLDSvgCssParameter resp = new SLDSvgCssParameter();
        String att = parser.getAttributeValue(null, "name");
        if (att == null) {
            throw new SLDReadException("Missing name in Svg/CssParameter");
        }
        resp.setName(att);
        String txt = SLDUtils.getTextUntilTag(parser);
        int tag = parser.getEventType();
        String name = parser.getName();
        if (SLDUtils.isStr(name, ent_name) && tag == 3) {
            SLDLiteral lit = new SLDLiteral();
            lit.setValue(txt);
            parser.nextTag();
            resp.getExpressionList().add(lit);
            return resp;
        }
        SLDExpression expre = null;
        while (!SLDUtils.isStr(name, ent_name) || tag != 3) {
            expre = ExpressionElement.parse(parser, version);
            resp.getExpressionList().add(expre);
            tag = parser.getEventType();
            name = parser.getName();
        }
        parser.nextTag();
        return resp;
    }
}

