/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.sldsupport.impl.sld.parsing.expression;

import java.io.IOException;
import org.gvsig.sldsupport.exception.InvalidSLDObjectException;
import org.gvsig.sldsupport.exception.SLDReadException;
import org.gvsig.sldsupport.exception.UnsupportedSLDObjectException;
import org.gvsig.sldsupport.impl.sld.parsing.expression.ArithmeticElement;
import org.gvsig.sldsupport.impl.sld.parsing.expression.FunctionElement;
import org.gvsig.sldsupport.impl.util.SLDUtils;
import org.gvsig.sldsupport.impl.util.XmlBuilder;
import org.gvsig.sldsupport.sld.filter.expression.SLDExpression;
import org.gvsig.sldsupport.sld.filter.expression.operator.SLDArithmeticOperator;
import org.gvsig.sldsupport.sld.filter.expression.operator.SLDFunction;
import org.gvsig.sldsupport.sld.filter.expression.operator.SLDLiteral;
import org.gvsig.sldsupport.sld.filter.expression.operator.SLDPropertyName;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class ExpressionElement {
    public static void append(SLDExpression obj, XmlBuilder xb, String version) throws InvalidSLDObjectException, UnsupportedSLDObjectException {
        if (obj instanceof SLDLiteral) {
            SLDLiteral lit = (SLDLiteral)obj;
            xb.writeTag("Literal", lit.getValue());
        } else if (obj instanceof SLDArithmeticOperator) {
            ArithmeticElement.append((SLDArithmeticOperator)obj, xb, version);
        } else if (obj instanceof SLDFunction) {
            FunctionElement.append((SLDFunction)obj, xb, version);
        } else if (obj instanceof SLDPropertyName) {
            SLDPropertyName pn = (SLDPropertyName)obj;
            xb.writeTag("PropertyName", pn.getPropertyName());
        }
    }

    public static SLDExpression parse(XmlPullParser parser, String version) throws XmlPullParserException, IOException, SLDReadException {
        String name = parser.getName();
        if (SLDUtils.isStr(name, "PropertyName")) {
            SLDPropertyName pn = new SLDPropertyName();
            String txt = parser.nextText();
            pn.setPropertyName(txt);
            parser.nextTag();
            return pn;
        }
        if (SLDUtils.isStr(name, "Literal")) {
            SLDLiteral lit = new SLDLiteral();
            String txt = parser.nextText();
            lit.setValue(txt);
            parser.nextTag();
            return lit;
        }
        if (SLDUtils.isStr(name, "Add") || SLDUtils.isStr(name, "Sub") || SLDUtils.isStr(name, "Mul") || SLDUtils.isStr(name, "Div")) {
            return ArithmeticElement.parse(parser, version);
        }
        if (SLDUtils.isStr(name, "Function")) {
            return FunctionElement.parse(parser, version);
        }
        throw new SLDReadException("Unexpected entity in expression: " + name);
    }
}

