/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.buffer;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.noding.SegmentString;
import com.vividsolutions.jts.operation.buffer.BufferParameters;
import com.vividsolutions.jts.operation.buffer.OffsetCurveBuilder;
import com.vividsolutions.jts.operation.buffer.OffsetCurveSetBuilder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.h2gis.api.DeterministicScalarFunction;

public class ST_OffSetCurve
extends DeterministicScalarFunction {
    public ST_OffSetCurve() {
        this.addProperty("remarks", "Return an offset line or collection of lines at a given distance and side from an input geometry.\nThe optional third parameter can either specify number of segments used\n to approximate a quarter circle (integer case, defaults to 8)\n or a list of blank-separated key=value pairs (string case) to manage line style parameters :\n'quad_segs=8' endcap=round|flat|square' 'join=round|mitre|bevel' 'mitre_limit=5'");
    }

    public String getJavaStaticMethod() {
        return "offsetCurve";
    }

    public static Geometry offsetCurve(Geometry geometry, double offset, String parameters) {
        if (geometry == null) {
            return null;
        }
        String[] buffParemeters = parameters.split("\\s+");
        BufferParameters bufferParameters = new BufferParameters();
        for (String params : buffParemeters) {
            String param;
            String[] keyValue = params.split("=");
            if (keyValue[0].equalsIgnoreCase("endcap")) {
                param = keyValue[1];
                if (param.equalsIgnoreCase("round")) {
                    bufferParameters.setEndCapStyle(1);
                    continue;
                }
                if (param.equalsIgnoreCase("flat") || param.equalsIgnoreCase("butt")) {
                    bufferParameters.setEndCapStyle(2);
                    continue;
                }
                if (param.equalsIgnoreCase("square")) {
                    bufferParameters.setEndCapStyle(3);
                    continue;
                }
                throw new IllegalArgumentException("Supported join values are round, flat, butt or square.");
            }
            if (keyValue[0].equalsIgnoreCase("join")) {
                param = keyValue[1];
                if (param.equalsIgnoreCase("bevel")) {
                    bufferParameters.setJoinStyle(3);
                    continue;
                }
                if (param.equalsIgnoreCase("mitre") || param.equalsIgnoreCase("miter")) {
                    bufferParameters.setJoinStyle(2);
                    continue;
                }
                if (param.equalsIgnoreCase("round")) {
                    bufferParameters.setJoinStyle(1);
                    continue;
                }
                throw new IllegalArgumentException("Supported join values are bevel, mitre, miter or round.");
            }
            if (keyValue[0].equalsIgnoreCase("mitre_limit") || keyValue[0].equalsIgnoreCase("miter_limit")) {
                bufferParameters.setMitreLimit(Double.valueOf(keyValue[1]).doubleValue());
                continue;
            }
            if (keyValue[0].equalsIgnoreCase("quad_segs")) {
                bufferParameters.setQuadrantSegments(Integer.valueOf(keyValue[1]).intValue());
                continue;
            }
            throw new IllegalArgumentException("Unknown parameters. Please read the documentation.");
        }
        return ST_OffSetCurve.computeOffsetCurve(geometry, offset, bufferParameters);
    }

    public static Geometry offsetCurve(Geometry geometry, double offset) {
        return ST_OffSetCurve.computeOffsetCurve(geometry, offset, new BufferParameters());
    }

    public static Geometry computeOffsetCurve(Geometry geometry, double offset, BufferParameters bufferParameters) {
        ArrayList<LineString> lineStrings = new ArrayList<LineString>();
        for (int i = 0; i < geometry.getNumGeometries(); ++i) {
            Geometry subGeom = geometry.getGeometryN(i);
            if (subGeom.getDimension() == 1) {
                ST_OffSetCurve.lineStringOffSetCurve(lineStrings, (LineString)subGeom, offset, bufferParameters);
                continue;
            }
            ST_OffSetCurve.geometryOffSetCurve(lineStrings, subGeom, offset, bufferParameters);
        }
        if (!lineStrings.isEmpty()) {
            if (lineStrings.size() == 1) {
                return (Geometry)lineStrings.get(0);
            }
            return geometry.getFactory().createMultiLineString(lineStrings.toArray(new LineString[lineStrings.size()]));
        }
        return null;
    }

    public static void lineStringOffSetCurve(ArrayList<LineString> list, LineString lineString, double offset, BufferParameters bufferParameters) {
        list.add(lineString.getFactory().createLineString(new OffsetCurveBuilder(lineString.getPrecisionModel(), bufferParameters).getOffsetCurve(lineString.getCoordinates(), offset)));
    }

    public static void geometryOffSetCurve(ArrayList<LineString> list, Geometry geometry, double offset, BufferParameters bufferParameters) {
        List curves = new OffsetCurveSetBuilder(geometry, offset, new OffsetCurveBuilder(geometry.getFactory().getPrecisionModel(), bufferParameters)).getCurves();
        Iterator iterator = curves.iterator();
        while (iterator.hasNext()) {
            list.add(geometry.getFactory().createLineString(((SegmentString)iterator.next()).getCoordinates()));
        }
    }
}

