/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.earth;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequenceFilter;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.operation.union.CascadedPolygonUnion;
import java.util.ArrayList;
import java.util.Collection;
import org.h2gis.api.DeterministicScalarFunction;
import org.h2gis.functions.spatial.edit.ST_UpdateZ;

public class ST_GeometryShadow
extends DeterministicScalarFunction {
    public ST_GeometryShadow() {
        this.addProperty("remarks", "This function computes the shadow footprint as a polygon(s) for a LINE and a POLYGON \nor LINE for a POINT.Avalaible arguments are :\n(1) The geometry.(2 and 3) The position of the sun is specified with two parameters in radians : azimuth and altitude.\n(4) The height value is used to extrude the facades of geometry.\n(5) Optional parameter to unified or not the shadow polygons. True is the default value.\nNote 1: The z of the output geometry is set to 0.\nNote 2: The azimuth is a direction along the horizon, measured from north to east.\nThe altitude is expressed above the horizon in radians, e.g. 0 at the horizon and PI/2 at the zenith.\nThe user can set the azimut and the altitude using a point see ST_SunPosition function,\nthe folowing signature must be used ST_GeometryShadow(INPUT_GEOM,ST_SUNPosition(), HEIGHT).");
    }

    public String getJavaStaticMethod() {
        return "computeShadow";
    }

    public static Geometry computeShadow(Geometry geometry, Geometry sunPosition, double height) {
        if (sunPosition != null) {
            if (sunPosition instanceof Point) {
                return ST_GeometryShadow.computeShadow(geometry, sunPosition.getCoordinate().x, sunPosition.getCoordinate().y, height, true);
            }
            throw new IllegalArgumentException("The sun position must be stored in a point with \nx = sun azimuth in radians (direction along the horizon, measured from north to\neast and y = sun altitude above the horizon in radians.");
        }
        return null;
    }

    public static Geometry computeShadow(Geometry geometry, double azimuth, double altitude, double height) {
        return ST_GeometryShadow.computeShadow(geometry, azimuth, altitude, height, true);
    }

    public static Geometry computeShadow(Geometry geometry, double azimuth, double altitude, double height, boolean doUnion) {
        if (geometry == null) {
            return null;
        }
        if (height <= 0.0) {
            throw new IllegalArgumentException("The height of the geometry must be greater than 0.");
        }
        double[] shadowOffSet = ST_GeometryShadow.shadowOffset(azimuth, altitude, height);
        if (geometry instanceof Polygon) {
            return ST_GeometryShadow.shadowPolygon((Polygon)geometry, shadowOffSet, geometry.getFactory(), doUnion);
        }
        if (geometry instanceof LineString) {
            return ST_GeometryShadow.shadowLine((LineString)geometry, shadowOffSet, geometry.getFactory(), doUnion);
        }
        if (geometry instanceof Point) {
            return ST_GeometryShadow.shadowPoint((Point)geometry, shadowOffSet, geometry.getFactory());
        }
        throw new IllegalArgumentException("The shadow function supports only single geometry POINT, LINE or POLYGON.");
    }

    private static Geometry shadowLine(LineString lineString, double[] shadowOffset, GeometryFactory factory, boolean doUnion) {
        Coordinate[] coords = lineString.getCoordinates();
        ArrayList<Polygon> shadows = new ArrayList<Polygon>();
        ST_GeometryShadow.createShadowPolygons(shadows, coords, shadowOffset, factory);
        if (!doUnion) {
            return factory.buildGeometry(shadows);
        }
        if (!shadows.isEmpty()) {
            CascadedPolygonUnion union = new CascadedPolygonUnion(shadows);
            Geometry result = union.union();
            result.apply((CoordinateSequenceFilter)new ST_UpdateZ.UpdateZCoordinateSequenceFilter(0.0, 1));
            return result;
        }
        return null;
    }

    private static Geometry shadowPolygon(Polygon polygon, double[] shadowOffset, GeometryFactory factory, boolean doUnion) {
        Coordinate[] shellCoords = polygon.getExteriorRing().getCoordinates();
        ArrayList<Polygon> shadows = new ArrayList<Polygon>();
        ST_GeometryShadow.createShadowPolygons(shadows, shellCoords, shadowOffset, factory);
        int nbOfHoles = polygon.getNumInteriorRing();
        for (int i = 0; i < nbOfHoles; ++i) {
            ST_GeometryShadow.createShadowPolygons(shadows, polygon.getInteriorRingN(i).getCoordinates(), shadowOffset, factory);
        }
        if (!doUnion) {
            return factory.buildGeometry(shadows);
        }
        if (!shadows.isEmpty()) {
            ArrayList<Geometry> shadowParts = new ArrayList<Geometry>();
            for (Polygon shadowPolygon : shadows) {
                shadowParts.add(shadowPolygon.difference((Geometry)polygon));
            }
            Geometry allShadowParts = factory.buildGeometry(shadowParts);
            Geometry union = allShadowParts.buffer(0.0);
            union.apply((CoordinateSequenceFilter)new ST_UpdateZ.UpdateZCoordinateSequenceFilter(0.0, 1));
            return union;
        }
        return null;
    }

    private static Geometry shadowPoint(Point point, double[] shadowOffset, GeometryFactory factory) {
        Coordinate startCoord = point.getCoordinate();
        Coordinate offset = ST_GeometryShadow.moveCoordinate(startCoord, shadowOffset);
        if (offset.distance(point.getCoordinate()) < 0.01) {
            return point;
        }
        startCoord.z = 0.0;
        return factory.createLineString(new Coordinate[]{startCoord, offset});
    }

    public static double[] shadowOffset(double azimuth, double altitude, double height) {
        double spread = 1.0 / Math.tan(altitude);
        return new double[]{-height * spread * Math.sin(azimuth), -height * spread * Math.cos(azimuth)};
    }

    private static Coordinate moveCoordinate(Coordinate inputCoordinate, double[] shadowOffset) {
        return new Coordinate(inputCoordinate.x + shadowOffset[0], inputCoordinate.y + shadowOffset[1], 0.0);
    }

    private static void createShadowPolygons(Collection<Polygon> shadows, Coordinate[] coordinates, double[] shadow, GeometryFactory factory) {
        for (int i = 1; i < coordinates.length; ++i) {
            Coordinate startCoord = coordinates[i - 1];
            Coordinate endCoord = coordinates[i];
            Coordinate nextEnd = ST_GeometryShadow.moveCoordinate(endCoord, shadow);
            Coordinate nextStart = ST_GeometryShadow.moveCoordinate(startCoord, shadow);
            Polygon polygon = factory.createPolygon(new Coordinate[]{startCoord, endCoord, nextEnd, nextStart, startCoord});
            if (!polygon.isValid()) continue;
            shadows.add(polygon);
        }
    }
}

