/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.eventtheme.daltransform;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.cresques.cts.IProjection;
import org.gvsig.andami.PluginServices;
import org.gvsig.app.gui.panels.CRSSelectPanel;
import org.gvsig.app.gui.panels.crs.ISelectCrsPanel;
import org.gvsig.app.project.ProjectPreferences;
import org.gvsig.daltransform.swing.DataTransformWizard;
import org.gvsig.daltransform.swing.impl.AbstractDataTransformWizardPanel;
import org.gvsig.daltransform.swing.impl.DefaultDataTransformWizard;
import org.gvsig.daltransform.swing.impl.components.FeatureTypeCombo;
import org.gvsig.daltransform.swing.impl.components.NumericFeatureTypeAttributesCombo;
import org.gvsig.fmap.crs.CRSFactory;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;

public class EventThemeTransformPanel
extends AbstractDataTransformWizardPanel
implements ActionListener {
    private JLabel nameLabel;
    private JTextField nameText;
    private NumericFeatureTypeAttributesCombo xCombo;
    private JLabel xLabel;
    private NumericFeatureTypeAttributesCombo yCombo;
    private JLabel yLabel;
    private FeatureTypeCombo featureTypeCombo;
    private JLabel featureTypeLabel;
    private JPanel northPanel = null;
    private JTextField projectionText;
    private JLabel projectionLabel;
    private JButton projectionButton = null;

    public EventThemeTransformPanel() {
        this.initComponents();
        this.initLabels();
        this.resetProjection();
        this.featureTypeCombo.addActionListener((ActionListener)this);
        this.projectionButton.addActionListener(this);
    }

    private void resetProjection() {
        MapContext mco;
        DefaultDataTransformWizard dtw = this.getDataTransformWizard();
        if (dtw != null && (mco = dtw.getMapContext()) != null && mco.getProjection() != null) {
            this.projectionText.setText(mco.getProjection().getAbrev());
            return;
        }
        ProjectPreferences prefs = new ProjectPreferences();
        this.projectionText.setText(prefs.getDefaultProjection().getAbrev());
    }

    public void setDataTransformWizard(DataTransformWizard dtw) {
        super.setDataTransformWizard(dtw);
        this.resetProjection();
    }

    private void initLabels() {
        this.featureTypeLabel.setText(PluginServices.getText((Object)this, (String)"events_feature_type_field") + ":");
        this.xLabel.setText(PluginServices.getText((Object)this, (String)"events_x_field") + ":");
        this.yLabel.setText(PluginServices.getText((Object)this, (String)"events_y_field") + ":");
        this.nameLabel.setText(PluginServices.getText((Object)this, (String)"events_geom_field") + ":");
        this.projectionLabel.setText(PluginServices.getText((Object)this, (String)"projection") + ":");
        this.projectionButton.setText("...");
    }

    private void initComponents() {
        this.featureTypeCombo = new FeatureTypeCombo();
        this.featureTypeLabel = new JLabel();
        this.xLabel = new JLabel();
        this.xCombo = new NumericFeatureTypeAttributesCombo();
        this.yLabel = new JLabel();
        this.yCombo = new NumericFeatureTypeAttributesCombo();
        this.nameLabel = new JLabel();
        this.nameText = new JTextField();
        this.northPanel = new JPanel();
        this.projectionText = new JTextField();
        this.projectionLabel = new JLabel();
        this.projectionButton = new JButton();
        this.projectionButton.setSize(25, 25);
        this.projectionText.setEnabled(false);
        this.setLayout(new BorderLayout());
        this.northPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(5, 2, 2, 2);
        this.northPanel.add((Component)this.xLabel, gridBagConstraints);
        this.xCombo.setModel(new DefaultComboBoxModel());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(2, 2, 5, 2);
        gridBagConstraints.weightx = 1.0;
        this.northPanel.add((Component)this.xCombo, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 2, 2, 2);
        gridBagConstraints.gridwidth = 2;
        this.northPanel.add((Component)this.yLabel, gridBagConstraints);
        this.yCombo.setModel(new DefaultComboBoxModel());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 5, 2);
        gridBagConstraints.gridwidth = 2;
        this.northPanel.add((Component)this.yCombo, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 2, 2, 2);
        gridBagConstraints.gridwidth = 2;
        this.northPanel.add((Component)this.nameLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 5, 2);
        gridBagConstraints.gridwidth = 2;
        this.northPanel.add((Component)this.nameText, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(5, 2, 2, 2);
        this.northPanel.add((Component)this.projectionLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(2, 2, 5, 2);
        this.northPanel.add((Component)this.projectionText, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(2, 2, 5, 2);
        this.northPanel.add((Component)this.projectionButton, gridBagConstraints);
        this.add(this.northPanel, "North");
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event == null) {
            return;
        }
        if (event.getSource() == this.featureTypeCombo) {
            Object obj = this.featureTypeCombo.getSelectedItem();
            if (obj != null) {
                this.xCombo.addFeatureAttributes(this.featureTypeCombo.getSelectedFeatureType());
                this.yCombo.addFeatureAttributes(this.featureTypeCombo.getSelectedFeatureType());
            }
        } else if (event.getSource() == this.projectionButton) {
            ISelectCrsPanel panel = CRSSelectPanel.getUIFactory().getSelectCrsPanel(CRSFactory.getCRS((String)this.projectionText.getText()), false);
            ToolsSwingLocator.getWindowManager().showWindow(panel.asJComponent(), ToolsLocator.getI18nManager().getTranslation("selecciona_sistema_de_referencia"), WindowManager.MODE.DIALOG);
            if (panel.isOkPressed()) {
                IProjection proj = panel.getProjection();
                this.projectionText.setText(proj.getAbrev());
            }
        }
    }

    public String getGeometryName() {
        return this.nameText.getText();
    }

    public String getXName() {
        return this.xCombo.getSelectedFeatureAttributeDescriptor().getName();
    }

    public String getYName() {
        return this.yCombo.getSelectedFeatureAttributeDescriptor().getName();
    }

    public void updatePanel() {
        this.featureTypeCombo.addFeatureStore(this.getFeatureStore());
        if (this.nameText != null) {
            this.nameText.setText(this.suggestedGeomFieldName(this.getFeatureStore()));
        }
    }

    public IProjection getProjection() {
        return CRSFactory.getCRS((String)this.projectionText.getText());
    }

    private String suggestedGeomFieldName(FeatureStore fsto) {
        if (fsto == null) {
            return "";
        }
        FeatureType ft = fsto.getDefaultFeatureTypeQuietly();
        if (ft == null) {
            logger.info("Unable to suggest geom field name, can't access to the feature type.");
            return "";
        }
        if (ft.getAttributeDescriptor("geometry") == null) {
            return "geometry";
        }
        if (ft.getAttributeDescriptor("geom") == null) {
            return "geom";
        }
        String aux = "";
        int i = -1;
        while (ft.getAttributeDescriptor(aux = "geom" + ++i) != null) {
        }
        return aux;
    }
}

