/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.symbology.swing.impl.pickercontroller;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.gvsig.app.gui.styling.SymbolSelector;
import org.gvsig.app.project.documents.view.legend.gui.ISymbolSelector;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.fmap.mapcontext.rendering.symbols.SymbolDrawingException;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.swing.api.pickercontroller.AbstractPickerController;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;

public class SymbolPickerController
extends AbstractPickerController<ISymbol> {
    private final JButton btnPreview;
    private final JTextComponent txtDescription;
    private int geomType;
    private ISymbol symbol;

    public SymbolPickerController(JButton btnPreview, JTextComponent txtDescription, int geomType, ISymbol symbol) {
        this.btnPreview = btnPreview;
        this.txtDescription = txtDescription == null ? new JTextField() : txtDescription;
        this.symbol = symbol;
        if (this.symbol == null) {
            this.symbol = MapContextLocator.getSymbolManager().createSymbol(geomType);
        }
        this.btnPreview.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.btnPreview.setText("");
        this.btnPreview.addActionListener(e -> this.doSelectSymbol());
        this.btnPreview.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                SymbolPickerController.this.updatePreview();
            }
        });
        this.set(this.symbol);
    }

    private void updatePreview() {
        Dimension previewSize = this.btnPreview.getSize();
        if (previewSize.width < 22) {
            previewSize.width = 22;
        }
        if (previewSize.height < 22) {
            previewSize.height = 22;
        }
        Dimension size = new Dimension(previewSize.width - 4, previewSize.height - 4);
        this.btnPreview.setIcon(new ImageIcon(this.createPreview(size, this.symbol)));
    }

    private BufferedImage createPreview(Dimension size, ISymbol symbol) {
        BufferedImage previewImage = new BufferedImage(size.width, size.height, 2);
        Graphics2D g2 = previewImage.createGraphics();
        if (g2 != null) {
            Rectangle bounds = new Rectangle(size.width, size.height);
            ISymbol prevSymbol = symbol;
            try {
                prevSymbol.drawInsideRectangle(g2, new AffineTransform(), bounds);
            }
            catch (Exception e) {
                try {
                    prevSymbol = MapContextLocator.getSymbolManager().getWarningSymbol(SymbolDrawingException.STR_UNSUPPORTED_SET_OF_SETTINGS, symbol.getDescription(), 0);
                    prevSymbol.drawInsideRectangle(g2, g2.getTransform(), bounds);
                }
                catch (Exception e1) {
                    LOG.debug("Can't create preview symbol", (Throwable)e1);
                }
            }
        }
        return previewImage;
    }

    private void doSelectSymbol() {
        WindowManager wm = ToolsSwingLocator.getWindowManager();
        ISymbolSelector sSelect = SymbolSelector.createSymbolSelector((Object)this.symbol, (int)this.geomType);
        Dimension desktopPanelSize = ToolsSwingUtils.getDesktopPanelSize();
        ToolsSwingUtils.ensureHeightWitdh((JComponent)((JPanel)sSelect), (int)Math.max(3 * (desktopPanelSize.height / 4), ToolsSwingUtils.rows2px((int)80)), (int)Math.max(2 * (desktopPanelSize.width / 4), ToolsSwingUtils.cols2px((int)35)), (int)(7 * (desktopPanelSize.height / 8)), (int)(3 * (desktopPanelSize.width / 4)));
        wm.showWindow((JComponent)((JPanel)sSelect), sSelect.getWindowInfo().getTitle(), WindowManager.MODE.DIALOG);
        if (sSelect.getSelectedObject() != null) {
            this.symbol = (ISymbol)sSelect.getSelectedObject();
            this.updatePreview();
            this.fireChangeEvent();
        }
    }

    public ISymbol get() {
        this.symbol.setDescription(this.txtDescription.getText());
        return this.symbol;
    }

    public final void set(ISymbol symbol) {
        this.symbol = symbol;
        this.geomType = symbol.getSymbolType();
        this.txtDescription.setText(this.symbol.getDescription());
        this.updatePreview();
    }

    public void coerceAndSet(Object o) {
        this.set((ISymbol)o);
    }

    public void setEnabled(boolean enabled) {
        this.btnPreview.setEnabled(enabled);
        this.txtDescription.setEnabled(enabled);
    }

    public boolean isEnabled() {
        return this.btnPreview.isEnabled();
    }
}

